/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.common.outputs.log;

import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import org.openjdk.asmtools.common.outputs.PrintWriterOutput;
import org.openjdk.asmtools.common.outputs.ToolOutput;
import org.openjdk.asmtools.common.outputs.log.NamedDualStreamToolOutput;

public class DualOutputStreamOutput
extends NamedDualStreamToolOutput {
    protected PrintWriter os;
    protected PrintWriter es;

    public DualOutputStreamOutput() {
        this(System.out, System.err);
    }

    public DualOutputStreamOutput(PrintWriter os, PrintWriter er) {
        this.os = os;
        this.es = er;
    }

    public DualOutputStreamOutput(PrintStream os, PrintStream er) {
        this.os = new PrintWriter(os, true);
        this.es = new PrintWriter(er, true);
    }

    @Override
    public void printlns(String line) {
        this.os.println(line);
    }

    @Override
    public void prints(String line) {
        this.os.print(line);
    }

    @Override
    public void prints(char line) {
        this.os.print(line);
    }

    @Override
    public void printlne(String line) {
        this.es.println(line);
    }

    @Override
    public void printe(String line) {
        this.es.print(line);
    }

    @Override
    public void printe(char line) {
        this.es.print(line);
    }

    @Override
    public void finishClass(String fqn) throws IOException {
        super.finishClass(fqn);
        try {
            this.os.flush();
        }
        finally {
            this.es.flush();
        }
    }

    @Override
    public void stacktrace(Throwable ex) {
        ex.printStackTrace(this.es);
    }

    @Override
    public ToolOutput getSToolObject() {
        return new PrintWriterOutput(this.os);
    }

    @Override
    public ToolOutput getEToolObject() {
        return new PrintWriterOutput(this.es);
    }

    @Override
    public void flush() {
        this.os.flush();
        this.es.flush();
    }
}

