/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jasm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.openjdk.asmtools.common.structure.EAttribute;
import org.openjdk.asmtools.jasm.AttrData;
import org.openjdk.asmtools.jasm.CheckedDataOutputStream;
import org.openjdk.asmtools.jasm.ConstCell;
import org.openjdk.asmtools.jasm.ConstantPool;

public class ArrayAttr
extends AttrData {
    List<ConstCell> cells = new ArrayList<ConstCell>();

    public ArrayAttr(ConstantPool pool, EAttribute attribute, List<ConstCell> constCellList) {
        super(pool, attribute);
        for (ConstCell cell : constCellList) {
            this.cells.add(this.classifyConstCell(pool, cell));
        }
    }

    public int size() {
        return this.cells.size();
    }

    @Override
    public int attrLength() {
        return 2 + this.cells.size() * 2;
    }

    @Override
    public void write(CheckedDataOutputStream out) throws IOException {
        super.write(out);
        out.writeShort(this.cells.size());
        for (ConstCell c : this.cells) {
            out.writeShort(c.cpIndex);
        }
    }
}

