/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jasm;

import java.io.IOException;
import org.openjdk.asmtools.jasm.CheckedDataOutputStream;
import org.openjdk.asmtools.jasm.ConstCell;
import org.openjdk.asmtools.jasm.ConstantPool;
import org.openjdk.asmtools.jasm.DataWriter;

public class ConstantPoolIndexData
implements DataWriter {
    ConstCell nameAndType = null;
    ConstantPool pool = null;
    int cpIndex = -1;

    public ConstantPoolIndexData(ConstCell nameAndType, ConstantPool pool) {
        this.nameAndType = nameAndType;
        this.pool = pool;
    }

    public ConstantPoolIndexData(int cpIndex) {
        this.cpIndex = cpIndex;
    }

    @Override
    public void write(CheckedDataOutputStream out) throws IOException {
        if (this.cpIndex == -1) {
            this.cpIndex = this.nameAndType.cpIndex;
        }
        if (this.cpIndex == -1) {
            throw new IOException("a file due to implementation issue:\n\t\t \"Can't retrieve CP Index for %s\"".formatted(this.nameAndType == null ? "null" : this.nameAndType.toString()));
        }
        out.writeShort(this.cpIndex);
    }

    @Override
    public int getLength() {
        return 2;
    }
}

