/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jasm;

import java.io.IOException;
import org.openjdk.asmtools.common.structure.EAttribute;
import org.openjdk.asmtools.jasm.AttrData;
import org.openjdk.asmtools.jasm.CheckedDataOutputStream;
import org.openjdk.asmtools.jasm.ClassFileConst;
import org.openjdk.asmtools.jasm.ConstCell;
import org.openjdk.asmtools.jasm.ConstantPool;

public class EnclosingMethodAttr
extends AttrData {
    private ConstantPool pool;
    private ConstCell classCell;
    private ConstCell methodCell;

    EnclosingMethodAttr(ConstantPool pool, ConstCell classCell, ConstCell methodCell) {
        super(pool, EAttribute.ATT_EnclosingMethod);
        this.pool = pool;
        this.classCell = classCell;
        this.methodCell = methodCell;
    }

    @Override
    public int attrLength() {
        return 4;
    }

    @Override
    protected ConstCell<?> classifyConstCell(ConstantPool pool, ConstCell<?> cell) {
        return pool.findCell(ClassFileConst.ConstType.CONSTANT_METHODREF, cell);
    }

    @Override
    public void write(CheckedDataOutputStream out) throws IOException {
        super.write(out);
        if (!this.classCell.isSet()) {
            this.classCell = this.pool.specifyCell(this.classCell);
            if (!this.pool.getBounds().in(this.classCell.cpIndex)) {
                this.pool.environment.throwErrorException("err.entity.not.in.cp", this.classCell);
            }
        }
        out.writeShort(this.classCell.cpIndex);
        if (this.methodCell != null && !this.methodCell.isSet()) {
            this.methodCell = this.pool.specifyCell(this.methodCell);
            if (!this.pool.getBounds().in(this.methodCell.cpIndex)) {
                this.pool.environment.throwErrorException("err.entity.not.in.cp", this.methodCell);
            }
        }
        out.writeShort(this.methodCell != null ? this.methodCell.cpIndex : 0);
    }
}

