/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jasm;

import java.util.ArrayList;
import org.openjdk.asmtools.common.Environment;
import org.openjdk.asmtools.common.ToolLogger;
import org.openjdk.asmtools.common.structure.EAttribute;
import org.openjdk.asmtools.common.structure.ELocation;
import org.openjdk.asmtools.common.structure.EModifier;
import org.openjdk.asmtools.jasm.AnnotationData;
import org.openjdk.asmtools.jasm.AttrData;
import org.openjdk.asmtools.jasm.CPXAttr;
import org.openjdk.asmtools.jasm.ConstCell;
import org.openjdk.asmtools.jasm.ConstantPool;
import org.openjdk.asmtools.jasm.DataVector;
import org.openjdk.asmtools.jasm.DataVectorAttr;
import org.openjdk.asmtools.jasm.DataWriter;
import org.openjdk.asmtools.jasm.JasmTokens;
import org.openjdk.asmtools.jasm.TypeAnnotationData;

public abstract class MemberData<T extends Environment<? extends ToolLogger>> {
    protected final ConstantPool pool;
    private final T environment;
    protected int access;
    protected AttrData syntheticAttr;
    protected AttrData deprecatedAttr;
    protected DataVectorAttr<AnnotationData> annotAttrVis = null;
    protected DataVectorAttr<AnnotationData> annotAttrInv = null;
    protected DataVectorAttr<TypeAnnotationData> type_annotAttrVis = null;
    protected DataVectorAttr<TypeAnnotationData> type_annotAttrInv = null;
    protected AttrData signatureAttr;
    protected ELocation attributeLocation = ELocation.unknown;

    public MemberData(ConstantPool pool, T environment) {
        this(pool, environment, 0);
    }

    public MemberData(ConstantPool pool, T environment, int access) {
        this.pool = pool;
        this.environment = environment;
        this.access = access;
    }

    protected <M extends MemberData<?>> boolean checkExistence(EAttribute attribute) {
        throw new RuntimeException("Not implemented yet");
    }

    protected <M extends MemberData<?>> M checkExistence(EAttribute attribute, Runnable action) {
        if (this.checkExistence(attribute)) {
            action.run();
        }
        return (M)this;
    }

    protected <M extends MemberData<?>> M andThenCheck(EAttribute attribute, Runnable action) {
        return this.checkExistence(attribute, action);
    }

    public void createPseudoMod() {
        if (EModifier.isSyntheticPseudoMod(this.access)) {
            this.syntheticAttr = new AttrData(this.pool, EAttribute.ATT_Synthetic);
            this.access &= ~EModifier.SYNTHETIC_ATTRIBUTE.getFlag();
        }
        if (EModifier.isDeprecatedPseudoMod(this.access)) {
            this.deprecatedAttr = new AttrData(this.pool, EAttribute.ATT_Deprecated);
            this.access &= ~EModifier.DEPRECATED_ATTRIBUTE.getFlag();
        }
    }

    public T getEnvironment() {
        return this.environment;
    }

    public ConstantPool getPool() {
        return this.pool;
    }

    public void setSignatureAttr(ConstCell value_cpx) {
        if (this.signatureAttr != null) {
            CPXAttr cpx = (CPXAttr)this.signatureAttr;
            if (value_cpx.cpIndex != cpx.cell.cpIndex) {
                this.environment.warning("warn.redeclared.attribute", JasmTokens.Token.SIGNATURE.parseKey(), this.attributeLocation.getDescription());
            }
        }
        this.signatureAttr = new CPXAttr(this.pool, EAttribute.ATT_Signature, value_cpx);
    }

    public void setSignatureAttr(ConstCell value_cpx, long position) {
        if (this.signatureAttr != null) {
            CPXAttr cpx = (CPXAttr)this.signatureAttr;
            if (value_cpx.cpIndex != cpx.cell.cpIndex) {
                this.environment.warning(position, "warn.redeclared.attribute", JasmTokens.Token.SIGNATURE.parseKey(), this.attributeLocation.getDescription());
            }
        }
        this.signatureAttr = new CPXAttr(this.pool, EAttribute.ATT_Signature, value_cpx);
    }

    public AttrData getSignatureAttr() {
        return this.signatureAttr;
    }

    protected abstract <D extends DataWriter> DataVector<D> getAttrVector();

    @SafeVarargs
    protected final <D extends DataWriter> DataVector<D> getDataVector(D ... extraAttrs) {
        DataVector<Object> attrs = new DataVector<Object>();
        for (D extra : extraAttrs) {
            if (extra == null) continue;
            attrs.add(extra);
        }
        if (this.annotAttrVis != null) {
            attrs.add(this.annotAttrVis);
        }
        if (this.annotAttrInv != null) {
            attrs.add(this.annotAttrInv);
        }
        if (this.type_annotAttrVis != null) {
            attrs.add(this.type_annotAttrVis);
        }
        if (this.type_annotAttrInv != null) {
            attrs.add(this.type_annotAttrInv);
        }
        return attrs;
    }

    public MemberData<T> addAnnotations(ArrayList<AnnotationData> list) {
        if (list != null) {
            for (AnnotationData item : list) {
                boolean invisible = item.invisible;
                if (item instanceof TypeAnnotationData) {
                    TypeAnnotationData typeAnnotationData = (TypeAnnotationData)item;
                    if (invisible) {
                        if (this.type_annotAttrInv == null) {
                            this.type_annotAttrInv = new DataVectorAttr(this.pool, EAttribute.ATT_RuntimeInvisibleTypeAnnotations);
                        }
                        this.type_annotAttrInv.add(typeAnnotationData);
                        continue;
                    }
                    if (this.type_annotAttrVis == null) {
                        this.type_annotAttrVis = new DataVectorAttr(this.pool, EAttribute.ATT_RuntimeVisibleTypeAnnotations);
                    }
                    this.type_annotAttrVis.add(typeAnnotationData);
                    continue;
                }
                if (invisible) {
                    if (this.annotAttrInv == null) {
                        this.annotAttrInv = new DataVectorAttr(this.pool, EAttribute.ATT_RuntimeInvisibleAnnotations);
                    }
                    this.annotAttrInv.add(item);
                    continue;
                }
                if (this.annotAttrVis == null) {
                    this.annotAttrVis = new DataVectorAttr(this.pool, EAttribute.ATT_RuntimeVisibleAnnotations);
                }
                this.annotAttrVis.add(item);
            }
        }
        return this;
    }
}

