/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jasm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.openjdk.asmtools.asmutils.Pair;
import org.openjdk.asmtools.asmutils.Triplet;
import org.openjdk.asmtools.common.structure.EAttribute;
import org.openjdk.asmtools.common.structure.EModifier;
import org.openjdk.asmtools.jasm.AttrData;
import org.openjdk.asmtools.jasm.CheckedDataOutputStream;
import org.openjdk.asmtools.jasm.ClassData;
import org.openjdk.asmtools.jasm.ConstCell;
import org.openjdk.asmtools.jasm.DataWriter;
import org.openjdk.asmtools.jasm.NameInfo;
import org.openjdk.asmtools.jdis.ModuleContent;

class ModuleAttr
extends AttrData {
    private ModuleContent.Builder builder;
    private final Function<String, ConstCell> findUTF8Cell;
    private final Function<ModuleContent.TargetType, ConstCell> findClassCell;
    private final Function<ModuleContent.TargetType, ConstCell> findModuleCell;
    private final Function<ModuleContent.TargetType, ConstCell> findPackageCell;
    Consumer<ModuleContent.Dependence> requires = d -> this.builder.require((ModuleContent.Dependence)d);
    BiConsumer<? extends ModuleContent.TargetType, Set<ModuleContent.TargetType>> exports = (e, ms) -> this.builder.exports(new ModuleContent.Exported((ModuleContent.FlaggedTargetType)e), (Set<ModuleContent.TargetType>)ms);
    BiConsumer<? extends ModuleContent.TargetType, Set<ModuleContent.TargetType>> opens = (o, ms) -> this.builder.opens(new ModuleContent.Opened((ModuleContent.FlaggedTargetType)o), (Set<ModuleContent.TargetType>)ms);
    BiConsumer<? extends ModuleContent.TargetType, Set<ModuleContent.TargetType>> provides = (p, cs) -> this.builder.provides(new ModuleContent.Provided((ModuleContent.TargetType)p), (Set<ModuleContent.TargetType>)cs);
    Consumer<ModuleContent.TargetType> uses = u -> this.builder.uses(new ModuleContent.Uses((ModuleContent.TargetType)u));

    ModuleAttr(ClassData classData) {
        super(classData.pool, EAttribute.ATT_Module);
        this.builder = new ModuleContent.Builder();
        this.findUTF8Cell = targetType -> classData.pool.findUTF8Cell((String)targetType);
        this.findClassCell = targetType -> classData.pool.findClassCell((NameInfo)targetType);
        this.findModuleCell = targetType -> classData.pool.findModuleCell((NameInfo)targetType);
        this.findPackageCell = targetType -> classData.pool.findPackageCell((NameInfo)targetType);
    }

    void openModule() {
        this.builder.setModuleFlags(EModifier.ACC_OPEN.getFlag());
    }

    void setModuleName(String value) {
        this.builder.setModuleName(value);
    }

    void setModuleNameCpIndex(int cpIndex) {
        this.builder.setCpIndex(cpIndex);
    }

    ModuleAttr build() {
        ModuleContent moduleContent = this.builder.build();
        Content.instance.header = new HeaderStruct(moduleContent.header, this.findModuleCell, this.findUTF8Cell);
        Content.instance.requiresStruct = new SetStruct<ModuleContent.Dependence>(moduleContent.requires, this.findModuleCell, this.findUTF8Cell);
        Content.instance.exportsMapStruct = new MapStruct<ModuleContent.Exported>(moduleContent.exports, this.findPackageCell, this.findModuleCell);
        Content.instance.opensMapStruct = new MapStruct<ModuleContent.Opened>(moduleContent.opens, this.findPackageCell, this.findModuleCell);
        Content.instance.usesStruct = new SetStruct<ModuleContent.Uses>(moduleContent.uses, this.findClassCell, null);
        Content.instance.providesMapStruct = new MapStruct<ModuleContent.Provided>(moduleContent.provides, this.findClassCell, this.findClassCell);
        return this;
    }

    @Override
    public int attrLength() {
        return Content.instance.getLength();
    }

    @Override
    public void write(CheckedDataOutputStream out) throws IOException {
        super.write(out);
        Content.instance.write(out);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum Content implements DataWriter
    {
        instance{

            @Override
            public int getLength() {
                return this.header.getLength() + this.requiresStruct.getLength() + this.exportsMapStruct.getLength() + this.opensMapStruct.getLength() + this.usesStruct.getLength() + this.providesMapStruct.getLength();
            }

            @Override
            public void write(CheckedDataOutputStream out) throws IOException {
                this.header.write(out);
                this.requiresStruct.write(out);
                this.exportsMapStruct.write(out);
                this.opensMapStruct.write(out);
                this.usesStruct.write(out);
                this.providesMapStruct.write(out);
            }
        };

        HeaderStruct header;
        SetStruct<ModuleContent.Dependence> requiresStruct;
        MapStruct<ModuleContent.Exported> exportsMapStruct;
        MapStruct<ModuleContent.Opened> opensMapStruct;
        SetStruct<ModuleContent.Uses> usesStruct;
        MapStruct<ModuleContent.Provided> providesMapStruct;
    }

    private static class HeaderStruct
    implements DataWriter {
        final ConstCell index;
        final int flags;
        final ConstCell versionIndex;

        HeaderStruct(ModuleContent.Header source, Function<ModuleContent.TargetType, ConstCell> nameFinder, Function<String, ConstCell> versionFinder) {
            this.index = nameFinder.apply(source);
            this.versionIndex = source.getModuleVersion() == null ? null : versionFinder.apply(source.getModuleVersion());
            this.flags = source.getModuleFlags();
        }

        @Override
        public void write(CheckedDataOutputStream out) throws IOException {
            out.writeShort(this.index.cpIndex);
            out.writeShort(this.flags);
            out.writeShort(this.versionIndex == null ? 0 : this.versionIndex.cpIndex);
        }

        @Override
        public int getLength() {
            return 6;
        }
    }

    private static class SetStruct<T extends ModuleContent.TargetType>
    implements DataWriter {
        final List<ConstCell> usesList = new ArrayList<ConstCell>();
        final List<Triplet<ConstCell, Integer, ConstCell>> requiresList = new ArrayList<Triplet<ConstCell, Integer, ConstCell>>();

        SetStruct(Set<T> source, Function<ModuleContent.TargetType, ConstCell> nameFinder, Function<String, ConstCell> versionFinder) {
            Objects.requireNonNull(source);
            source.forEach(e -> {
                if (e.isFlagged()) {
                    this.requiresList.add(new Triplet<ConstCell, Integer, Object>((ConstCell)nameFinder.apply((ModuleContent.TargetType)e), ((ModuleContent.FlaggedTargetType)e).getFlags(), (((ModuleContent.VersionedFlaggedTargetType)e).getVersion() == null ? null : (ConstCell)versionFinder.apply(((ModuleContent.VersionedFlaggedTargetType)e).getVersion()))));
                } else {
                    this.usesList.add((ConstCell)nameFinder.apply((ModuleContent.TargetType)e));
                }
            });
        }

        @Override
        public void write(CheckedDataOutputStream out) throws IOException {
            if (this.usesList.isEmpty()) {
                out.writeShort(this.requiresList.size());
                for (Triplet<ConstCell, Integer, ConstCell> r : this.requiresList) {
                    out.writeShort(((ConstCell)r.first).cpIndex);
                    out.writeShort((Integer)r.second);
                    out.writeShort(r.third == null ? 0 : ((ConstCell)r.third).cpIndex);
                }
            } else {
                out.writeShort(this.usesList.size());
                for (ConstCell u : this.usesList) {
                    out.writeShort(u.cpIndex);
                }
            }
        }

        @Override
        public int getLength() {
            return this.usesList.isEmpty() ? 2 + 6 * this.requiresList.size() : 2 + 2 * this.usesList.size();
        }
    }

    private static class MapStruct<T extends ModuleContent.TargetType>
    implements DataWriter {
        final List<Triplet<ConstCell, Integer, List<ConstCell>>> exportsOpensList = new ArrayList<Triplet<ConstCell, Integer, List<ConstCell>>>();
        final List<Pair<ConstCell, List<ConstCell>>> providesList = new ArrayList<Pair<ConstCell, List<ConstCell>>>();

        MapStruct(Map<T, Set<ModuleContent.TargetType>> source, Function<ModuleContent.TargetType, ConstCell> nameFinder, Function<ModuleContent.TargetType, ConstCell> targetFinder) {
            Objects.requireNonNull(source);
            source.entrySet().stream().forEach(e -> {
                ArrayList to = new ArrayList();
                ((Set)e.getValue()).forEach(mn -> to.add((ConstCell)targetFinder.apply((ModuleContent.TargetType)mn)));
                if (((ModuleContent.TargetType)e.getKey()).isFlagged()) {
                    this.exportsOpensList.add(new Triplet((ConstCell)nameFinder.apply((ModuleContent.TargetType)e.getKey()), ((ModuleContent.FlaggedTargetType)e.getKey()).getFlags(), to));
                } else {
                    this.providesList.add(new Pair((ConstCell)nameFinder.apply((ModuleContent.TargetType)e.getKey()), to));
                }
            });
        }

        @Override
        public void write(CheckedDataOutputStream out) throws IOException {
            if (this.providesList.isEmpty()) {
                out.writeShort(this.exportsOpensList.size());
                for (Triplet<ConstCell, Integer, List<ConstCell>> triplet : this.exportsOpensList) {
                    out.writeShort(((ConstCell)triplet.first).cpIndex);
                    out.writeShort((Integer)triplet.second);
                    out.writeShort(((List)triplet.third).size());
                    for (ConstCell to : (List)triplet.third) {
                        out.writeShort(to.cpIndex);
                    }
                }
            } else {
                out.writeShort(this.providesList.size());
                for (Pair<ConstCell, List<ConstCell>> pair : this.providesList) {
                    out.writeShort(((ConstCell)pair.first).cpIndex);
                    out.writeShort(((List)pair.second).size());
                    for (ConstCell to : (List)pair.second) {
                        out.writeShort(to.cpIndex);
                    }
                }
            }
        }

        @Override
        public int getLength() {
            if (this.providesList.isEmpty()) {
                return 2 + 6 * this.exportsOpensList.size() + this.exportsOpensList.stream().mapToInt(p -> ((List)p.third).size()).filter(s -> s > 0).sum() * 2;
            }
            return 2 + 4 * this.providesList.size() + this.providesList.stream().mapToInt(p -> ((List)p.second).size()).filter(s -> s > 0).sum() * 2;
        }
    }
}

