/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jasm;

import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.List;
import org.openjdk.asmtools.common.SyntaxError;
import org.openjdk.asmtools.common.structure.StackMap;
import org.openjdk.asmtools.jasm.ClassFileConst;
import org.openjdk.asmtools.jasm.DataVector;
import org.openjdk.asmtools.jasm.Indexer;
import org.openjdk.asmtools.jasm.JasmTokens;
import org.openjdk.asmtools.jasm.OpcodeTables;
import org.openjdk.asmtools.jasm.ParseBase;
import org.openjdk.asmtools.jasm.ParseConstPool;
import org.openjdk.asmtools.jasm.Parser;
import org.openjdk.asmtools.jasm.StackMapData;
import org.openjdk.asmtools.jasm.SwitchTable;

public class ParseInstruction
extends ParseBase {
    private final ParseConstPool instructionParser;

    protected ParseInstruction(Parser parser, ParseConstPool cpParser) throws IOException {
        super.init(parser);
        this.instructionParser = cpParser;
    }

    private boolean isInstruction(JasmTokens.Token token) {
        return token == JasmTokens.Token.IDENT || token.in(JasmTokens.Token.LOCALSMAP, JasmTokens.Token.STACKMAP, JasmTokens.Token.UNSETFIELDS);
    }

    protected void parseInstr() throws SyntaxError, IOException {
        long mnenoc_pos;
        String mnemocode;
        if (this.scanner.token == JasmTokens.Token.INTVAL) {
            this.scanner.scan();
        }
        if (this.scanner.token == JasmTokens.Token.INTVAL) {
            this.scanner.scan();
        }
        if (this.scanner.token == JasmTokens.Token.COLON) {
            this.scanner.scan();
        }
        while (true) {
            if (!this.isInstruction(this.scanner.token)) {
                return;
            }
            mnemocode = this.scanner.idValue;
            mnenoc_pos = this.scanner.pos;
            this.scanner.scan();
            if (this.scanner.token != JasmTokens.Token.COLON) break;
            this.scanner.scan();
            this.parser.curCodeAttr.LabelDef(mnenoc_pos, mnemocode);
        }
        OpcodeTables.Opcode opcode = OpcodeTables.opcode(mnemocode);
        if (opcode == null) {
            this.environment.error(mnenoc_pos, "err.wrong.mnemocode", mnemocode);
            throw new SyntaxError();
        }
        OpcodeTables.OpcodeType opcodeType = opcode.type();
        Indexer arg = null;
        Object arg2 = null;
        this.scanner.debugScan(mnenoc_pos, "parseInstr: MnemoCode '%s'".formatted(opcode.parseKey()));
        switch (opcodeType) {
            case NORMAL: {
                switch (opcode) {
                    case opc_bytecode: {
                        while (true) {
                            if (this.scanner.token == JasmTokens.Token.IDENT) {
                                OpcodeTables.Opcode oc = OpcodeTables.opcode(this.scanner.stringValue);
                                if (oc == null) {
                                    this.environment.error(this.scanner.pos, "err.unknown.bytecode", this.scanner.stringValue);
                                    throw new SyntaxError();
                                }
                                this.parser.curCodeAttr.addInstr(mnenoc_pos, OpcodeTables.Opcode.opc_bytecode, new Indexer(oc.value()), null);
                                this.scanner.scan();
                            } else {
                                this.parser.curCodeAttr.addInstr(mnenoc_pos, OpcodeTables.Opcode.opc_bytecode, this.parser.parseUInt(1), null);
                            }
                            if (this.scanner.token != JasmTokens.Token.COMMA) {
                                return;
                            }
                            this.scanner.scan();
                        }
                    }
                    case opc_try: {
                        while (true) {
                            this.parser.curCodeAttr.beginTrap(this.scanner.pos, this.parser.parseIdent());
                            if (this.scanner.token != JasmTokens.Token.COMMA) {
                                return;
                            }
                            this.scanner.scan();
                        }
                    }
                    case opc_endtry: {
                        while (true) {
                            this.parser.curCodeAttr.endTrap(this.scanner.pos, this.parser.parseIdent());
                            if (this.scanner.token != JasmTokens.Token.COMMA) {
                                return;
                            }
                            this.scanner.scan();
                        }
                    }
                    case opc_catch: {
                        this.parser.curCodeAttr.trapHandler(this.scanner.pos, this.parser.parseIdent(), this.instructionParser.parseConstRef(ClassFileConst.ConstType.CONSTANT_CLASS));
                        return;
                    }
                    case opc_var: {
                        while (true) {
                            this.parser.parseLocVarDef(OpcodeTables.Opcode.opc_var);
                            if (this.scanner.token != JasmTokens.Token.COMMA) {
                                return;
                            }
                            this.scanner.scan();
                        }
                    }
                    case opc_endvar: {
                        while (true) {
                            this.parser.parseLocVarEnd(OpcodeTables.Opcode.opc_var);
                            if (this.scanner.token != JasmTokens.Token.COMMA) {
                                return;
                            }
                            this.scanner.scan();
                        }
                    }
                    case opc_type: {
                        while (true) {
                            this.parser.parseLocVarDef(OpcodeTables.Opcode.opc_type);
                            if (this.scanner.token != JasmTokens.Token.COMMA) {
                                return;
                            }
                            this.scanner.scan();
                        }
                    }
                    case opc_endtype: {
                        while (true) {
                            this.parser.parseLocVarEnd(OpcodeTables.Opcode.opc_type);
                            if (this.scanner.token != JasmTokens.Token.COMMA) {
                                return;
                            }
                            this.scanner.scan();
                        }
                    }
                    case opc_locals_map: {
                        StackMapData stackMapData = this.parser.curCodeAttr.getStackMapTable();
                        if (stackMapData.localsMap != null) {
                            this.environment.error(this.scanner.pos, "err.stackmap.entity.repeated", OpcodeTables.Opcode.opc_locals_map.parseKey());
                        }
                        DataVector localsMap = new DataVector();
                        stackMapData.localsMap = localsMap;
                        stackMapData.setScannerPosition(this.scanner.pos);
                        if (this.scanner.token == JasmTokens.Token.SEMICOLON) {
                            return;
                        }
                        while (true) {
                            this.parser.parseMapItem(localsMap);
                            if (this.scanner.token != JasmTokens.Token.COMMA) {
                                return;
                            }
                            this.scanner.scan();
                        }
                    }
                    case opc_stack_map: {
                        StackMapData stackMapData = this.parser.curCodeAttr.getStackMapTable();
                        if (stackMapData.stackMap != null) {
                            this.environment.error(this.scanner.pos, "err.stackmap.entity.repeated", OpcodeTables.Opcode.opc_stack_map.parseKey());
                        }
                        DataVector stackMap = new DataVector();
                        stackMapData.stackMap = stackMap;
                        stackMapData.setScannerPosition(this.scanner.pos);
                        if (this.scanner.token == JasmTokens.Token.SEMICOLON) {
                            return;
                        }
                        while (true) {
                            this.parser.parseMapItem(stackMap);
                            if (this.scanner.token != JasmTokens.Token.COMMA) {
                                return;
                            }
                            this.scanner.scan();
                        }
                    }
                    case opc_unset_fields: {
                        StackMapData stackMapData = this.parser.curCodeAttr.getStackMapTable();
                        if (!stackMapData.isWrapper()) {
                            this.environment.error(this.scanner.pos, "err.stackmap.map.eligible", OpcodeTables.Opcode.opc_unset_fields.parseKey(), StackMap.EntryType.EARLY_LARVAL.tagName());
                        }
                        if (stackMapData.unsetFields != null) {
                            this.environment.error(this.scanner.pos, "err.stackmap.entity.repeated", OpcodeTables.Opcode.opc_unset_fields.parseKey());
                        }
                        DataVector unsetFields = new DataVector();
                        stackMapData.unsetFields = unsetFields;
                        stackMapData.setScannerPosition(this.scanner.pos);
                        if (this.scanner.token == JasmTokens.Token.SEMICOLON) {
                            this.scanner.scan();
                            this.scanner.expectOneOf(List.of(OpcodeTables.Opcode.opc_stack_map_entry.parseKey(), OpcodeTables.Opcode.opc_stack_frame_type.parseKey()), JasmTokens.Token.FRAMETYPE, JasmTokens.Token.ENTRYTYPE);
                        } else {
                            while (true) {
                                this.parser.parseNameAndType(unsetFields);
                                if (this.scanner.token != JasmTokens.Token.COMMA) {
                                    this.scanner.expect(JasmTokens.Token.SEMICOLON);
                                    this.scanner.expectOneOf(List.of(OpcodeTables.Opcode.opc_stack_map_entry.parseKey(), OpcodeTables.Opcode.opc_stack_frame_type.parseKey()), JasmTokens.Token.FRAMETYPE, JasmTokens.Token.ENTRYTYPE);
                                    break;
                                }
                                this.scanner.scan();
                            }
                        }
                        opcode = OpcodeTables.Opcode.opc_frame_type;
                        this.scanner.scan();
                    }
                    case opc_stack_frame_type: 
                    case opc_stack_map_entry: 
                    case opc_frame_type: 
                    case opc_entry_type: {
                        StackMapData stackMapData = this.parser.curCodeAttr.getStackMapTable();
                        if (stackMapData.isFrameTypeSet()) {
                            if (stackMapData.isWrapper()) {
                                stackMapData = this.parser.curCodeAttr.getNextStackMapTable();
                            } else {
                                this.environment.error(this.scanner.pos, "err.stackmaptable.repeated", new Object[0]);
                            }
                        }
                        stackMapData.setScannerPosition(this.scanner.pos).setStackFrameTypeByName(this.parser.parseIdent());
                        return;
                    }
                    case opc_stack_map_frame: {
                        StackMapData stackMapData = this.parser.curCodeAttr.getStackMapTable();
                        if (stackMapData.isFrameTypeSet()) {
                            this.environment.error(this.scanner.pos, "err.stackmaptable.repeated", new Object[0]);
                        }
                        stackMapData.setScannerPosition(this.scanner.pos);
                        return;
                    }
                    case opc_aload: 
                    case opc_astore: 
                    case opc_fload: 
                    case opc_fstore: 
                    case opc_iload: 
                    case opc_istore: 
                    case opc_lload: 
                    case opc_lstore: 
                    case opc_dload: 
                    case opc_dstore: 
                    case opc_ret: 
                    case opc_aload_w: 
                    case opc_astore_w: 
                    case opc_fload_w: 
                    case opc_fstore_w: 
                    case opc_iload_w: 
                    case opc_istore_w: 
                    case opc_lload_w: 
                    case opc_lstore_w: 
                    case opc_dload_w: 
                    case opc_dstore_w: 
                    case opc_ret_w: {
                        arg = this.parser.parseLocVarRef();
                        break;
                    }
                    case opc_iinc: {
                        arg = this.parser.parseLocVarRef();
                        this.scanner.expect(JasmTokens.Token.COMMA);
                        arg2 = this.parser.parseInt(opcode.parseKey(), 1);
                        break;
                    }
                    case opc_tableswitch: 
                    case opc_lookupswitch: {
                        arg2 = this.parseSwitchTable();
                        break;
                    }
                    case opc_newarray: {
                        int type;
                        if (this.scanner.token == JasmTokens.Token.INTVAL) {
                            type = this.scanner.intValue;
                        } else {
                            type = ClassFileConst.basicTypeValue(this.scanner.idValue);
                            if (type == -1) {
                                this.environment.error(this.scanner.pos, "err.array.type.expected", new Object[0]);
                                throw new SyntaxError();
                            }
                        }
                        this.scanner.scan();
                        arg = new Indexer(type);
                        break;
                    }
                    case opc_new: 
                    case opc_anewarray: 
                    case opc_instanceof: 
                    case opc_checkcast: {
                        arg = this.instructionParser.parseConstRef(ClassFileConst.ConstType.CONSTANT_CLASS);
                        break;
                    }
                    case opc_bipush: {
                        arg = this.parser.parseInt(opcode.parseKey(), 1);
                        break;
                    }
                    case opc_sipush: {
                        arg = this.parser.parseInt(opcode.parseKey(), 2);
                        break;
                    }
                    case opc_ldc: 
                    case opc_ldc_w: 
                    case opc_ldc2_w: {
                        arg = this.instructionParser.parseConstRef(null);
                        break;
                    }
                    case opc_putstatic: 
                    case opc_getstatic: 
                    case opc_putfield: 
                    case opc_getfield: {
                        arg = this.instructionParser.parseConstRef(ClassFileConst.ConstType.CONSTANT_FIELDREF);
                        break;
                    }
                    case opc_invokevirtual: {
                        arg = this.instructionParser.parseConstRef(ClassFileConst.ConstType.CONSTANT_METHODREF);
                        break;
                    }
                    case opc_invokestatic: 
                    case opc_invokespecial: {
                        ClassFileConst.ConstType ctype01 = ClassFileConst.ConstType.CONSTANT_METHODREF;
                        ClassFileConst.ConstType ctype02 = ClassFileConst.ConstType.CONSTANT_INTERFACEMETHODREF;
                        if (Modifier.isInterface(this.parser.classData.access)) {
                            ctype01 = ClassFileConst.ConstType.CONSTANT_INTERFACEMETHODREF;
                            ctype02 = ClassFileConst.ConstType.CONSTANT_METHODREF;
                        }
                        arg = this.instructionParser.parseConstRef(ctype01, ctype02);
                        break;
                    }
                    case opc_jsr: 
                    case opc_goto: 
                    case opc_ifeq: 
                    case opc_ifge: 
                    case opc_ifgt: 
                    case opc_ifle: 
                    case opc_iflt: 
                    case opc_ifne: 
                    case opc_if_icmpeq: 
                    case opc_if_icmpne: 
                    case opc_if_icmpge: 
                    case opc_if_icmpgt: 
                    case opc_if_icmple: 
                    case opc_if_icmplt: 
                    case opc_if_acmpeq: 
                    case opc_if_acmpne: 
                    case opc_ifnull: 
                    case opc_ifnonnull: 
                    case opc_jsr_w: 
                    case opc_goto_w: {
                        arg = this.parseLabelRef();
                        break;
                    }
                    case opc_invokeinterface: {
                        arg = this.instructionParser.parseConstRef(ClassFileConst.ConstType.CONSTANT_INTERFACEMETHODREF);
                        this.scanner.expect(JasmTokens.Token.COMMA);
                        arg2 = this.parser.parseUInt(1);
                        break;
                    }
                    case opc_invokedynamic: {
                        arg = this.instructionParser.parseConstRef(ClassFileConst.ConstType.CONSTANT_INVOKEDYNAMIC);
                        break;
                    }
                    case opc_multianewarray: {
                        arg = this.instructionParser.parseConstRef(ClassFileConst.ConstType.CONSTANT_CLASS);
                        this.scanner.expect(JasmTokens.Token.COMMA);
                        arg2 = this.parser.parseUInt(1);
                        break;
                    }
                    case opc_wide: 
                    case opc_nonpriv: 
                    case opc_priv: {
                        int opc2 = opcode.value() << 8 | this.parser.parseUInt((int)1).cpIndex;
                        opcode = OpcodeTables.opcode(opc2);
                    }
                }
                break;
            }
            case WIDE: {
                arg = this.parser.parseLocVarRef();
                if (opcode != OpcodeTables.Opcode.opc_iinc_w) break;
                this.scanner.expect(JasmTokens.Token.COMMA);
                arg2 = this.parser.parseInt(opcode.parseKey(), 2);
                break;
            }
            case NONPRIVELEGED: 
            case PRIVELEGED: {
                break;
            }
            default: {
                this.environment.error(this.scanner.prevPos, "err.wrong.mnemocode", mnemocode);
                throw new SyntaxError();
            }
        }
        this.parser.curCodeAttr.addInstr(mnenoc_pos, opcode, arg, arg2);
    }

    protected SwitchTable parseSwitchTable() throws SyntaxError, IOException {
        SwitchTable table;
        block6: {
            this.scanner.expect(JasmTokens.Token.LBRACE);
            int numpairs = 0;
            table = new SwitchTable(this.environment);
            block4: while (numpairs < OpcodeTables.MAX_LOOKUPSWITCH_PAIRS_COUNT) {
                switch (this.scanner.token) {
                    case INTVAL: {
                        int key = this.scanner.intValue * this.scanner.sign;
                        this.scanner.scan();
                        this.scanner.expect(JasmTokens.Token.COLON);
                        table.addEntry(key, this.parseLabelRef());
                        ++numpairs;
                        if (this.scanner.token != JasmTokens.Token.SEMICOLON) break;
                        this.scanner.scan();
                        continue block4;
                    }
                    case DEFAULT: {
                        this.scanner.scan();
                        this.scanner.expect(JasmTokens.Token.COLON);
                        if (table.defLabel != null) {
                            this.environment.error("err.default.redecl", new Object[0]);
                        }
                        table.defLabel = this.parseLabelRef();
                        if (this.scanner.token != JasmTokens.Token.SEMICOLON) break;
                        this.scanner.scan();
                        continue block4;
                    }
                }
                break block6;
            }
            this.environment.error("err.long.switchtable", OpcodeTables.MAX_LOOKUPSWITCH_PAIRS_COUNT);
        }
        this.scanner.expect(JasmTokens.Token.RBRACE);
        return table;
    }

    protected Indexer parseLabelRef() throws SyntaxError, IOException {
        switch (this.scanner.token) {
            case INTVAL: {
                int v = this.scanner.intValue * this.scanner.sign;
                this.scanner.scan();
                return new Indexer(v);
            }
            case IDENT: {
                String label = this.scanner.stringValue;
                this.scanner.scan();
                return this.parser.curCodeAttr.LabelRef(label);
            }
        }
        this.environment.error("err.label.expected", new Object[0]);
        throw new SyntaxError();
    }
}

