/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jasm;

import java.io.IOException;
import java.util.Objects;
import org.openjdk.asmtools.common.CompilerLogger;
import org.openjdk.asmtools.common.structure.StackMap;
import org.openjdk.asmtools.jasm.CheckedDataOutputStream;
import org.openjdk.asmtools.jasm.DataVector;
import org.openjdk.asmtools.jasm.DataWriter;
import org.openjdk.asmtools.jasm.Indexer;
import org.openjdk.asmtools.jasm.JasmEnvironment;
import org.openjdk.asmtools.jasm.JasmTokens;

public class StackMapData
implements DataWriter {
    static final int UNDEFINED = -1;
    final JasmEnvironment environment;
    private long scannerPosition = 0L;
    final boolean hasStackMapTable;
    private int pc = -1;
    private int offset = -1;
    private StackMap.EntryType entryType = StackMap.EntryType.UNKNOWN_TYPE;
    DataVector<? extends Indexer> localsMap;
    DataVector<? extends Indexer> stackMap;
    DataVector<? extends Indexer> unsetFields;

    StackMapData(JasmEnvironment environment, boolean hasStackMapTable) {
        this.environment = environment;
        this.hasStackMapTable = hasStackMapTable;
    }

    StackMapData setOffset(StackMapData prevFrame) {
        this.offset = prevFrame == null ? this.pc : this.pc - prevFrame.pc - 1;
        return this;
    }

    StackMapData setOffset(int offset) {
        this.offset = offset;
        return this;
    }

    StackMapData setPC(int pc) {
        this.pc = pc;
        return this;
    }

    StackMapData setStackFrameTypeByName(String stackFrameTypeName) {
        Objects.requireNonNull(stackFrameTypeName, () -> ((CompilerLogger)this.environment.getLogger()).getResourceString("err.obj.is.null", "String stackFrameType"));
        this.entryType = StackMap.getEntryTypeByName(stackFrameTypeName);
        if (this.entryType == StackMap.EntryType.UNKNOWN_TYPE) {
            this.environment.error(this.scannerPosition, "err.invalid.stack.frame.type", stackFrameTypeName);
        }
        return this;
    }

    StackMapData setStackFrameType(int stackFrameTypeValue) {
        this.entryType = StackMap.EntryType.getByTag(stackFrameTypeValue);
        if (this.entryType == StackMap.EntryType.SAME_FRAME) {
            this.offset = stackFrameTypeValue;
        } else if (this.entryType == StackMap.EntryType.SAME_LOCALS_1_STACK_ITEM_FRAME) {
            this.offset = stackFrameTypeValue - StackMap.EntryType.SAME_LOCALS_1_STACK_ITEM_FRAME.fromTag();
        }
        return this;
    }

    StackMapData setScannerPosition(long scannerPosition) {
        this.scannerPosition = scannerPosition;
        return this;
    }

    boolean isFrameTypeSet() {
        return this.hasStackMapTable ? this.entryType != StackMap.EntryType.UNKNOWN_TYPE : this.pc != -1;
    }

    boolean isWrapper() {
        return this.hasStackMapTable && this.entryType == StackMap.EntryType.EARLY_LARVAL;
    }

    @Override
    public boolean isCountable() {
        return !this.isWrapper();
    }

    JasmTokens.Token checkIntegrity() {
        switch (this.entryType) {
            case SAME_FRAME: {
                return null;
            }
            case SAME_LOCALS_1_STACK_ITEM_FRAME: {
                return this.isFull(this.stackMap) ? null : JasmTokens.Token.STACKMAP;
            }
            case EARLY_LARVAL: {
                return this.isFull(this.unsetFields) ? null : JasmTokens.Token.UNSETFIELDS;
            }
            case SAME_LOCALS_1_STACK_ITEM_FRAME_EXTENDED: {
                if (this.offset == -1) {
                    return JasmTokens.Token.OFFSETDELTA;
                }
                return this.isFull(this.stackMap) ? null : JasmTokens.Token.STACKMAP;
            }
            case CHOP_1_FRAME: 
            case CHOP_2_FRAME: 
            case CHOP_3_FRAME: 
            case SAME_FRAME_EXTENDED: {
                return this.offset == -1 ? JasmTokens.Token.OFFSETDELTA : null;
            }
            case APPEND_FRAME: {
                if (this.offset == -1) {
                    return JasmTokens.Token.OFFSETDELTA;
                }
                return this.isFull(this.localsMap) ? null : JasmTokens.Token.LOCALSMAP;
            }
            case FULL_FRAME: {
                if (this.offset == -1) {
                    return JasmTokens.Token.OFFSETDELTA;
                }
                if (!this.isFull(this.localsMap)) {
                    return JasmTokens.Token.LOCALSMAP;
                }
                if (this.isFull(this.stackMap)) break;
                return JasmTokens.Token.STACKMAP;
            }
        }
        return null;
    }

    private boolean isFull(DataVector<?> ... maps) {
        for (DataVector<?> map : maps) {
            if (map != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getLength() {
        int length;
        int n = length = this.hasStackMapTable ? 1 : 0;
        if (!this.isFrameTypeSet() || !this.hasStackMapTable) {
            this.entryType = StackMap.EntryType.FULL_FRAME;
        }
        switch (this.entryType) {
            case SAME_FRAME: {
                break;
            }
            case SAME_LOCALS_1_STACK_ITEM_FRAME: {
                length += this.stackMap.getLength() - 2;
                break;
            }
            case SAME_LOCALS_1_STACK_ITEM_FRAME_EXTENDED: {
                length += this.stackMap.getLength();
                break;
            }
            case EARLY_LARVAL: {
                length += 2 + (this.unsetFields == null ? 0 : this.unsetFields.getLength() - 2);
                break;
            }
            case CHOP_1_FRAME: 
            case CHOP_2_FRAME: 
            case CHOP_3_FRAME: 
            case SAME_FRAME_EXTENDED: {
                length += 2;
                break;
            }
            case APPEND_FRAME: {
                length += 2 + (this.localsMap == null ? 0 : this.localsMap.getLength() - 2);
                break;
            }
            case FULL_FRAME: {
                length += 2;
                length += this.localsMap == null ? 2 : this.localsMap.getLength();
                length += this.stackMap == null ? 2 : this.stackMap.getLength();
                break;
            }
        }
        return length;
    }

    @Override
    public void write(CheckedDataOutputStream out) throws IOException {
        if (!this.hasStackMapTable) {
            this.entryType = StackMap.EntryType.FULL_FRAME;
        }
        switch (this.entryType) {
            case EARLY_LARVAL: {
                out.writeByte(this.entryType.fromTag());
                if (this.unsetFields == null) {
                    out.writeShort(0);
                    break;
                }
                this.unsetFields.write(out);
                break;
            }
            case SAME_FRAME: {
                if (!StackMap.EntryType.SAME_FRAME.inRange(this.offset)) {
                    this.environment.error(this.scannerPosition, "err.invalid.offset.frame.type", this.offset, this.entryType.printName());
                    break;
                }
                out.writeByte(this.offset);
                break;
            }
            case SAME_LOCALS_1_STACK_ITEM_FRAME: {
                if (this.stackMap == null) {
                    this.environment.error(this.scannerPosition, "err.no.stack.map", this.entryType.printName());
                    break;
                }
                if (this.stackMap.elements.size() != 1) {
                    this.environment.error(this.scannerPosition, "err.should.be.only.one.stack.map.element", this.entryType.printName());
                    break;
                }
                if (this.offset >= 64) {
                    this.environment.error(this.scannerPosition, "err.invalid.offset.frame.type", this.offset, this.entryType.printName());
                    break;
                }
                out.writeByte(this.entryType.fromTag() + this.offset);
                this.stackMap.writeElements(out);
                break;
            }
            case SAME_LOCALS_1_STACK_ITEM_FRAME_EXTENDED: {
                if (this.stackMap == null) {
                    this.environment.error(this.scannerPosition, "err.no.locals.map", this.entryType.printName());
                    break;
                }
                if (this.stackMap.elements.size() != 1) {
                    this.environment.error(this.scannerPosition, "err.should.be.only.one.stack.map.element", this.entryType.printName());
                    break;
                }
                out.writeByte(this.entryType.fromTag());
                out.writeShort(this.offset);
                this.stackMap.writeElements(out);
                break;
            }
            case CHOP_1_FRAME: 
            case CHOP_2_FRAME: 
            case CHOP_3_FRAME: 
            case SAME_FRAME_EXTENDED: {
                boolean error = false;
                if (this.stackMap != null) {
                    this.environment.error(this.scannerPosition, "err.unexpected.stack.maps", this.entryType.printName());
                    error = true;
                }
                if (this.localsMap != null) {
                    this.environment.error(this.scannerPosition, "err.unexpected.locals.maps", this.entryType.printName());
                    error = true;
                }
                if (error) break;
                out.writeByte(this.entryType.fromTag());
                out.writeShort(this.offset);
                break;
            }
            case APPEND_FRAME: {
                if (this.localsMap == null) {
                    this.environment.error(this.scannerPosition, "err.no.locals.map", this.entryType.printName());
                    break;
                }
                if (this.localsMap.elements.size() > 3) {
                    this.environment.error(this.scannerPosition, "err.more.locals.map.elements", new Object[0]);
                    break;
                }
                out.writeByte(this.entryType.fromTag() + this.localsMap.elements.size() - 1);
                out.writeShort(this.offset);
                this.localsMap.writeElements(out);
                break;
            }
            case FULL_FRAME: {
                if (this.hasStackMapTable) {
                    out.writeByte(this.entryType.fromTag());
                    out.writeShort(this.offset);
                } else {
                    out.writeShort(this.pc);
                }
                if (this.localsMap == null) {
                    out.writeShort(0);
                } else {
                    this.localsMap.write(out);
                }
                if (this.stackMap == null) {
                    out.writeShort(0);
                    break;
                }
                this.stackMap.write(out);
                break;
            }
            default: {
                this.environment.error(this.scannerPosition, "err.stackmap.entry.type.not.set", this.entryType.fromTag());
            }
        }
    }

    public StackMap.EntryType getFrameType() {
        return this.entryType;
    }

    public static class StackMapItemTaggedPointer
    implements DataWriter {
        StackMap.VerificationType itemVerificationType;
        Indexer arg;

        StackMapItemTaggedPointer(StackMap.VerificationType itemVerificationType, Indexer arg) {
            this.itemVerificationType = itemVerificationType;
            this.arg = arg;
        }

        @Override
        public int getLength() {
            return 3;
        }

        @Override
        public void write(CheckedDataOutputStream out) throws IOException {
            out.writeByte(this.itemVerificationType.tag());
            out.writeShort(this.arg.cpIndex);
        }
    }

    public static class StackMapItemTagged
    implements DataWriter {
        StackMap.VerificationType itemVerificationType;

        StackMapItemTagged(StackMap.VerificationType itemVerificationType) {
            this.itemVerificationType = itemVerificationType;
        }

        @Override
        public int getLength() {
            return 1;
        }

        @Override
        public void write(CheckedDataOutputStream out) throws IOException {
            out.writeByte(this.itemVerificationType.tag());
        }
    }
}

