/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jasm;

import java.io.IOException;
import org.openjdk.asmtools.jasm.AnnotationData;
import org.openjdk.asmtools.jasm.CheckedDataOutputStream;
import org.openjdk.asmtools.jasm.Indexer;
import org.openjdk.asmtools.jasm.TypeAnnotationTargetInfoData;
import org.openjdk.asmtools.jasm.TypeAnnotationTypePathData;
import org.openjdk.asmtools.jasm.TypeAnnotationTypes;

public class TypeAnnotationData
extends AnnotationData {
    protected TypeAnnotationTypes.ETargetType targetType;
    protected TypeAnnotationTargetInfoData targetInfo;
    protected TypeAnnotationTypePathData typePath = new TypeAnnotationTypePathData();

    public TypeAnnotationData(Indexer typeCPX, boolean invisible) {
        super(typeCPX, invisible);
    }

    @Override
    public int getLength() {
        return super.getLength() + 1 + this.targetInfo.getLength() + this.typePath.getLength();
    }

    @Override
    public void write(CheckedDataOutputStream out) throws IOException {
        out.writeByte(this.targetType.value);
        this.targetInfo.write(out);
        this.typePath.write(out);
        super.write(out);
    }

    public void addTypePathEntry(TypeAnnotationTypes.TypePathEntry path) {
        this.typePath.addTypePathEntry(path);
    }

    public String toString() {
        return String.format("%s %s %s", this.targetType.toString(), this.targetInfo.toString(), this.typePath.toString());
    }
}

