/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jasm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.stream.Collectors;
import org.openjdk.asmtools.jasm.CheckedDataOutputStream;
import org.openjdk.asmtools.jasm.DataWriter;
import org.openjdk.asmtools.jasm.TypeAnnotationTypes;

public class TypeAnnotationTypePathData
implements DataWriter {
    private ArrayList<TypeAnnotationTypes.TypePathEntry> typePathEntries = new ArrayList();

    public void addTypePathEntry(TypeAnnotationTypes.TypePathEntry entry) {
        this.typePathEntries.add(entry);
    }

    @Override
    public void write(CheckedDataOutputStream out) throws IOException {
        out.writeByte(this.typePathEntries.size());
        for (TypeAnnotationTypes.TypePathEntry entry : this.typePathEntries) {
            out.writeByte(entry.getTypePathKind());
            out.writeByte(entry.getTypeArgumentIndex());
        }
    }

    @Override
    public int getLength() {
        return 1 + this.typePathEntries.size() * 2;
    }

    public String toString() {
        if (this.typePathEntries.size() > 0) {
            StringBuilder sb = new StringBuilder("{ ");
            sb.append(this.typePathEntries.stream().map(e -> e.toString()).collect(Collectors.joining(", ")));
            sb.append(" }");
            return sb.toString();
        }
        return "";
    }

    public String toPrintString() {
        return this.toString();
    }
}

