/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jcoder;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import org.openjdk.asmtools.common.CompilerLogger;
import org.openjdk.asmtools.common.EMessageKind;
import org.openjdk.asmtools.common.Environment;
import org.openjdk.asmtools.common.inputs.TextInput;
import org.openjdk.asmtools.common.inputs.ToolInput;
import org.openjdk.asmtools.common.outputs.ToolOutput;
import org.openjdk.asmtools.common.outputs.log.DualStreamToolOutput;
import org.openjdk.asmtools.common.structure.CFVersion;

public class JcoderEnvironment
extends Environment<CompilerLogger> {
    final CFVersion cfv = new CFVersion();
    InputFile inputFile;

    private JcoderEnvironment(Environment.Builder<JcoderEnvironment, CompilerLogger> builder) {
        super(builder);
    }

    @Override
    public void setToolInput(ToolInput toolInput) throws IOException, URISyntaxException {
        try {
            super.setToolInput(toolInput);
            this.inputFile = new InputFile(this.getDataInputStream());
        }
        catch (IOException ioe) {
            this.error("err.cannot.read", toolInput);
            throw ioe;
        }
    }

    @Override
    public void warning(long where, String id, Object ... args) {
        ((CompilerLogger)this.getLogger()).warning(where, id, args);
    }

    @Override
    public void error(long where, String id, Object ... args) {
        ((CompilerLogger)this.getLogger()).error(where, id, args);
    }

    @Override
    public void warning(String id, Object ... args) {
        ((CompilerLogger)this.getLogger()).warning(Integer.MAX_VALUE, id, args);
    }

    @Override
    public void error(String id, Object ... args) {
        ((CompilerLogger)this.getLogger()).error(Integer.MAX_VALUE, id, args);
    }

    public long getErrorCount() {
        return ((CompilerLogger)this.getLogger()).getCount(EMessageKind.ERROR);
    }

    public boolean hasMessages() {
        return !((CompilerLogger)super.getLogger()).noMessages();
    }

    public int flush(boolean printTotals) {
        return ((CompilerLogger)super.getLogger()).flush(printTotals);
    }

    public long getPosition() {
        return this.inputFile == null ? 0L : this.inputFile.position;
    }

    public int read() throws IOException {
        return this.inputFile.readUTF();
    }

    class InputFile
    extends TextInput {
        private int pushBack;
        private int index;

        InputFile(DataInputStream dataInputStream) throws IOException {
            super(dataInputStream);
            this.pushBack = -1;
            this.index = 0;
        }

        private int getChar() {
            try {
                return this.strData.charAt(this.index++);
            }
            catch (StringIndexOutOfBoundsException e) {
                return -1;
            }
        }

        @Override
        public int readUTF() {
            this.position = (long)this.linepos << 32 | (long)this.charPos;
            ++this.charPos;
            int c = this.pushBack;
            if (c == -1) {
                c = this.getChar();
            } else {
                this.pushBack = -1;
            }
            switch (c) {
                case -2: {
                    return 92;
                }
                case 92: {
                    c = this.getChar();
                    if (c != 117) {
                        this.pushBack = c == 92 ? -2 : c;
                        return 92;
                    }
                    ++this.charPos;
                    while ((c = this.getChar()) == 117) {
                        ++this.charPos;
                    }
                    int d = 0;
                    int i = 0;
                    while (i < 4) {
                        switch (c) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                d = (d << 4) + c - 48;
                                break;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                d = (d << 4) + 10 + c - 97;
                                break;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                d = (d << 4) + 10 + c - 65;
                                break;
                            }
                            default: {
                                JcoderEnvironment.this.error(this.position, "err.invalid.escape.char", new Object[0]);
                                this.pushBack = c;
                                return d;
                            }
                        }
                        ++i;
                        ++this.charPos;
                        c = this.getChar();
                    }
                    this.pushBack = c;
                    return d;
                }
                case 10: {
                    ++this.linepos;
                    return 10;
                }
                case 13: {
                    c = this.getChar();
                    if (c != 10) {
                        this.pushBack = c;
                    } else {
                        ++this.charPos;
                    }
                    ++this.linepos;
                    return 10;
                }
            }
            return c;
        }
    }

    static class JcoderBuilder
    extends Environment.Builder<JcoderEnvironment, CompilerLogger> {
        public JcoderBuilder(ToolOutput toolOutput, DualStreamToolOutput log) {
            super(toolOutput, new CompilerLogger("jcoder", JcoderEnvironment.class, log));
        }

        @Override
        public JcoderEnvironment build() {
            return new JcoderEnvironment((Environment.Builder<JcoderEnvironment, CompilerLogger>)this);
        }
    }
}

