/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jcoder;

import java.io.IOException;
import java.util.HashMap;
import org.openjdk.asmtools.common.SyntaxError;
import org.openjdk.asmtools.jasm.ClassFileConst;
import org.openjdk.asmtools.jcoder.ByteBuffer;
import org.openjdk.asmtools.jcoder.JcodTokens;
import org.openjdk.asmtools.jcoder.JcoderEnvironment;

public class Scanner {
    public static final int EOF = -1;
    public static final int LBRACE = 123;
    protected JcoderEnvironment environment;
    protected JcoderEnvironment.InputFile inputFile;
    protected int ch;
    protected int prevCh = -1;
    protected String macro;
    protected int indexMacro;
    protected JcodTokens.Token token;
    protected long pos;
    protected long prevPos;
    protected long longValue;
    protected int intValue;
    protected int intSize;
    protected String stringValue;
    protected ByteBuffer longStringValue;
    protected int sign;
    protected String docComment;
    HashMap<String, String> macros = new HashMap();
    private boolean debugCP = false;
    private int numCPentrs = 0;
    private int count;
    private char[] buffer = new char[32];

    protected Scanner(JcoderEnvironment environment, HashMap<String, String> macros) throws IOException {
        this(environment);
        this.macros = macros;
    }

    protected Scanner(JcoderEnvironment environment) throws IOException {
        this.environment = environment;
        this.inputFile = environment.inputFile;
        this.ch = environment.read();
        this.prevPos = environment.getPosition();
        this.scan();
    }

    void setDebugCP(boolean enable) {
        if (enable) {
            this.numCPentrs = 0;
        }
        this.debugCP = enable;
    }

    void addConstDebug(ClassFileConst.ConstType ct) {
        ++this.numCPentrs;
        this.environment.traceln("\n Const[" + this.numCPentrs + "] = " + ct.printVal(), new Object[0]);
    }

    void setMacro(String macro) {
        this.macro = macro;
        this.indexMacro = 0;
        this.prevCh = this.ch;
    }

    void readCh() throws IOException {
        if (this.macro != null) {
            if (this.indexMacro < this.macro.length()) {
                this.ch = this.macro.charAt(this.indexMacro);
            }
            this.macro = null;
        }
        if (this.prevCh >= 0) {
            this.ch = this.prevCh;
            this.prevCh = -1;
        } else {
            this.ch = this.inputFile.readUTF();
        }
    }

    private void putc(int ch) {
        if (this.count == this.buffer.length) {
            char[] newBuffer = new char[this.buffer.length * 2];
            System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
            this.buffer = newBuffer;
        }
        this.buffer[this.count++] = (char)ch;
    }

    private String bufferString() {
        char[] buf = new char[this.count];
        System.arraycopy(this.buffer, 0, buf, 0, this.count);
        return new String(buf);
    }

    private void skipComment() throws IOException {
        block4: while (true) {
            switch (this.ch) {
                case -1: {
                    this.environment.error(this.pos, "err.eof.in.comment", new Object[0]);
                    return;
                }
                case 42: {
                    this.readCh();
                    if (this.ch != 47) continue block4;
                    this.readCh();
                    return;
                }
            }
            this.readCh();
        }
    }

    private String scanDocComment() throws IOException {
        this.count = 0;
        if (this.ch == 42) {
            do {
                this.readCh();
            } while (this.ch == 42);
            if (this.ch == 47) {
                this.readCh();
                return "";
            }
        }
        switch (this.ch) {
            case 10: 
            case 32: {
                this.readCh();
            }
        }
        boolean seenstar = false;
        int c = this.count;
        block14: while (true) {
            switch (this.ch) {
                case -1: {
                    this.environment.error(this.pos, "err.eof.in.comment", new Object[0]);
                    return this.bufferString();
                }
                case 10: {
                    this.putc(10);
                    this.readCh();
                    seenstar = false;
                    c = this.count;
                    continue block14;
                }
                case 9: 
                case 32: {
                    this.putc(this.ch);
                    this.readCh();
                    continue block14;
                }
                case 42: {
                    if (seenstar) {
                        this.readCh();
                        if (this.ch == 47) {
                            this.readCh();
                            this.count = c;
                            return this.bufferString();
                        }
                        this.putc(42);
                        continue block14;
                    }
                    seenstar = true;
                    this.count = c;
                    do {
                        this.readCh();
                    } while (this.ch == 42);
                    switch (this.ch) {
                        case 32: {
                            this.readCh();
                            break;
                        }
                        case 47: {
                            this.readCh();
                            this.count = c;
                            return this.bufferString();
                        }
                    }
                    continue block14;
                }
            }
            if (!seenstar) {
                seenstar = true;
            }
            this.putc(this.ch);
            this.readCh();
            c = this.count;
        }
    }

    private void scanDecNumber() throws IOException {
        boolean overflow = false;
        long value = this.ch - 48;
        this.count = 0;
        this.token = JcodTokens.Token.INTVAL;
        this.intSize = 2;
        this.putc(this.ch);
        block7: while (true) {
            this.readCh();
            switch (this.ch) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    this.putc(this.ch);
                    overflow = overflow || value * 10L / 10L != value;
                    value = value * 10L + (long)(this.ch - 48);
                    overflow = overflow || value - 1L < -1L;
                    continue block7;
                }
                case 98: {
                    this.readCh();
                    this.intSize = 1;
                    break block7;
                }
                case 115: {
                    this.readCh();
                    this.intSize = 2;
                    break block7;
                }
                case 105: {
                    this.readCh();
                    this.intSize = 4;
                    break block7;
                }
                case 108: {
                    this.readCh();
                    this.intSize = 8;
                    break block7;
                }
            }
            break;
        }
        this.longValue = value;
        this.intValue = (int)value;
        if (Character.isJavaIdentifierPart((char)this.ch) || this.ch == 46) {
            this.environment.error(this.inputFile.position, "err.invalid.number", Character.toString((char)this.ch));
            do {
                this.readCh();
            } while (Character.isJavaIdentifierPart((char)this.ch) || this.ch == 46);
            return;
        }
        if (overflow) {
            this.environment.error(this.pos, "err.overflow", new Object[0]);
        }
    }

    private void scanHexNumber() throws IOException {
        boolean overflow = false;
        long value = 0L;
        this.count = 0;
        this.token = JcodTokens.Token.INTVAL;
        this.intSize = 2;
        this.putc(this.ch);
        int k = 0;
        block4: while (true) {
            int cypher;
            this.readCh();
            switch (this.ch) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    cypher = (char)this.ch - 48;
                    break;
                }
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: {
                    cypher = 10 + Character.toLowerCase((char)this.ch) - 97;
                    break;
                }
                default: {
                    break block4;
                }
            }
            this.putc(this.ch);
            overflow = overflow || value >>> 60 != 0L;
            value = (value << 4) + (long)cypher;
            this.intSize = (k + 1) / 2;
            ++k;
        }
        this.longValue = value;
        this.intValue = (int)value;
        if (Character.isJavaIdentifierPart((char)this.ch) || this.ch == 46) {
            this.environment.error(this.inputFile.position, "err.invalid.number", Character.toString((char)this.ch));
            do {
                this.readCh();
            } while (Character.isJavaIdentifierPart((char)this.ch) || this.ch == 46);
            this.intValue = 0;
        } else if (overflow) {
            this.intValue = 0;
            this.environment.error(this.pos, "err.overflow", new Object[0]);
        }
    }

    private int scanEscapeChar() throws IOException {
        long p = this.inputFile.position;
        this.readCh();
        switch (this.ch) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                int n = this.ch - 48;
                block14: for (int i = 2; i > 0; --i) {
                    this.readCh();
                    switch (this.ch) {
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: {
                            n = (n << 3) + this.ch - 48;
                            continue block14;
                        }
                        default: {
                            if (n > 255) {
                                this.environment.error(p, "err.invalid.escape.char", new Object[0]);
                            }
                            return n;
                        }
                    }
                }
                this.readCh();
                if (n > 255) {
                    this.environment.error(p, "err.invalid.escape.char", new Object[0]);
                }
                return n;
            }
            case 114: {
                this.readCh();
                return 13;
            }
            case 110: {
                this.readCh();
                return 10;
            }
            case 102: {
                this.readCh();
                return 12;
            }
            case 98: {
                this.readCh();
                return 8;
            }
            case 116: {
                this.readCh();
                return 9;
            }
            case 92: {
                this.readCh();
                return 92;
            }
            case 34: {
                this.readCh();
                return 34;
            }
            case 39: {
                this.readCh();
                return 39;
            }
        }
        this.environment.error(p, "err.invalid.escape.char", new Object[0]);
        this.readCh();
        return -1;
    }

    private void scanString() throws IOException {
        this.token = JcodTokens.Token.STRINGVAL;
        this.count = 0;
        this.readCh();
        block6: while (true) {
            switch (this.ch) {
                case -1: {
                    this.environment.error(this.pos, "err.eof.in.string", new Object[0]);
                    break block6;
                }
                case 10: {
                    this.readCh();
                    this.environment.error(this.pos, "err.newline.in.string", new Object[0]);
                    break block6;
                }
                case 34: {
                    this.readCh();
                    break block6;
                }
                case 92: {
                    int c = this.scanEscapeChar();
                    if (c < 0) continue block6;
                    this.putc((char)c);
                    continue block6;
                }
                default: {
                    this.putc(this.ch);
                    this.readCh();
                    continue block6;
                }
            }
            break;
        }
        this.stringValue = this.bufferString();
    }

    private void scanCharArray() throws IOException {
        this.token = JcodTokens.Token.LONGSTRINGVAL;
        ByteBuffer buf = new ByteBuffer();
        this.count = 0;
        this.readCh();
        block6: while (true) {
            int c = this.ch;
            switch (this.ch) {
                case -1: {
                    this.environment.error(this.pos, "err.eof.in.string", new Object[0]);
                    break block6;
                }
                case 10: {
                    this.readCh();
                    this.environment.error(this.pos, "err.newline.in.string", new Object[0]);
                    break block6;
                }
                case 39: {
                    this.readCh();
                    break block6;
                }
                case 92: {
                    c = this.scanEscapeChar();
                    if (c < 0) continue block6;
                }
                default: {
                    if (c > 0 && c <= 127) {
                        buf.write(c);
                    } else if (c == 0 || c >= 128 && c <= 2047) {
                        buf.write(0xC0 | 0x1F & c >> 6);
                        buf.write(0x80 | 0x3F & c);
                    } else {
                        buf.write(0xC0 | 0xF & c >> 12);
                        buf.write(0x80 | 0x3F & c >> 6);
                        buf.write(0x80 | 0x3F & c);
                    }
                    this.readCh();
                }
            }
        }
        this.longStringValue = buf;
    }

    private void scanIdentifier() throws IOException {
        this.count = 0;
        boolean compound = false;
        while (true) {
            this.putc(this.ch);
            this.readCh();
            if (this.ch == 47 || this.ch == 46 || this.ch == 45) {
                compound = true;
                continue;
            }
            if (!Character.isJavaIdentifierPart((char)this.ch)) break;
        }
        this.stringValue = this.bufferString();
        if (compound) {
            this.token = JcodTokens.Token.IDENT;
        } else {
            this.token = JcodTokens.keyword_token_ident(this.stringValue);
            if (this.token == JcodTokens.Token.IDENT) {
                this.intValue = JcodTokens.getConstTagByParseString(this.stringValue);
                if (this.intValue != -1) {
                    ClassFileConst.ConstType constType;
                    if (this.debugCP && (constType = ClassFileConst.getByParseKey(this.stringValue)) != null) {
                        this.addConstDebug(constType);
                    }
                    this.token = JcodTokens.Token.INTVAL;
                    this.intSize = 1;
                    this.longValue = this.intValue;
                }
            }
        }
    }

    protected void skipTill(int sym) throws IOException {
        while (true) {
            if (this.ch == -1) {
                this.environment.error(this.pos, "err.eof.in.comment", new Object[0]);
                return;
            }
            if (this.ch == sym) {
                return;
            }
            this.readCh();
        }
    }

    protected long xscan() throws IOException {
        long retPos = this.pos;
        this.prevPos = this.inputFile.position;
        this.docComment = null;
        this.sign = 1;
        block36: while (true) {
            this.pos = this.inputFile.position;
            switch (this.ch) {
                case -1: {
                    this.token = JcodTokens.Token.EOF;
                    return retPos;
                }
                case 9: 
                case 10: 
                case 12: 
                case 32: {
                    this.readCh();
                    continue block36;
                }
                case 47: {
                    this.readCh();
                    switch (this.ch) {
                        case 47: {
                            do {
                                this.readCh();
                            } while (this.ch != -1 && this.ch != 10);
                            continue block36;
                        }
                        case 42: {
                            this.readCh();
                            if (this.ch == 42) {
                                this.docComment = this.scanDocComment();
                                continue block36;
                            }
                            this.skipComment();
                            continue block36;
                        }
                    }
                    this.token = JcodTokens.Token.DIV;
                    return retPos;
                }
                case 34: {
                    this.scanString();
                    return retPos;
                }
                case 39: {
                    this.scanCharArray();
                    return retPos;
                }
                case 45: {
                    this.sign = -this.sign;
                }
                case 43: {
                    this.readCh();
                    continue block36;
                }
                case 48: {
                    this.readCh();
                    this.token = JcodTokens.Token.INTVAL;
                    this.intValue = 0;
                    this.longValue = 0;
                    switch (this.ch) {
                        case 88: 
                        case 120: {
                            this.scanHexNumber();
                            break;
                        }
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            this.scanDecNumber();
                            break;
                        }
                        case 98: {
                            this.readCh();
                            this.intSize = 1;
                            break;
                        }
                        case 115: {
                            this.readCh();
                            this.intSize = 2;
                            break;
                        }
                        case 105: {
                            this.readCh();
                            this.intSize = 4;
                            break;
                        }
                        case 108: {
                            this.readCh();
                            this.intSize = 8;
                            break;
                        }
                        default: {
                            this.intSize = 2;
                        }
                    }
                    return retPos;
                }
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    this.scanDecNumber();
                    return retPos;
                }
                case 123: {
                    this.readCh();
                    this.token = JcodTokens.Token.LBRACE;
                    return retPos;
                }
                case 125: {
                    this.readCh();
                    this.token = JcodTokens.Token.RBRACE;
                    return retPos;
                }
                case 40: {
                    this.readCh();
                    this.token = JcodTokens.Token.LPAREN;
                    return retPos;
                }
                case 41: {
                    this.readCh();
                    this.token = JcodTokens.Token.RPAREN;
                    return retPos;
                }
                case 91: {
                    this.readCh();
                    this.token = JcodTokens.Token.LSQBRACKET;
                    return retPos;
                }
                case 93: {
                    this.readCh();
                    this.token = JcodTokens.Token.RSQBRACKET;
                    return retPos;
                }
                case 44: {
                    this.readCh();
                    this.token = JcodTokens.Token.COMMA;
                    return retPos;
                }
                case 59: {
                    this.readCh();
                    this.token = JcodTokens.Token.SEMICOLON;
                    return retPos;
                }
                case 58: {
                    this.readCh();
                    this.token = JcodTokens.Token.COLON;
                    return retPos;
                }
                case 61: {
                    this.readCh();
                    if (this.ch == 61) {
                        this.readCh();
                        this.token = JcodTokens.Token.EQ;
                        return retPos;
                    }
                    this.token = JcodTokens.Token.ASSIGN;
                    return retPos;
                }
                case 26: {
                    this.readCh();
                    if (this.ch == -1) {
                        this.token = JcodTokens.Token.EOF;
                        return retPos;
                    }
                    this.environment.error(this.pos, "err.funny.char", new Object[0]);
                    this.readCh();
                    continue block36;
                }
                case 35: {
                    this.readCh();
                    this.scanDecNumber();
                    return retPos;
                }
                case 38: {
                    this.readCh();
                    retPos = this.pos;
                    if (!Character.isJavaIdentifierStart((char)this.ch)) {
                        this.environment.error(this.pos, "err.identifier.expected", new Object[0]);
                    }
                    this.scanIdentifier();
                    String macroId = this.stringValue;
                    String macro = this.macros.get(macroId);
                    if (macro == null) {
                        this.environment.error(this.pos, "err.macro.undecl", macroId);
                        throw new SyntaxError();
                    }
                    this.setMacro(macro);
                    this.readCh();
                    continue block36;
                }
            }
            if (Character.isJavaIdentifierStart((char)this.ch)) {
                this.scanIdentifier();
                return retPos;
            }
            this.environment.error(this.pos, "err.funny.char", new Object[0]);
            this.readCh();
        }
    }

    protected void match(JcodTokens.Token open, JcodTokens.Token close) throws IOException {
        int depth = 1;
        while (true) {
            this.scan();
            if (this.token == open) {
                ++depth;
                continue;
            }
            if (this.token == close) {
                if (--depth != 0) continue;
                return;
            }
            if (this.token == JcodTokens.Token.EOF) break;
        }
        this.environment.error(this.pos, "err.unbalanced.paren", new Object[0]);
    }

    protected long scan() throws IOException {
        return this.xscan();
    }

    protected long scanMacro() throws IOException {
        return this.xscan();
    }
}

