/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdec;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.openjdk.asmtools.common.DecompilerLogger;
import org.openjdk.asmtools.common.inputs.FileInput;
import org.openjdk.asmtools.common.inputs.ToolInput;
import org.openjdk.asmtools.common.outputs.EscapedPrintStreamOutput;
import org.openjdk.asmtools.common.outputs.FSOutput;
import org.openjdk.asmtools.common.outputs.StdoutOutput;
import org.openjdk.asmtools.common.outputs.ToolOutput;
import org.openjdk.asmtools.common.outputs.log.DualOutputStreamOutput;
import org.openjdk.asmtools.common.outputs.log.DualStreamToolOutput;
import org.openjdk.asmtools.common.outputs.log.StderrLog;
import org.openjdk.asmtools.jdec.ClassData;
import org.openjdk.asmtools.jdec.JdecEnvironment;
import org.openjdk.asmtools.jdec.JdecTool;
import org.openjdk.asmtools.util.ProductInfo;

public class Main
extends JdecTool {
    public Main(ToolOutput toolOutput, DualStreamToolOutput log, ToolInput ... toolInputs) {
        super(toolOutput, log);
        Collections.addAll(this.fileList, toolInputs);
    }

    public Main(ToolOutput toolOutput, DualStreamToolOutput log, ToolInput toolInput, String ... argv) {
        super(toolOutput, log);
        if (toolInput != null) {
            this.fileList.add(toolInput);
        }
        this.parseArgs(argv);
    }

    public Main(ToolOutput toolOutput, DualStreamToolOutput log, String ... argv) {
        this(toolOutput, log, (ToolInput)null, argv);
    }

    public Main(EscapedPrintStreamOutput toolOutput, String[] argv) {
        this((ToolOutput)toolOutput, (DualStreamToolOutput)new StderrLog(), argv);
    }

    public Main(ToolOutput toolOutput, DualStreamToolOutput log, ToolInput toolInput) {
        super(toolOutput, log);
        this.fileList.add(toolInput);
    }

    public static void main(String ... argv) {
        Main decoder = new Main(new StdoutOutput(), argv);
        System.exit(decoder.decode());
    }

    @Override
    public void usage() {
        ((JdecEnvironment)this.environment).usage(List.of("info.usage", "info.opt.d", "info.opt.w", "info.opt.g", "info.opt.v", "info.opt.version"));
    }

    @Override
    protected void parseArgs(String ... argv) {
        block23: for (int i = 0; i < argv.length; ++i) {
            String arg;
            switch (arg = argv[i]) {
                case "-g": {
                    this.setPrintDetails(true);
                    continue block23;
                }
                case "-v": {
                    ((JdecEnvironment)this.environment).setVerboseFlag(true);
                    continue block23;
                }
                case "-t": {
                    ((JdecEnvironment)this.environment).setVerboseFlag(true);
                    ((JdecEnvironment)this.environment).setTraceFlag(true);
                    continue block23;
                }
                case "-w": {
                    ((JdecEnvironment)this.environment).setIgnorePackage(true);
                    this.setFSDestination(FSOutput.FSDestination.DIR, ++i, argv);
                    continue block23;
                }
                case "-d": {
                    this.setFSDestination(FSOutput.FSDestination.DIR, ++i, argv);
                    continue block23;
                }
                case "-dls": {
                    ((JdecEnvironment)this.environment).setOutputs(new DualOutputStreamOutput());
                    continue block23;
                }
                case "-version": {
                    ((JdecEnvironment)this.environment).println(ProductInfo.FULL_VERSION, new Object[0]);
                    System.exit(0);
                }
                case "-h": 
                case "-help": {
                    this.usage();
                    System.exit(0);
                }
                case "-": {
                    this.addStdIn();
                    continue block23;
                }
                default: {
                    if (arg.startsWith("-")) {
                        ((JdecEnvironment)this.environment).error("err.invalid_option", arg);
                        this.usage();
                        System.exit(1);
                        continue block23;
                    }
                    this.fileList.add(new FileInput(arg));
                }
            }
        }
        if (this.fileList.isEmpty()) {
            this.usage();
            System.exit(1);
        }
    }

    public void setPrintDetails(boolean value) {
        ((JdecEnvironment)this.environment).setPrintDetailsFlag(value);
    }

    @Override
    public synchronized int decode() {
        int rc = 0;
        for (ToolInput toolInput : this.fileList) {
            try {
                ((JdecEnvironment)this.environment).setToolInput(toolInput);
                ClassData classData = new ClassData((JdecEnvironment)this.environment);
                classData.decodeClass();
                ((JdecEnvironment)this.environment).getOutputs().flush();
                rc += ((DecompilerLogger)((JdecEnvironment)this.environment).getLogger()).registerTotalIssues(rc, toolInput);
                ((DecompilerLogger)((JdecEnvironment)this.environment).getLogger()).flush();
                continue;
            }
            catch (FileNotFoundException fnf) {
                ((JdecEnvironment)this.environment).printException(fnf);
                ((JdecEnvironment)this.environment).error("err.not_found", toolInput);
                rc = 1;
            }
            catch (IOException | ClassFormatError ioe) {
                ((JdecEnvironment)this.environment).error(ioe);
                ((JdecEnvironment)this.environment).printException(ioe);
                rc += ((DecompilerLogger)((JdecEnvironment)this.environment).getLogger()).registerTotalIssues(rc, toolInput);
            }
            catch (Error error) {
                ((JdecEnvironment)this.environment).error(error);
                ((JdecEnvironment)this.environment).printException(error);
                rc += ((DecompilerLogger)((JdecEnvironment)this.environment).getLogger()).registerTotalIssues(rc, toolInput);
            }
            catch (Exception ex) {
                ((JdecEnvironment)this.environment).error(ex);
                ((JdecEnvironment)this.environment).printException(ex);
                rc += ((DecompilerLogger)((JdecEnvironment)this.environment).getLogger()).registerTotalIssues(rc, toolInput);
            }
            ((DecompilerLogger)((JdecEnvironment)this.environment).getLogger()).flush();
            break;
        }
        return rc;
    }
}

