/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdis;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.function.Consumer;
import org.openjdk.asmtools.jasm.TableFormatModel;
import org.openjdk.asmtools.jdis.Indenter;
import org.openjdk.asmtools.jdis.Measurable;
import org.openjdk.asmtools.jdis.MemberData;
import org.openjdk.asmtools.jdis.Printable;

public class Container<T extends Indenter, M extends MemberData<?>>
extends Indenter
implements Iterable<T>,
Measurable {
    protected final ArrayList<T> elements;
    protected M owner;

    public Container(M owner, Class<T> elementClass, int initialCapacity) {
        this.owner = owner;
        this.elements = new ArrayList(initialCapacity);
        this.tableToken = TableFormatModel.Token.getBy(elementClass);
    }

    protected final boolean isCollectionMeasurable() {
        return !this.elements.isEmpty() && this.elements.get(0) instanceof Measurable;
    }

    @Override
    public void print() throws IOException {
        int size = this.size();
        if (size > 0) {
            boolean isExtendedPrintingSupported = this.tableToken.isExtendedPrintingSupported();
            this.setMaxPrintSize(this.getPrintSize());
            for (int i = 0; i < size; ++i) {
                Indenter element = (Indenter)this.elements.get(i);
                if (element instanceof Measurable) {
                    Measurable measurable = (Measurable)((Object)element);
                    measurable.setMaxPrintSize(this.getMaxPrintSize());
                }
                element.setCommentOffset(this.getCommentOffset());
                if (isExtendedPrintingSupported && this.isTableOutput()) {
                    element.tablePrint(i, size);
                    continue;
                }
                element.jasmPrint(i, size);
            }
        }
    }

    public void add(T element) throws IOException {
        if (element instanceof MemberData) {
            MemberData md = (MemberData)element;
            md.setOwner(this.owner);
        }
        this.elements.add(element);
    }

    public int size() {
        return this.elements.size();
    }

    public T get(int index) {
        return (T)((Indenter)this.elements.get(index));
    }

    @Override
    public boolean isPrintable() {
        return !this.elements.isEmpty() && this.elements.stream().anyMatch(Printable::isPrintable);
    }

    @Override
    public int getPrintSize() {
        if (!this.maxSizeCalculated && this.isCollectionMeasurable()) {
            this.maxSize = this.isCollectionMeasurable() ? this.elements.stream().map(e -> (Measurable)((Object)e)).mapToInt(Measurable::getPrintSize).max().orElse(0) : 0;
            this.maxSizeCalculated = true;
        }
        return this.maxSize;
    }

    @Override
    public void setMaxPrintSize(int maxSize) {
        if (maxSize > 0 && this.isCollectionMeasurable()) {
            this.elements.stream().map(e -> (Measurable)((Object)e)).peek(e -> e.setMaxPrintSize(maxSize));
        }
    }

    @Override
    public int getMaxPrintSize() {
        return this.getPrintSize();
    }

    public Container<T, M> setPrintable(boolean value) {
        this.printable = value;
        return this;
    }

    @Override
    public Container<T, M> setHasSize(boolean value) {
        this.hasSize = true;
        return this;
    }

    @Override
    public Iterator<T> iterator() {
        return this.elements.iterator();
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        this.elements.forEach((Consumer<T>)action);
    }

    @Override
    public Spliterator<T> spliterator() {
        return this.elements.spliterator();
    }
}

