/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdis;

import java.io.DataInputStream;
import java.io.IOException;
import org.openjdk.asmtools.jasm.JasmTokens;
import org.openjdk.asmtools.jdis.Indenter;
import org.openjdk.asmtools.jdis.MethodData;

public class LineNumberData
extends Indenter {
    protected short start_pc;
    protected short line_number;
    protected String format;

    @Override
    public boolean isPrintable() {
        return this.printLineTable;
    }

    @Override
    protected void jasmPrint(int index, int size) throws IOException {
        this.incIndent();
        if (index == 0) {
            this.printIndentLn(this.getTitle());
        }
        this.printIndentLn(this.format.formatted("line", this.line_number, this.start_pc));
    }

    @Override
    protected String getTitle() {
        return JasmTokens.Token.LINETABLE_HEADER.parseKey() + ":";
    }

    @Override
    protected void tablePrint(int index, int size) throws IOException {
        this.jasmPrint(index, size);
    }

    public LineNumberData(DataInputStream in, MethodData methodData) throws IOException {
        this.start_pc = in.readShort();
        this.line_number = in.readShort();
        this.toolOutput = methodData.toolOutput;
        int n = methodData.printProgramCounter ? 11 : 9;
        this.format = "%" + n + "s %4d:  %7d";
    }
}

