/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdis;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.HashSet;
import org.openjdk.asmtools.common.FormatError;
import org.openjdk.asmtools.jasm.JasmTokens;
import org.openjdk.asmtools.jdis.ClassData;
import org.openjdk.asmtools.jdis.ConstantPool;
import org.openjdk.asmtools.jdis.MemberData;
import org.openjdk.asmtools.jdis.ModuleContent;
import org.openjdk.asmtools.jdis.Options;

public class ModuleData
extends MemberData<ClassData> {
    protected final boolean printCPIndex = Options.contains(Options.PrintOption.CP_INDEX);
    private ModuleContent moduleContent;

    public ModuleData(ClassData classData) {
        super(classData);
    }

    public String getModuleName() {
        return this.moduleContent == null ? "N/A" : this.moduleContent.getModuleName();
    }

    public String getModuleVersion() {
        return this.moduleContent == null ? null : this.moduleContent.getModuleVersion();
    }

    public String getModuleHeader(String versionString) {
        StringBuilder sb = new StringBuilder(25);
        if (this.moduleContent == null) {
            sb.append(JasmTokens.Token.MODULE.parseKey());
            sb.append(' ');
            if (this.printCPIndex) {
                sb.append(String.format("#?? /* %s */", this.getModuleName()));
            } else {
                sb.append(this.getModuleName());
            }
            if (versionString != null && versionString.length() > 0) {
                sb.append(' ').append(versionString);
            }
        } else {
            sb.append(this.moduleContent.getModuleFlags());
            sb.append(JasmTokens.Token.MODULE.parseKey()).append(' ');
            if (this.printCPIndex) {
                sb.append(String.format("#%d /* %s%s%s", this.moduleContent.getModuleCPX(), this.moduleContent.getModuleName(), this.moduleContent.getModuleVersion() != null ? "@" + this.moduleContent.getModuleVersion() + " */" : " */", versionString != null && versionString.length() > 0 ? " " + versionString : ""));
            } else {
                sb.append(this.moduleContent.getModuleName());
                if (versionString != null && versionString.length() > 0) {
                    sb.append(' ').append(versionString);
                }
                if (this.moduleContent.getModuleVersion() != null) {
                    sb.append("// @").append(this.moduleContent.getModuleVersion());
                }
            }
        }
        return sb.toString();
    }

    public void read(DataInputStream in) throws FormatError {
        int j;
        int i;
        String version;
        int versionIndex;
        String moduleName;
        int index;
        ModuleContent.Builder builder = null;
        try {
            index = in.readUnsignedShort();
            moduleName = this.pool.getModuleName(index);
            int moduleFlags = in.readUnsignedShort();
            versionIndex = in.readUnsignedShort();
            version = this.pool.getString(versionIndex, ind -> null);
            builder = new ModuleContent.Builder(index, moduleName, moduleFlags, version);
        }
        catch (IOException ioe) {
            if (this.bestEffort) {
                this.environment.getLogger().error("err.invalid_header", new Object[0]);
                if (builder == null) {
                    return;
                }
            }
            throw new FormatError(this.environment.getLogger(), "err.invalid_header", new Object[0]);
        }
        try {
            int requires_count = in.readUnsignedShort();
            for (i = 0; i < requires_count; ++i) {
                index = in.readUnsignedShort();
                int requiresFlags = in.readUnsignedShort();
                versionIndex = in.readUnsignedShort();
                moduleName = this.pool.getModuleName(index);
                version = this.pool.getString(versionIndex, ind -> null);
                builder.require(index, moduleName, requiresFlags, version);
            }
        }
        catch (IOException ioe) {
            if (this.bestEffort) {
                this.environment.getLogger().error("err.invalid_requires", new Object[0]);
            }
            throw new FormatError(this.environment.getLogger(), "err.invalid_requires", new Object[0]);
        }
        try {
            int exports_count = in.readUnsignedShort();
            if (exports_count > 0) {
                for (i = 0; i < exports_count; ++i) {
                    index = in.readUnsignedShort();
                    String packageName = this.pool.getPackageName(index);
                    int exportsFlags = in.readUnsignedShort();
                    int exports_to_count = in.readUnsignedShort();
                    if (exports_to_count > 0) {
                        HashSet<ModuleContent.TargetType> targets = new HashSet<ModuleContent.TargetType>(exports_to_count);
                        for (j = 0; j < exports_to_count; ++j) {
                            int exports_to_index = in.readUnsignedShort();
                            targets.add(new ModuleContent.TargetType(ConstantPool.TAG.CONSTANT_MODULE, exports_to_index, this.pool.getModuleName(exports_to_index)));
                        }
                        builder.exports(index, packageName, exportsFlags, targets);
                        continue;
                    }
                    builder.exports(index, packageName, exportsFlags);
                }
            }
        }
        catch (IOException ioe) {
            if (this.bestEffort) {
                this.environment.getLogger().error("err.invalid_exports", new Object[0]);
            }
            throw new FormatError(this.environment.getLogger(), "err.invalid_exports", new Object[0]);
        }
        try {
            int opens_count = in.readUnsignedShort();
            if (opens_count > 0) {
                for (i = 0; i < opens_count; ++i) {
                    index = in.readUnsignedShort();
                    String packageName = this.pool.getPackageName(index);
                    int opensFlags = in.readUnsignedShort();
                    int opens_to_count = in.readUnsignedShort();
                    if (opens_to_count > 0) {
                        HashSet<ModuleContent.TargetType> opens = new HashSet<ModuleContent.TargetType>(opens_to_count);
                        for (j = 0; j < opens_to_count; ++j) {
                            int opens_to_index = in.readUnsignedShort();
                            opens.add(new ModuleContent.TargetType(ConstantPool.TAG.CONSTANT_MODULE, opens_to_index, this.pool.getModuleName(opens_to_index)));
                        }
                        builder.opens(index, packageName, opensFlags, opens);
                        continue;
                    }
                    builder.opens(index, packageName, opensFlags);
                }
            }
        }
        catch (IOException ioe) {
            if (this.bestEffort) {
                this.environment.getLogger().error("err.invalid_opens", new Object[0]);
            }
            throw new FormatError(this.environment.getLogger(), "err.invalid_opens", new Object[0]);
        }
        try {
            int uses_count = in.readUnsignedShort();
            if (uses_count > 0) {
                for (i = 0; i < uses_count; ++i) {
                    index = in.readUnsignedShort();
                    String serviceName = this.pool.getClassName(index);
                    builder.uses(index, serviceName);
                }
            }
        }
        catch (IOException ioe) {
            if (this.bestEffort) {
                this.environment.getLogger().error("err.invalid_uses", new Object[0]);
            }
            throw new FormatError(this.environment.getLogger(), "err.invalid_uses", new Object[0]);
        }
        try {
            int provides_count = in.readUnsignedShort();
            if (provides_count > 0) {
                for (i = 0; i < provides_count; ++i) {
                    index = in.readUnsignedShort();
                    String serviceName = this.pool.getClassName(index);
                    int provides_with_count = in.readUnsignedShort();
                    HashSet<ModuleContent.TargetType> implNames = new HashSet<ModuleContent.TargetType>(provides_with_count);
                    for (int j2 = 0; j2 < provides_with_count; ++j2) {
                        int provides_with_index = in.readUnsignedShort();
                        implNames.add(new ModuleContent.TargetType(ConstantPool.TAG.CONSTANT_CLASS, provides_with_index, this.pool.getClassName(provides_with_index)));
                    }
                    builder.provides(index, serviceName, implNames);
                }
            }
        }
        catch (IOException ioe) {
            if (this.bestEffort) {
                this.environment.getLogger().error("err.invalid_provides", new Object[0]);
            }
            throw new FormatError(this.environment.getLogger(), "err.invalid_provides", new Object[0]);
        }
        this.moduleContent = builder.build();
    }

    @Override
    public void print() {
        String s;
        if (this.moduleContent != null && !(s = this.moduleContent.toString()).isEmpty()) {
            this.println(s);
        }
    }
}

