/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdis;

import java.util.EnumSet;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.openjdk.asmtools.jdis.Indenter;

public class Options {
    private static final EnumSet<PrintOption> PRINT_OPTIONS = EnumSet.of(PrintOption.LABELS);
    private static final EnumSet<PrintOption> DETAILED_OUTPUT = EnumSet.of(PrintOption.CONSTANT_POOL, PrintOption.PRINT_BCI, PrintOption.CP_INDEX, PrintOption.DETAILED_Output);
    private static final EnumSet<PrintOption> DROP_ALL = EnumSet.of(PrintOption.DROP_Source, PrintOption.DROP_Classes, PrintOption.DROP_CharacterRange);
    private static final EnumSet<PrintOption> LINE_NUMBER_TABLE_ALL = EnumSet.of(PrintOption.LINE_NUMBER_TABLE_Numbers, PrintOption.LINE_NUMBER_TABLE_Lines, PrintOption.LINE_NUMBER_TABLE_Table);
    private static final EnumSet<PrintOption> LOCAL_VARIABLE_ALL = EnumSet.of(PrintOption.LOCAL_VARIABLE_Vars, PrintOption.LOCAL_VARIABLE_Types);

    public static String getPrintOptions() {
        return PRINT_OPTIONS.stream().map(op -> String.format("%-26s: \"%s\"", op.name(), op.descriptor)).collect(Collectors.joining("\n"));
    }

    public static void set(PrintOption val) {
        if (val == PrintOption.PRINT_BCI) {
            Indenter.TABLE_PADDING = 27;
        }
        PRINT_OPTIONS.add(val);
    }

    public static void unset(PrintOption val) {
        if (val == PrintOption.PRINT_BCI) {
            Indenter.TABLE_PADDING = 25;
        }
        PRINT_OPTIONS.remove((Object)val);
    }

    public static void setDetailedOutputOptions() {
        Options.set(DETAILED_OUTPUT);
        Options.unset(PrintOption.LABELS);
    }

    public static void set(EnumSet<PrintOption> vals) {
        for (PrintOption val : vals) {
            Options.set(val);
        }
    }

    public static void unset(EnumSet<PrintOption> vals) {
        for (PrintOption val : vals) {
            Options.unset(val);
        }
    }

    public static void setGroupOption(PrintOption option) {
        switch (option) {
            case LOCAL_VARIABLE_All: {
                Options.set(LOCAL_VARIABLE_ALL);
                break;
            }
            case LINE_NUMBER_TABLE_All: {
                Options.set(LINE_NUMBER_TABLE_ALL);
                break;
            }
            case DROP_All: {
                Options.set(DROP_ALL);
                break;
            }
            default: {
                throw new RuntimeException("%s ia not group option".formatted(option.name()));
            }
        }
    }

    public static void setDefaultOutputOptions() {
        PRINT_OPTIONS.clear();
        Options.set(PrintOption.LABELS);
    }

    public static boolean contains(PrintOption ... vals) {
        for (PrintOption val : vals) {
            if (!PRINT_OPTIONS.contains((Object)val)) continue;
            return true;
        }
        return false;
    }

    public static String asShortString() {
        return String.format("[ %s ]", PRINT_OPTIONS.stream().map(item -> item.name()).collect(Collectors.joining(", ")));
    }

    public static enum PrintOption {
        NONE("No options"),
        CONSTANT_POOL("Constant Pool"),
        PRINT_BCI("Program Counter - for all instructions"),
        LABELS("Labels (as identifiers)"),
        CP_INDEX("CP index along with arguments"),
        LINE_NUMBER_TABLE_Numbers("Line Numbers in comments"),
        LINE_NUMBER_TABLE_Lines("Java Source Lines in comments"),
        LINE_NUMBER_TABLE_Table("LineNumberTable attribute as table"),
        LINE_NUMBER_TABLE_All("Line Numbers, Source Lines, attribute as Table", option -> Options.setGroupOption(option)),
        LOCAL_VARIABLE_Vars("Print LocalVariableTable attribute"),
        LOCAL_VARIABLE_Types("Print LocalVariableTypeTable attribute"),
        LOCAL_VARIABLE_All("Print both LocalVariableTable and LocalVariableTypeTable attributes", option -> Options.setGroupOption(option)),
        HEX("Numbers as hexadecimals"),
        TRACE("Print internal traces, debug information"),
        SYSINFO("system information"),
        NO_COMMENTS("No comments, suppress printing comments"),
        VERBOSE("Verbose information"),
        TABLE("Attributes as table"),
        DROP_Source("Discard SourceFile attribute"),
        DROP_Signatures("Discard Signature attribute"),
        DROP_Classes("Discard this_class and super_class pair"),
        DROP_CharacterRange("Discard CharacterRangeTable attribute"),
        DROP_All("Discard SourceFile, CharacterRangeTable attributes, this_class and super_class pair", option -> Options.setGroupOption(option)),
        DETAILED_Output("Detailed output"),
        EXTRA_DETAILED_Output("Detailed output, this_class and super_class pair"),
        BEST_EFFORT("Print as much as possible despite errors");

        final String descriptor;
        final Consumer<PrintOption> action;
        private static final EnumSet<PrintOption> inProgresses;

        private PrintOption(String descriptor) {
            this.descriptor = descriptor;
            this.action = null;
        }

        private PrintOption(String descriptor, Consumer<PrintOption> action) {
            this.descriptor = descriptor;
            this.action = action;
        }

        public void apply() {
            if (this.action != null) {
                this.action.accept(this);
            } else {
                Options.set(this);
            }
        }

        public static PrintOption getStringFlag(String prefix, String flag) {
            for (PrintOption item : PrintOption.values()) {
                int ind;
                String name = item.name();
                if (!name.startsWith(prefix) || (ind = item.name().lastIndexOf(95)) <= 0 || !name.substring(ind + 1).equalsIgnoreCase(flag)) continue;
                return item;
            }
            return null;
        }

        public boolean isActive() {
            return !inProgresses.contains((Object)this);
        }

        static {
            inProgresses = EnumSet.of(DROP_CharacterRange);
        }
    }
}

