/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdis;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.openjdk.asmtools.jdis.AnnotationData;
import org.openjdk.asmtools.jdis.MemberData;

public class ParameterAnnotationData<T extends MemberData>
extends MemberData {
    private final boolean invisible;
    private ArrayList<ArrayList<AnnotationData<T>>> array = null;

    public ParameterAnnotationData(T data, boolean invisible) {
        super(data);
        this.invisible = invisible;
    }

    public int numParameters() {
        return this.array == null ? 0 : this.array.size();
    }

    public ArrayList<AnnotationData<T>> get(int i) {
        return this.array.get(i);
    }

    public void read(DataInputStream in) throws IOException {
        int numParams = in.readByte();
        this.environment.traceln("ParameterAnnotationData[%d]:", numParams);
        this.array = new ArrayList(numParams);
        for (int paramNum = 0; paramNum < numParams; ++paramNum) {
            int numAnnotations = in.readShort();
            this.environment.traceln(" Param#[%d]: numAnnotations= %d", paramNum, numAnnotations);
            if (numAnnotations > 0) {
                ArrayList<AnnotationData<MemberData>> paramAnnotationList = new ArrayList<AnnotationData<MemberData>>(numAnnotations);
                for (int annotIndex = 0; annotIndex < numAnnotations; ++annotIndex) {
                    AnnotationData<MemberData> annotationData = new AnnotationData<MemberData>(this.data, this.invisible);
                    annotationData.read(in);
                    paramAnnotationList.add(annotationData);
                }
                this.array.add(paramNum, paramAnnotationList);
                continue;
            }
            this.array.add(paramNum, null);
        }
    }
}

