/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdis;

import java.io.DataInputStream;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.function.Function;
import org.openjdk.asmtools.asmutils.Pair;
import org.openjdk.asmtools.common.FormatError;
import org.openjdk.asmtools.common.structure.EAttribute;
import org.openjdk.asmtools.jasm.TableFormatModel;
import org.openjdk.asmtools.jdis.ClassData;
import org.openjdk.asmtools.jdis.MemberData;
import org.openjdk.asmtools.jdis.notations.Signature;
import org.openjdk.asmtools.jdis.notations.Type;

public class SignatureData
extends MemberData<ClassData> {
    private int cpIndex;
    private Type signatureType = null;
    private int keywordPadding = -1;
    private String attributeTerminator = ";";
    private String eol = System.getProperty("line.separator");

    public SignatureData(ClassData classData) {
        super(classData);
        this.tableToken = TableFormatModel.Token.SIGNATURE;
    }

    public int getCPIndex() {
        return this.cpIndex;
    }

    @Override
    public boolean isPrintable() {
        return !this.dropSignatures;
    }

    public SignatureData read(DataInputStream in, int attribute_length) throws IOException, ClassFormatError {
        if (attribute_length != 2) {
            if (this.bestEffort) {
                this.environment.getLogger().error("err.invalid.attribute.length", EAttribute.ATT_Signature.printValue(), attribute_length);
            } else {
                throw new FormatError(this.environment.getLogger(), "err.invalid.attribute.length", new Object[]{EAttribute.ATT_Signature.printValue(), attribute_length});
            }
        }
        this.cpIndex = in.readUnsignedShort();
        return this;
    }

    public String toString() {
        return String.format("signature[%d]=%s", this.cpIndex, this.pool.StringValue(this.cpIndex));
    }

    public String getJavaSignature() {
        if (this.signatureType == null) {
            this.signatureType = new Signature(this.environment.getLogger(), this.cpIndex).getType(this.pool);
        }
        return this.signatureType != null ? this.signatureType.toString().replace('/', '.') : this.pool.StringValue(this.cpIndex);
    }

    public Type getSignatureType() {
        if (this.signatureType == null) {
            this.signatureType = new Signature(this.environment.getLogger(), this.cpIndex).getType(this.pool);
        }
        return this.signatureType;
    }

    public SignatureData setKeywordPadding(int keywordPadding) {
        this.keywordPadding = keywordPadding;
        return this;
    }

    @Override
    protected int getPrintAttributeKeyPadding() {
        return this.keywordPadding == -1 ? super.getPrintAttributeKeyPadding() : this.keywordPadding;
    }

    public SignatureData disableNewLine() {
        this.eol = "";
        return this;
    }

    public SignatureData enableNewLine() {
        this.eol = System.getProperty("line.separator");
        return this;
    }

    @Override
    protected void tablePrint() {
        this.printIndent(this.PadRight(this.tableToken.printKey(), this.getPrintAttributeKeyPadding()));
        String sign = this.pool.StringValue(this.cpIndex);
        if (this.printCPIndex) {
            if (this.skipComments) {
                this.print("#%d%s".formatted(this.cpIndex, this.attributeTerminator).concat(this.eol));
            } else {
                this.print(this.PadRight("#%d%s".formatted(this.cpIndex, this.attributeTerminator), this.getPrintAttributeCommentPadding())).print(" // ".concat(sign).concat(this.eol));
            }
        } else {
            this.print(sign.concat("%s".formatted(this.attributeTerminator)).concat(this.eol));
        }
    }

    @Override
    protected void jasmPrint() {
        this.printIndent(this.PadRight(TableFormatModel.Token.SIGNATURE.parseKey(), this.getPrintAttributeKeyPadding()));
        String sign = this.pool.StringValue(this.cpIndex);
        if (this.printCPIndex) {
            if (this.skipComments) {
                this.print("#%d%s".formatted(this.cpIndex, this.attributeTerminator).concat(this.eol));
            } else {
                this.print(this.PadRight("#%d%s".formatted(this.cpIndex, this.attributeTerminator), this.getPrintAttributeCommentPadding())).print(" // ".concat(sign).concat(this.eol));
            }
        } else {
            this.print(sign.concat("%s".formatted(this.attributeTerminator)).concat(this.eol));
        }
    }

    public Pair<String, String> getJasmPrintInfo(Function<Integer, Boolean> checkRange) {
        return this.tableFormat ? new Pair<String, String>("", "") : new Pair<String, CallSite>(String.format(":#%d", this.cpIndex), (CallSite)(checkRange.apply(this.cpIndex) != false ? ":" + this.pool.StringValue(this.cpIndex) : ":?%d Invalid constant_pool index".formatted(this.cpIndex)));
    }

    public void terminateMethodSignature(boolean value) {
        this.attributeTerminator = value ? ";" : ",";
    }
}

