/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdis;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.openjdk.asmtools.asmutils.Pair;
import org.openjdk.asmtools.asmutils.Range;
import org.openjdk.asmtools.asmutils.StringUtils;
import org.openjdk.asmtools.common.structure.EAttribute;
import org.openjdk.asmtools.common.structure.StackMap;
import org.openjdk.asmtools.jasm.JasmTokens;
import org.openjdk.asmtools.jasm.TableFormatModel;
import org.openjdk.asmtools.jdis.CodeData;
import org.openjdk.asmtools.jdis.MemberData;

public class StackMapData
extends MemberData<CodeData> {
    static Range<Integer> range = new Range<Integer>(247, 255);
    private final EAttribute attribute;
    StackMap.EntryType stackEntryType;
    int stackEntryTypeValue;
    boolean isWrapped = false;
    int wrapLevel = 0;
    int frame_pc;
    int offset;
    int[] lockMap;
    int[] stackMap;
    int[] unsetFields;
    private Printer printer;
    private int doubleIndent = this.getIndentStep() * 2;
    private int tripleIndent = this.getIndentStep() * 3;
    private String intLine = "";
    private String strLine = "";
    private int shift;
    private String tableHeader = "";

    @Override
    protected void jasmPrint(int index, int size) throws IOException {
        this.incIndent();
        if (index == 0) {
            this.printIndentLn(this.tableHeader);
        }
        this.printer.accept(index, size);
        this.decIndent();
    }

    private void stackMapPrinter(int index, int size) throws IOException {
        this.println(this.enlargedIndent(this.intLine.formatted(JasmTokens.Token.BYTECODEOFFSET.parseKey(), this.frame_pc), this.getIndentStep()));
        for (Map.Entry<String, Pair<Boolean, int[]>> entry : Map.of("%-10s".formatted(JasmTokens.Token.STACKMAP.parseKey()), new Pair<Boolean, int[]>(this.stackMap != null, this.stackMap), "%-10s".formatted(JasmTokens.Token.LOCALSMAP.parseKey()), new Pair<Boolean, int[]>(this.lockMap != null, this.lockMap)).entrySet()) {
            if (!((Boolean)entry.getValue().first).booleanValue()) continue;
            int[] map = (int[])entry.getValue().second;
            Pair<String, String> line = this.getMapListAsString(map, " ");
            String record = this.strLine.formatted(entry.getKey(), "[" + (this.printCPIndex ? (String)line.first : (String)line.second) + "]");
            if (this.printCPIndex) {
                if (this.skipComments) {
                    this.println(this.enlargedIndent(record, this.getIndentStep() * 2));
                    continue;
                }
                this.print(this.PadRight(this.enlargedIndent(record, this.getIndentStep()), this.getCommentOffsetFor(27, 2)));
                this.println((String)(map.length == 0 ? "" : " //" + (String)line.second));
                continue;
            }
            this.println(this.enlargedIndent(record, this.getIndentStep() * 2));
        }
    }

    private void stackMapTablePrinter(int index, int size) {
        block22: {
            int padding;
            block21: {
                String strFrameType = this.intLine.formatted(JasmTokens.Token.FRAMETYPE.parseKey(), this.stackEntryTypeValue);
                padding = 0;
                if (this.isWrapped) {
                    this.incIndent(this.wrapLevel);
                }
                if (this.skipComments && this.printCPIndex) {
                    this.printIndentLn(strFrameType);
                } else {
                    padding = this.doubleIndent + (this.printCPIndex ? this.getCommentOffsetFor(strFrameType, 2) : strFrameType.length() + padding * this.getIndentStep());
                    if (this.printCPIndex) {
                        this.printIndent(this.PadRight(strFrameType, padding - this.getIndentStep() * (this.wrapLevel + 2)));
                        this.println((String)(this.skipComments ? "" : " // " + this.stackEntryType.printName()));
                    } else {
                        this.printIndent(this.PadRight(strFrameType, padding - this.getIndentStep() * this.wrapLevel));
                        this.println((String)(this.skipComments ? "" : " // " + this.stackEntryType.printName()));
                    }
                }
                if (range.in(this.stackEntryTypeValue)) {
                    this.println(this.enlargedIndent(this.intLine.formatted(JasmTokens.Token.OFFSETDELTA.parseKey(), this.offset), this.doubleIndent));
                }
                if (this.stackEntryType != StackMap.EntryType.EARLY_LARVAL) break block21;
                if (this.unsetFields == null) break block22;
                int limit = this.unsetFields.length - 1;
                String delim = limit >= 0 ? "; " : "";
                String prefix = "%-12s".formatted(JasmTokens.Token.UNSETFIELDS.parseKey());
                Pair<List<String>, List<String>> line = this.getFieldListAsString(this.unsetFields);
                String left = ((List)line.first).stream().collect(Collectors.joining(", ")).concat(delim);
                String right = ((List)line.second).stream().collect(Collectors.joining(", ")).concat(delim);
                String record = this.strLine.formatted(prefix, "[ " + (this.printCPIndex ? left : right) + "] {");
                if (this.printCPIndex) {
                    if (this.skipComments) {
                        this.println(this.enlargedIndent(record, this.doubleIndent));
                    } else if (limit <= 0) {
                        this.print(this.PadRight(this.enlargedIndent(record, this.doubleIndent), padding));
                        this.println((String)(this.unsetFields.length == 0 ? "" : " // " + right));
                    } else {
                        String str = this.PadRight(this.enlargedIndent(this.strLine.formatted(prefix, "[ " + ((String)((List)line.first).get(0)).concat(",")), this.doubleIndent), padding);
                        int offs = str.indexOf(91) - 2 * (this.wrapLevel + 1);
                        this.print(str).println(" // " + (String)((List)line.second).get(0));
                        for (int i = 1; i <= limit; ++i) {
                            delim = i == limit ? "; ]  {" : ",";
                            String id = (String)((List)line.first).get(i);
                            String field = (String)((List)line.second).get(i);
                            this.print(this.PadRight(this.enlargedIndent(id.concat(delim), offs), padding)).println(" // " + field);
                        }
                    }
                } else if (limit <= 0) {
                    this.println(this.enlargedIndent(record, this.doubleIndent));
                } else {
                    this.println(this.enlargedIndent(this.strLine.formatted(prefix, "[ " + ((String)((List)line.second).get(0)).concat(",")), this.doubleIndent));
                    for (int i = 1; i <= limit; ++i) {
                        delim = i == limit ? "; ] {" : ",";
                        String field = (String)((List)line.second).get(i);
                        this.println(this.enlargedIndent(" %s%s".formatted(field, delim), padding - 2));
                    }
                }
                break block22;
            }
            for (Map.Entry<String, Pair<Boolean, int[]>> entry : Map.of(JasmTokens.Token.STACKMAP.parseKey(), new Pair<Boolean, int[]>(this.stackMap != null, this.stackMap), JasmTokens.Token.LOCALSMAP.parseKey(), new Pair<Boolean, int[]>(this.lockMap != null, this.lockMap)).entrySet()) {
                if (!((Boolean)entry.getValue().first).booleanValue()) continue;
                int[] map = (int[])entry.getValue().second;
                Pair<String, String> line = this.getMapListAsString(map, " ");
                String record = "[" + (this.printCPIndex ? (String)line.first : (String)line.second) + "]";
                if (this.printCPIndex) {
                    if (this.skipComments) {
                        this.println(this.enlargedIndent(this.strLine.formatted(entry.getKey(), record), this.doubleIndent));
                        continue;
                    }
                    this.print(this.PadRight(this.enlargedIndent(this.strLine.formatted(entry.getKey(), record), this.doubleIndent), padding)).println(" //" + (String)line.second);
                    continue;
                }
                this.println(this.enlargedIndent(this.strLine.formatted(entry.getKey(), record), this.doubleIndent));
            }
            if (this.isWrapped) {
                for (int i = 0; i < this.wrapLevel; ++i) {
                    this.println(this.enlargedIndent(" }", this.printCPIndex ? this.tripleIndent : this.doubleIndent));
                    this.decIndent();
                }
            }
        }
    }

    @Override
    protected void tablePrint(int index, int size) throws IOException {
        this.jasmPrint(index, size);
    }

    @Override
    public boolean isPrintable() {
        return this.tableFormat;
    }

    public StackMapData(CodeData code, DataInputStream in) throws IOException {
        super(code);
        this.attribute = EAttribute.ATT_StackMap;
        this.memberType = EAttribute.ATT_StackMap.parseKey();
        this.tableToken = TableFormatModel.Token.STACK_MAP;
        this.printer = this::stackMapPrinter;
        this.stackEntryType = StackMap.EntryType.FULL_FRAME;
        this.stackEntryTypeValue = StackMap.EntryType.FULL_FRAME.fromTag();
        this.frame_pc = in.readUnsignedShort();
        this.lockMap = this.readMap(in);
        this.stackMap = this.readMap(in);
        this.environment.traceln(() -> " stack_map_entry:pc=%d numloc=%s  numstack=%s".formatted(this.frame_pc, StringUtils.mapToHexString(this.lockMap), StringUtils.mapToHexString(this.stackMap)));
    }

    public StackMapData(boolean firstStackMap, int prevFrame_pc, CodeData code, DataInputStream in) throws IOException {
        super(code);
        this.attribute = EAttribute.ATT_StackMapTable;
        this.memberType = EAttribute.ATT_StackMapTable.parseKey();
        this.tableToken = TableFormatModel.Token.STACK_MAP_TABLE;
        this.stackEntryTypeValue = in.readUnsignedByte();
        this.stackEntryType = StackMap.stackMapEntryType(this.stackEntryTypeValue);
        this.printer = this::stackMapTablePrinter;
        switch (this.stackEntryType) {
            case EARLY_LARVAL: {
                this.offset = -1;
                this.unsetFields = this.readFields(in);
                this.environment.traceln(() -> " early_larval_frame=%d".formatted(this.stackEntryTypeValue));
                break;
            }
            case SAME_FRAME: {
                this.offset = this.stackEntryTypeValue;
                this.environment.traceln(() -> " same_frame=%d".formatted(this.stackEntryTypeValue));
                break;
            }
            case SAME_FRAME_EXTENDED: {
                this.offset = in.readUnsignedShort();
                this.environment.traceln(() -> " same_frame_extended=%d, offset=%d".formatted(this.stackEntryTypeValue, this.offset));
                break;
            }
            case SAME_LOCALS_1_STACK_ITEM_FRAME: {
                this.offset = this.stackEntryTypeValue - 64;
                this.stackMap = this.readMapElements(in, 1);
                this.environment.traceln(() -> " same_locals_1_stack_item_frame=%d, offset=%d, numstack=%s".formatted(this.stackEntryTypeValue, this.offset, StringUtils.mapToHexString(this.stackMap)));
                break;
            }
            case SAME_LOCALS_1_STACK_ITEM_FRAME_EXTENDED: {
                this.offset = in.readUnsignedShort();
                this.stackMap = this.readMapElements(in, 1);
                this.environment.traceln(() -> " same_locals_1_stack_item_frame_extended=%d, offset=%d, numstack=%s".formatted(this.stackEntryTypeValue, this.offset, StringUtils.mapToHexString(this.stackMap)));
                break;
            }
            case CHOP_1_FRAME: 
            case CHOP_2_FRAME: 
            case CHOP_3_FRAME: {
                this.offset = in.readUnsignedShort();
                this.environment.traceln(() -> " chop_frame=%d offset=%d".formatted(this.stackEntryTypeValue, this.offset));
                break;
            }
            case APPEND_FRAME: {
                this.offset = in.readUnsignedShort();
                this.lockMap = this.readMapElements(in, this.stackEntryTypeValue - 251);
                this.environment.traceln(() -> " append_frame=%d offset=%d numlock=%s".formatted(this.stackEntryTypeValue, this.offset, StringUtils.mapToHexString(this.lockMap)));
                break;
            }
            case FULL_FRAME: {
                this.offset = in.readUnsignedShort();
                this.lockMap = this.readMap(in);
                this.stackMap = this.readMap(in);
                this.environment.traceln(() -> " full_frame=%d offset=%d numloc=%s  numstack=%s".formatted(this.stackEntryTypeValue, this.offset, StringUtils.mapToHexString(this.lockMap), StringUtils.mapToHexString(this.stackMap)));
                break;
            }
            default: {
                this.environment.traceln(() -> "incorrect entry_type argument");
            }
        }
        this.frame_pc = prevFrame_pc <= 0 && firstStackMap ? this.offset : prevFrame_pc + this.offset + 1;
    }

    public int getFramePC() {
        return this.frame_pc;
    }

    public StackMap.EntryType getStackEntryType() {
        return this.stackEntryType;
    }

    public Pair<List<String>, List<String>> getFieldListAsString(int[] fields) {
        int count = fields.length;
        ArrayList<String> left = new ArrayList<String>(count);
        ArrayList<String> right = new ArrayList<String>(count);
        for (int index : fields) {
            if (((CodeData)this.data).printCPIndex) {
                left.add("#%d".formatted(index));
            }
            right.add(((CodeData)this.data).pool.getFieldNameTypeAsString(index));
        }
        return new Pair<List<String>, List<String>>(left, right);
    }

    public Pair<String, String> getMapListAsString(int[] map, String delimiter) {
        if (map == null || map.length == 0) {
            return new Pair<String, String>("", "");
        }
        StringBuilder left = new StringBuilder();
        StringBuilder right = new StringBuilder();
        int count = map.length - 1;
        for (int k = 0; k <= count; ++k) {
            if (k == 0) {
                left.append(delimiter);
                right.append(delimiter);
            }
            int fullMapType = map[k];
            int mtVal = fullMapType & 0xFF;
            StackMap.VerificationType mapVerificationType = StackMap.getVerificationType(mtVal, Optional.of((s, a) -> this.environment.error((String)s, a)));
            String prefix = k == 0 ? "" : " ";
            int argument = fullMapType >> 8;
            switch (mapVerificationType) {
                case ITEM_Object: {
                    if (((CodeData)this.data).printCPIndex) {
                        left.append(prefix).append("#").append(argument);
                    }
                    right.append(prefix).append(((CodeData)this.data).pool.ConstantStrValue(argument));
                    break;
                }
                case ITEM_NewObject: {
                    if (((CodeData)this.data).printCPIndex) {
                        left.append(prefix).append(mtVal);
                        left.append(" ").append(this.getLabelPrefix()).append(argument);
                    }
                    right.append(prefix).append(mapVerificationType.printName());
                    right.append(" ").append(this.getLabelPrefix()).append(argument);
                    break;
                }
                default: {
                    if (((CodeData)this.data).printCPIndex) {
                        left.append(prefix).append(mtVal);
                    }
                    right.append(prefix).append(mapVerificationType.printName());
                }
            }
            if (((CodeData)this.data).printCPIndex) {
                left.append(k == count ? (char)';' : ',');
            }
            right.append(k == count ? (char)';' : ',');
            if (k != count) continue;
            left.append(delimiter);
            right.append(delimiter);
        }
        return new Pair<String, String>(left.toString(), right.toString());
    }

    public boolean belongsToStackMapTable() {
        return this.attribute == EAttribute.ATT_StackMapTable;
    }

    public StackMapData setPrintParticles(String intLine, String strLine, int shift) {
        this.intLine = intLine;
        this.strLine = strLine;
        this.shift = shift;
        return this;
    }

    public StackMapData setHeader(String header) {
        this.tableHeader = header;
        return this;
    }

    private int[] readMap(DataInputStream in) throws IOException {
        int num = in.readUnsignedShort();
        return this.readMapElements(in, num);
    }

    private int[] readFields(DataInputStream in) throws IOException {
        int num = in.readUnsignedShort();
        int[] fields = new int[num];
        for (int i = 0; i < num; ++i) {
            fields[i] = in.readUnsignedShort();
        }
        return fields;
    }

    private int[] readMapElements(DataInputStream in, int num) throws IOException {
        int[] map = new int[num];
        for (int k = 0; k < num; ++k) {
            int mt_val = in.readUnsignedByte();
            StackMap.VerificationType stackMapVerificationType = StackMap.getVerificationType(mt_val, Optional.of((s, a) -> this.environment.error((String)s, a)));
            switch (stackMapVerificationType) {
                case ITEM_Object: {
                    mt_val |= in.readUnsignedShort() << 8;
                    break;
                }
                case ITEM_NewObject: {
                    int pc = in.readUnsignedShort();
                    ((CodeData)this.data).getInstructionAttribute((int)pc).referred = true;
                    mt_val |= pc << 8;
                }
            }
            map[k] = mt_val;
        }
        return map;
    }

    private int getCommentOffsetFor(String line, int shiftCount) {
        return this.owner.getPrintAttributeCommentPadding() + this.shift + line.length() - shiftCount * this.getIndentStep() - 2;
    }

    private int getCommentOffsetFor(int lineLength, int shiftCount) {
        return this.owner.getPrintAttributeCommentPadding() + this.shift + lineLength - shiftCount * this.getIndentStep() - 2;
    }

    @FunctionalInterface
    public static interface Printer {
        public void accept(Integer var1, Integer var2) throws IOException;
    }
}

