/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdis;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;

public class TextLines {
    final Path file;
    List<String> lines;

    public TextLines(Path directory, String sourceFileName) {
        this.file = directory == null ? Paths.get(sourceFileName, new String[0]) : directory.resolve(sourceFileName);
        try {
            this.lines = Files.readAllLines(this.file, StandardCharsets.UTF_8);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getLine(int index) {
        if (this.lines != null) {
            if (index < 1 || index >= this.lines.size()) {
                return String.format("Line number %d is out of range in \"%s\"", index, this.file);
            }
            return this.lines.get(index - 1);
        }
        return String.format("\"%s\" not found", this.file);
    }
}

