/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdis;

import org.openjdk.asmtools.jasm.JasmTokens;
import org.openjdk.asmtools.jdis.ClassArrayData;
import org.openjdk.asmtools.jdis.ClassData;
import org.openjdk.asmtools.jdis.MemberData;

public class Utf8ArrayData
extends ClassArrayData {
    protected <M extends MemberData<ClassData>> Utf8ArrayData(M classData, JasmTokens.Token token) {
        super(classData, token);
    }

    @Override
    public void jasmPrintShort() {
        StringBuilder indexes = new StringBuilder();
        StringBuilder names = new StringBuilder();
        int lastIndex = this.indexes.length - 1;
        String eoNames = this.printCPIndex ? "" : ";";
        for (int i = 0; i <= lastIndex; ++i) {
            if (this.printCPIndex) {
                indexes.append("#").append(this.indexes[i]).append(i == lastIndex ? ";" : ", ");
            }
            names.append(this.pool.StringValue(this.indexes[i])).append(i == lastIndex ? eoNames : ", ");
        }
        this.printIndent(this.PadRight(this.token.parseKey(), this.getPrintAttributeKeyPadding()));
        if (this.printCPIndex) {
            if (this.skipComments) {
                this.println(indexes.toString());
            } else {
                this.print(this.PadRight(indexes.toString(), this.getPrintAttributeCommentPadding())).println(" // " + names);
            }
        } else {
            this.println(names.toString());
        }
    }

    @Override
    public void jasmPrintLong() {
        String name = this.token.parseKey();
        String locIndent = " ".repeat(name.length());
        int lastIndex = this.indexes.length - 1;
        for (int i = 0; i <= lastIndex; ++i) {
            if (this.printCPIndex) {
                if (this.skipComments) {
                    this.printIndent(this.PadRight(i == 0 ? name : locIndent, this.getPrintAttributeKeyPadding())).print("#%d".formatted(this.indexes[i])).println(i == lastIndex ? ";" : ",");
                    continue;
                }
                this.printIndent(this.PadRight(i == 0 ? name : locIndent, this.getPrintAttributeKeyPadding())).print(this.PadRight("#%d%s".formatted(this.indexes[i], i == lastIndex ? ";" : ","), this.getPrintAttributeCommentPadding())).println(" // %s".formatted(this.pool.StringValue(this.indexes[i])));
                continue;
            }
            this.printIndent(this.PadRight(i == 0 ? name : locIndent, this.getPrintAttributeKeyPadding())).print(this.pool.StringValue(this.indexes[i])).println(i == lastIndex ? ";" : ",");
        }
    }
}

