/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdis.notations;

import org.openjdk.asmtools.common.FormatError;
import org.openjdk.asmtools.common.ToolLogger;
import org.openjdk.asmtools.jdis.ConstantPool;

public class Descriptor<T extends ToolLogger> {
    private static final int UNDEF = -1;
    public final int index;
    public final String descriptor;
    public final T logger;
    private int count;

    public Descriptor(T logger, int index) {
        this.index = index;
        this.descriptor = null;
        this.logger = logger;
    }

    public Descriptor(T logger, String descriptor) {
        this.index = -1;
        this.descriptor = descriptor;
        this.logger = logger;
    }

    public String getValue(ConstantPool pool) {
        return pool == null ? this.descriptor : pool.getString(this.index, i -> "#" + this.index);
    }

    public int getParameterCount(ConstantPool constant_pool) throws InvalidDescriptor {
        String desc = this.getValue(constant_pool);
        int end = desc.indexOf(")");
        if (end == -1) {
            throw new InvalidDescriptor(this.logger, desc);
        }
        this.parse(desc, 0, end + 1);
        return this.count;
    }

    public String getParameterTypes(ConstantPool constant_pool) throws InvalidDescriptor {
        String desc = this.getValue(constant_pool);
        int end = desc.indexOf(")");
        if (end == -1) {
            throw new InvalidDescriptor(this.logger, desc);
        }
        return this.parse(desc, 0, end + 1);
    }

    public String getReturnType(ConstantPool constant_pool) throws InvalidDescriptor {
        String desc = this.getValue(constant_pool);
        int end = desc.indexOf(")");
        if (end == -1) {
            throw new InvalidDescriptor(this.logger, desc);
        }
        return this.parse(desc, end + 1, desc.length());
    }

    public String getFieldType(ConstantPool constant_pool) throws InvalidDescriptor {
        String desc = this.getValue(constant_pool);
        return this.parse(desc, 0, desc.length());
    }

    private String parse(String desc, int start, int end) throws InvalidDescriptor {
        int p = start;
        StringBuilder sb = new StringBuilder();
        int dims = 0;
        this.count = 0;
        block15: while (p < end) {
            String type;
            char ch = desc.charAt(p++);
            switch (ch) {
                case '(': {
                    sb.append('(');
                    continue block15;
                }
                case ')': {
                    sb.append(')');
                    continue block15;
                }
                case '[': {
                    ++dims;
                    continue block15;
                }
                case 'B': {
                    type = "byte";
                    break;
                }
                case 'C': {
                    type = "char";
                    break;
                }
                case 'D': {
                    type = "double";
                    break;
                }
                case 'F': {
                    type = "float";
                    break;
                }
                case 'I': {
                    type = "int";
                    break;
                }
                case 'J': {
                    type = "long";
                    break;
                }
                case 'L': {
                    int sep = desc.indexOf(59, p);
                    if (sep == -1) {
                        throw new InvalidDescriptor(this.logger, desc, p - 1);
                    }
                    type = desc.substring(p, sep).replace('/', '.');
                    p = sep + 1;
                    break;
                }
                case 'S': {
                    type = "short";
                    break;
                }
                case 'Z': {
                    type = "boolean";
                    break;
                }
                case 'V': {
                    type = "void";
                    break;
                }
                default: {
                    throw new InvalidDescriptor(this.logger, desc, p - 1);
                }
            }
            if (sb.length() > 1 && sb.charAt(0) == '(') {
                sb.append(", ");
            }
            sb.append(type);
            while (dims > 0) {
                sb.append("[]");
                --dims;
            }
            ++this.count;
        }
        return sb.toString();
    }

    public static class InvalidDescriptor
    extends FormatError {
        <T extends ToolLogger> InvalidDescriptor(T logger, String desc) {
            super(logger, "err.invalid.desc", desc);
        }

        <T extends ToolLogger> InvalidDescriptor(T logger, String desc, int index) {
            super(logger, "err.invalid.desc.at", index, desc);
        }
    }
}

