/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.discovery;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.engine.config.JupiterConfiguration;
import org.junit.jupiter.engine.descriptor.Filterable;
import org.junit.jupiter.engine.descriptor.TestClassAware;
import org.junit.jupiter.engine.descriptor.TestFactoryTestDescriptor;
import org.junit.jupiter.engine.descriptor.TestMethodTestDescriptor;
import org.junit.jupiter.engine.descriptor.TestTemplateTestDescriptor;
import org.junit.jupiter.engine.discovery.DeclaredMethodSelector;
import org.junit.jupiter.engine.discovery.MethodSegmentResolver;
import org.junit.jupiter.engine.discovery.predicates.IsTestFactoryMethod;
import org.junit.jupiter.engine.discovery.predicates.IsTestMethod;
import org.junit.jupiter.engine.discovery.predicates.IsTestTemplateMethod;
import org.junit.jupiter.engine.discovery.predicates.TestClassPredicates;
import org.junit.platform.engine.DiscoveryIssue;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.engine.discovery.IterationSelector;
import org.junit.platform.engine.discovery.MethodSelector;
import org.junit.platform.engine.discovery.NestedMethodSelector;
import org.junit.platform.engine.discovery.UniqueIdSelector;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.engine.support.discovery.DiscoveryIssueReporter;
import org.junit.platform.engine.support.discovery.SelectorResolver;

class MethodSelectorResolver
implements SelectorResolver {
    private static final MethodSegmentResolver methodSegmentResolver = new MethodSegmentResolver();
    private final Predicate<Class<?>> testClassPredicate;
    private final JupiterConfiguration configuration;
    private final DiscoveryIssueReporter issueReporter;
    private final List<MethodType> methodTypes;

    MethodSelectorResolver(JupiterConfiguration configuration, DiscoveryIssueReporter issueReporter) {
        this.configuration = configuration;
        this.issueReporter = issueReporter;
        this.methodTypes = MethodType.allPossibilities(issueReporter);
        this.testClassPredicate = new TestClassPredicates((DiscoveryIssueReporter)issueReporter).looksLikeNestedOrStandaloneTestClass;
    }

    @Override
    public SelectorResolver.Resolution resolve(MethodSelector selector, SelectorResolver.Context context) {
        return this.resolve(context, Collections.emptyList(), selector.getJavaClass(), selector::getJavaMethod, SelectorResolver.Match::exact);
    }

    @Override
    public SelectorResolver.Resolution resolve(NestedMethodSelector selector, SelectorResolver.Context context) {
        return this.resolve(context, selector.getEnclosingClasses(), selector.getNestedClass(), selector::getMethod, SelectorResolver.Match::exact);
    }

    @Override
    public SelectorResolver.Resolution resolve(DiscoverySelector selector, SelectorResolver.Context context) {
        if (selector instanceof DeclaredMethodSelector) {
            DeclaredMethodSelector methodSelector = (DeclaredMethodSelector)selector;
            List<Class<?>> testClasses = methodSelector.testClasses();
            if (testClasses.size() == 1) {
                return this.resolve(context, Collections.emptyList(), testClasses.get(0), methodSelector::method, SelectorResolver.Match::exact);
            }
            int lastIndex = testClasses.size() - 1;
            return this.resolve(context, testClasses.subList(0, lastIndex), testClasses.get(lastIndex), methodSelector::method, SelectorResolver.Match::exact);
        }
        return SelectorResolver.Resolution.unresolved();
    }

    private SelectorResolver.Resolution resolve(SelectorResolver.Context context, List<Class<?>> enclosingClasses, Class<?> testClass, Supplier<Method> methodSupplier, BiFunction<TestDescriptor, Supplier<Set<? extends DiscoverySelector>>, SelectorResolver.Match> matchFactory) {
        if (!this.testClassPredicate.test(testClass)) {
            return SelectorResolver.Resolution.unresolved();
        }
        Method method = methodSupplier.get();
        Set<SelectorResolver.Match> matches = this.methodTypes.stream().map(methodType -> methodType.resolve(enclosingClasses, testClass, method, context, this.configuration)).filter(Optional::isPresent).map(Optional::get).map(testDescriptor -> (SelectorResolver.Match)matchFactory.apply((TestDescriptor)testDescriptor, this.expansionCallback((TestDescriptor)testDescriptor))).collect(Collectors.toSet());
        if (matches.size() > 1) {
            Stream<TestDescriptor> testDescriptors = matches.stream().map(SelectorResolver.Match::getTestDescriptor);
            String message = String.format("Possible configuration error: method [%s] resulted in multiple TestDescriptors %s. This is typically the result of annotating a method with multiple competing annotations such as @Test, @RepeatedTest, @ParameterizedTest, @TestFactory, etc.", method.toGenericString(), testDescriptors.map(d -> d.getClass().getName()).collect(Collectors.toList()));
            this.issueReporter.reportIssue(DiscoveryIssue.builder(DiscoveryIssue.Severity.WARNING, message).source(MethodSource.from(method)));
        }
        return matches.isEmpty() ? SelectorResolver.Resolution.unresolved() : SelectorResolver.Resolution.matches(matches);
    }

    @Override
    public SelectorResolver.Resolution resolve(UniqueIdSelector selector, SelectorResolver.Context context) {
        UniqueId uniqueId = selector.getUniqueId();
        return this.methodTypes.stream().map(methodType -> methodType.resolveUniqueIdIntoTestDescriptor(uniqueId, context, this.configuration)).filter(Optional::isPresent).map(Optional::get).map(testDescriptor -> {
            boolean exactMatch = uniqueId.equals(testDescriptor.getUniqueId());
            if (testDescriptor instanceof Filterable) {
                Filterable filterable = (Filterable)((Object)testDescriptor);
                if (exactMatch) {
                    filterable.getDynamicDescendantFilter().allowAll();
                } else {
                    filterable.getDynamicDescendantFilter().allowUniqueIdPrefix(uniqueId);
                }
            }
            return SelectorResolver.Resolution.match(exactMatch ? SelectorResolver.Match.exact(testDescriptor) : SelectorResolver.Match.partial(testDescriptor, this.expansionCallback((TestDescriptor)testDescriptor)));
        }).findFirst().orElse(SelectorResolver.Resolution.unresolved());
    }

    @Override
    public SelectorResolver.Resolution resolve(IterationSelector selector, SelectorResolver.Context context) {
        if (selector.getParentSelector() instanceof MethodSelector) {
            MethodSelector methodSelector = (MethodSelector)selector.getParentSelector();
            return this.resolve(context, Collections.emptyList(), methodSelector.getJavaClass(), methodSelector::getJavaMethod, (testDescriptor, childSelectorsSupplier) -> {
                if (testDescriptor instanceof Filterable) {
                    Filterable filterable = (Filterable)((Object)testDescriptor);
                    filterable.getDynamicDescendantFilter().allowIndex(selector.getIterationIndices());
                }
                return SelectorResolver.Match.partial(testDescriptor, childSelectorsSupplier);
            });
        }
        return SelectorResolver.Resolution.unresolved();
    }

    private Supplier<Set<? extends DiscoverySelector>> expansionCallback(TestDescriptor testDescriptor) {
        return () -> {
            if (testDescriptor instanceof Filterable) {
                Filterable filterable = (Filterable)((Object)testDescriptor);
                filterable.getDynamicDescendantFilter().allowAll();
            }
            return Collections.emptySet();
        };
    }

    private static class MethodType {
        private final Predicate<Method> methodPredicate;
        private final TestDescriptorFactory testDescriptorFactory;
        private final String segmentType;
        private final Set<String> dynamicDescendantSegmentTypes;

        static List<MethodType> allPossibilities(DiscoveryIssueReporter issueReporter) {
            return Arrays.asList(new MethodType(new IsTestMethod(issueReporter), TestMethodTestDescriptor::new, "method", new String[0]), new MethodType(new IsTestFactoryMethod(issueReporter), TestFactoryTestDescriptor::new, "test-factory", "dynamic-container", "dynamic-test"), new MethodType(new IsTestTemplateMethod(issueReporter), TestTemplateTestDescriptor::new, "test-template", "test-template-invocation"));
        }

        private MethodType(Predicate<Method> methodPredicate, TestDescriptorFactory testDescriptorFactory, String segmentType, String ... dynamicDescendantSegmentTypes) {
            this.methodPredicate = methodPredicate;
            this.testDescriptorFactory = testDescriptorFactory;
            this.segmentType = segmentType;
            this.dynamicDescendantSegmentTypes = new LinkedHashSet<String>(Arrays.asList(dynamicDescendantSegmentTypes));
        }

        Optional<TestDescriptor> resolve(List<Class<?>> enclosingClasses, Class<?> testClass, Method method, SelectorResolver.Context context, JupiterConfiguration configuration) {
            if (!this.methodPredicate.test(method)) {
                return Optional.empty();
            }
            return context.addToParent(() -> this.selectClass(enclosingClasses, testClass), parent -> Optional.of(this.createTestDescriptor((TestDescriptor)parent, testClass, method, configuration)));
        }

        private DiscoverySelector selectClass(List<Class<?>> enclosingClasses, Class<?> testClass) {
            if (enclosingClasses.isEmpty()) {
                return DiscoverySelectors.selectClass(testClass);
            }
            return DiscoverySelectors.selectNestedClass(enclosingClasses, testClass);
        }

        Optional<TestDescriptor> resolveUniqueIdIntoTestDescriptor(UniqueId uniqueId, SelectorResolver.Context context, JupiterConfiguration configuration) {
            UniqueId.Segment lastSegment = uniqueId.getLastSegment();
            if (this.segmentType.equals(lastSegment.getType())) {
                return context.addToParent(() -> DiscoverySelectors.selectUniqueId(uniqueId.removeLastSegment()), parent -> {
                    String methodSpecPart = lastSegment.getValue();
                    Class<?> testClass = ((TestClassAware)((Object)parent)).getTestClass();
                    return methodSegmentResolver.findMethod(methodSpecPart, testClass).filter(this.methodPredicate).map(method -> this.createTestDescriptor((TestDescriptor)parent, testClass, (Method)method, configuration));
                });
            }
            if (this.dynamicDescendantSegmentTypes.contains(lastSegment.getType())) {
                return this.resolveUniqueIdIntoTestDescriptor(uniqueId.removeLastSegment(), context, configuration);
            }
            return Optional.empty();
        }

        private TestDescriptor createTestDescriptor(TestDescriptor parent, Class<?> testClass, Method method, JupiterConfiguration configuration) {
            UniqueId uniqueId = this.createUniqueId(method, parent, testClass);
            return this.testDescriptorFactory.create(uniqueId, testClass, method, ((TestClassAware)((Object)parent))::getEnclosingTestClasses, configuration);
        }

        private UniqueId createUniqueId(Method method, TestDescriptor parent, Class<?> testClass) {
            return parent.getUniqueId().append(this.segmentType, methodSegmentResolver.formatMethodSpecPart(method, testClass));
        }

        static interface TestDescriptorFactory {
            public TestDescriptor create(UniqueId var1, Class<?> var2, Method var3, Supplier<List<Class<?>>> var4, JupiterConfiguration var5);
        }
    }
}

