/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest;

import com.sun.javatest.Status;

public class RStatus {
    private RStatus() {
    }

    public static Status passed(String msg) {
        return Status.passed(RStatus.normalize(msg));
    }

    public static Status failed(String msg) {
        return Status.failed(RStatus.normalize(msg));
    }

    public static Status error(String msg) {
        return Status.error(RStatus.normalize(msg));
    }

    public static Status createStatus(int code, String msg) {
        return new Status(code, RStatus.normalize(msg));
    }

    public static Status normalize(Status s) {
        return new Status(s.getType(), RStatus.normalize(s.getReason()));
    }

    private static String normalize(String msg) {
        boolean ok = true;
        boolean prevIsWhite = false;
        for (int i = 0; ok && i < msg.length(); ++i) {
            char ch = msg.charAt(i);
            if (Character.isWhitespace(ch)) {
                if (prevIsWhite || ch != ' ' || i == 0) {
                    ok = false;
                    break;
                }
                prevIsWhite = true;
                continue;
            }
            prevIsWhite = false;
        }
        if (prevIsWhite) {
            ok = false;
        }
        if (ok) {
            return msg;
        }
        StringBuilder sb = new StringBuilder();
        boolean needWhite = false;
        for (int i = 0; i < msg.length(); ++i) {
            char ch = msg.charAt(i);
            if (Character.isWhitespace(ch)) {
                if (sb.length() <= 0) continue;
                needWhite = true;
                continue;
            }
            if (needWhite) {
                sb.append(' ');
            }
            sb.append(ch);
            needWhite = false;
        }
        return sb.toString();
    }
}

