/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.agent;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;

public class GetJDKProperties {
    public static final String JTREG_MODULES = "jtreg.modules";

    public static void main(String ... args) {
        try {
            GetJDKProperties.run(args);
        }
        catch (ClientCodeException e) {
            System.err.println(e.getMessage());
            e.getCause().printStackTrace(System.err);
            System.exit(1);
        }
        catch (Exception e) {
            System.err.println("Internal error: please report to jtreg-dev@openjdk.org");
            e.printStackTrace(System.err);
            System.exit(1);
        }
    }

    public static void run(String ... args) throws ClientCodeException, IOException {
        boolean needSystemProperties = false;
        String needModulesArg = null;
        Path outputFile = null;
        Properties p = new Properties();
        for (String arg : args) {
            if (arg.equals("--system-properties")) {
                needSystemProperties = true;
                continue;
            }
            if (arg.startsWith("--modules=")) {
                needModulesArg = arg.substring(arg.indexOf("=") + 1);
                continue;
            }
            if (arg.startsWith("--output-file=")) {
                String val = arg.substring(arg.indexOf("=") + 1);
                try {
                    outputFile = Paths.get(val, new String[0]);
                    continue;
                }
                catch (InvalidPathException ipe) {
                    throw new IOException("invalid output file path: " + val, ipe);
                }
            }
            if (outputFile == null) {
                throw new ClientCodeException("--output-file not specified");
            }
            try {
                Class<?> c = Class.forName(arg);
                Callable o = (Callable)c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                p.putAll((Map<?, ?>)((Map)o.call()));
            }
            catch (Throwable t) {
                throw new ClientCodeException("Exception while calling user-specified class: " + arg, t);
            }
        }
        if (needModulesArg != null && GetJDKProperties.getJDKVersion() >= 9) {
            String modules = null;
            if (needModulesArg.equals("boot-layer")) {
                modules = GetJDKProperties.getModulesFromBootLayer();
            } else if (needModulesArg.equals("all-system")) {
                modules = GetJDKProperties.getAllSystemModules();
            }
            if (modules != null) {
                p.put(JTREG_MODULES, modules);
            }
        }
        if (needSystemProperties) {
            p.putAll((Map<?, ?>)System.getProperties());
        }
        assert (outputFile != null) : "outputFile is null";
        try (OutputStream os = Files.newOutputStream(outputFile, new OpenOption[0]);
             BufferedOutputStream bos = new BufferedOutputStream(os);){
            p.store(bos, "jdk properties");
        }
    }

    private static int getJDKVersion() {
        String specVersion = System.getProperty("java.specification.version");
        if (specVersion == null) {
            return -1;
        }
        if (specVersion.startsWith("1.")) {
            specVersion = specVersion.substring(2);
        }
        if (specVersion.contains(".")) {
            specVersion = specVersion.substring(0, specVersion.indexOf("."));
        }
        try {
            return Integer.parseInt(specVersion);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private static String getModulesFromBootLayer() {
        try {
            Class<?> moduleClass;
            Class<?> layerClass;
            try {
                layerClass = Class.forName("java.lang.ModuleLayer");
            }
            catch (ClassNotFoundException e) {
                layerClass = Class.forName("java.lang.reflect.Layer");
            }
            Method bootMethod = layerClass.getDeclaredMethod("boot", new Class[0]);
            Method modulesMethod = layerClass.getDeclaredMethod("modules", new Class[0]);
            try {
                moduleClass = Class.forName("java.lang.Module");
            }
            catch (ClassNotFoundException e) {
                moduleClass = Class.forName("java.lang.reflect.Module");
            }
            Method getNameMethod = moduleClass.getDeclaredMethod("getName", new Class[0]);
            StringBuilder sb = new StringBuilder();
            Object bootLayer = bootMethod.invoke(null, new Object[0]);
            for (Object module : (Set)modulesMethod.invoke(bootLayer, new Object[0])) {
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append(getNameMethod.invoke(module, new Object[0]));
            }
            return sb.toString();
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
            return null;
        }
    }

    private static String getAllSystemModules() {
        try {
            Class<?> moduleFinderClass = Class.forName("java.lang.module.ModuleFinder");
            Method ofSystemMethod = moduleFinderClass.getDeclaredMethod("ofSystem", new Class[0]);
            Method findAllMethod = moduleFinderClass.getDeclaredMethod("findAll", new Class[0]);
            Class<?> moduleReferenceClass = Class.forName("java.lang.module.ModuleReference");
            Method descriptorMethod = moduleReferenceClass.getDeclaredMethod("descriptor", new Class[0]);
            Class<?> moduleDescriptorClass = Class.forName("java.lang.module.ModuleDescriptor");
            Method nameMethod = moduleDescriptorClass.getDeclaredMethod("name", new Class[0]);
            StringBuilder sb = new StringBuilder();
            Object systemModuleFinder = ofSystemMethod.invoke(null, new Object[0]);
            for (Object mr : (Set)findAllMethod.invoke(systemModuleFinder, new Object[0])) {
                Object md = descriptorMethod.invoke(mr, new Object[0]);
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append(nameMethod.invoke(md, new Object[0]));
            }
            return sb.toString();
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
            return null;
        }
    }

    public static class ClientCodeException
    extends Exception {
        private static final long serialVersionUID = 0L;

        ClientCodeException(String msg) {
            super(msg);
        }

        ClientCodeException(String msg, Throwable t) {
            super(msg, t);
        }
    }
}

