/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.agent;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class ModuleHelper {
    private static Method findModuleMethod;
    private static Method configurationMethod;
    private static Method defineModulesWithOneLoaderMethod;
    private static Method findLoaderMethod;
    private static Object bootLayer;
    private static Method moduleFinderOfMethod;
    private static Method resolveMethod;
    private static Method getUnnamedModuleMethod;
    private static Method addExportsMethod;
    private static Method addOpensMethod;

    static void addExports(Set<String> exports, ClassLoader loader) throws Fault {
        for (String e : exports) {
            ModuleHelper.addExportsOrOpens(e, false, loader);
        }
    }

    static void addOpens(Set<String> opens, ClassLoader loader) throws Fault {
        for (String o : opens) {
            ModuleHelper.addExportsOrOpens(o, true, loader);
        }
    }

    static ClassLoader addModules(List<Path> libs, Set<String> modules) throws Fault {
        ModuleHelper.init();
        try {
            Object finder = moduleFinderOfMethod.invoke(null, new Object[]{libs.toArray(new Path[0])});
            Object emptyFinder = moduleFinderOfMethod.invoke(null, new Object[]{new Path[0]});
            Object bootConfig = configurationMethod.invoke(bootLayer, new Object[0]);
            Object config = resolveMethod.invoke(bootConfig, finder, emptyFinder, modules);
            Object layer = defineModulesWithOneLoaderMethod.invoke(bootLayer, config, ClassLoader.getSystemClassLoader());
            return (ClassLoader)findLoaderMethod.invoke(layer, modules.iterator().next());
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            throw new Fault("unexpected exception: " + e, e);
        }
    }

    private static void addExportsOrOpens(String modulePackageName, boolean isOpen, ClassLoader targetLoader) throws Fault {
        int sep = modulePackageName.indexOf("/");
        String moduleName = modulePackageName.substring(0, sep);
        String packageName = modulePackageName.substring(sep + 1);
        try {
            ModuleHelper.init();
            Optional opt_module = (Optional)findModuleMethod.invoke(bootLayer, moduleName);
            if (!opt_module.isPresent()) {
                throw new Fault("module not found: " + moduleName, null);
            }
            Object module = opt_module.get();
            Object targetModule = getUnnamedModuleMethod.invoke((Object)targetLoader, new Object[0]);
            try {
                Method m = isOpen ? addOpensMethod : addExportsMethod;
                m.invoke(null, module, packageName, targetModule);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof IllegalArgumentException) {
                    String msg = e.getCause().getMessage();
                    throw new Fault("package not found: " + packageName + " (" + msg + ")", null);
                }
                throw new Fault("unexpected exception: " + e, e);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            throw new Fault("unexpected exception: " + e, e);
        }
    }

    private static synchronized void init() throws Fault {
        if (bootLayer != null) {
            return;
        }
        try {
            Class<?> moduleFinderClass = Class.forName("java.lang.module.ModuleFinder");
            moduleFinderOfMethod = moduleFinderClass.getDeclaredMethod("of", Path[].class);
            Class<?> configurationClass = Class.forName("java.lang.module.Configuration");
            resolveMethod = configurationClass.getDeclaredMethod("resolve", moduleFinderClass, moduleFinderClass, Collection.class);
            Class<?> layerClass = Class.forName("java.lang.ModuleLayer");
            findModuleMethod = layerClass.getDeclaredMethod("findModule", String.class);
            configurationMethod = layerClass.getDeclaredMethod("configuration", new Class[0]);
            defineModulesWithOneLoaderMethod = layerClass.getDeclaredMethod("defineModulesWithOneLoader", configurationClass, ClassLoader.class);
            findLoaderMethod = layerClass.getDeclaredMethod("findLoader", String.class);
            Method bootLayerMethod = layerClass.getDeclaredMethod("boot", new Class[0]);
            bootLayer = bootLayerMethod.invoke(null, new Object[0]);
            Class<?> helperClass = Class.forName("java.lang.JTRegModuleHelper");
            addExportsMethod = helperClass.getDeclaredMethod("addExports", Object.class, String.class, Object.class);
            addOpensMethod = helperClass.getDeclaredMethod("addOpens", Object.class, String.class, Object.class);
            getUnnamedModuleMethod = ClassLoader.class.getDeclaredMethod("getUnnamedModule", new Class[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new Fault("unexpected exception: " + e, e);
        }
    }

    static class Fault
    extends Exception {
        private static final long serialVersionUID = 1L;

        Fault(String message, Throwable t) {
            super(message, t);
        }
    }
}

