/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.config;

import com.sun.javatest.TestDescription;
import com.sun.javatest.TestFinder;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestSuite;
import com.sun.javatest.finder.CommentStream;
import com.sun.javatest.finder.HTMLCommentStream;
import com.sun.javatest.finder.JavaCommentStream;
import com.sun.javatest.finder.ShScriptCommentStream;
import com.sun.javatest.finder.TagTestFinder;
import com.sun.javatest.regtest.agent.Flags;
import com.sun.javatest.regtest.config.Expr;
import com.sun.javatest.regtest.config.Modules;
import com.sun.javatest.regtest.config.RegressionContext;
import com.sun.javatest.regtest.config.TestProperties;
import com.sun.javatest.regtest.util.StringUtils;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class RegressionTestFinder
extends TagTestFinder {
    Map<String, TestDescription> paths = new HashMap<String, TestDescription>();
    private static final Pattern bugIdPattern = Pattern.compile("(([A-Z]+-)?[0-9]{7})|(14[0-9]{6})");
    public static final String TEST = "test";
    public static final String AUTHOR = "author";
    public static final String BUG = "bug";
    public static final String BUILD = "build";
    public static final String CLEAN = "clean";
    public static final String COMPILE = "compile";
    public static final String ENABLE_PREVIEW = "enablePreview";
    public static final String ERROR = "error";
    public static final String IGNORE = "ignore";
    public static final String KEY = "key";
    public static final String LIBRARY = "library";
    public static final String MODULES = "modules";
    public static final String REQUIRES = "requires";
    public static final String RUN = "run";
    public static final String SUMMARY = "summary";
    public static final String COMMENT = "comment";
    private static final String LINESEP = System.getProperty("line.separator");
    static final String[] excludeNames = new String[]{".hg", ".git"};
    static final String PARSE_TAG_BAD = "Invalid tag: ";
    static final String PARSE_BUG_EMPTY = "No value provided for `@bug'";
    static final String PARSE_BUG_INVALID = "Invalid or unrecognized bugid: ";
    static final String PARSE_KEY_EMPTY = "No value provided for `@key'";
    static final String PARSE_KEY_BAD = "Invalid key: ";
    static final String PARSE_MULTIPLE_KEY_NOT_ALLOWED = "@key may be used at most once in a given test";
    static final String PARSE_LIB_EMPTY = "No value provided for `@library'";
    static final String PARSE_LIB_AFTER_RUN = "`@library' must appear before first action tag";
    static final String PARSE_MODULES_EMPTY = "No values provided for @modules";
    static final String PARSE_BAD_MODULE = "Invalid item in @modules: ";
    static final String PARSE_BAD_RUN = "Explicit action tag not allowed";
    static final String PARSE_REQUIRES_EMPTY = "No expression for @requires";
    static final String PARSE_REQUIRES_SYNTAX = "Syntax error in @requires expression: ";
    static final String PARSE_RUN_ENDS_WITH_BUILD = "No action after @build";
    static final String PARSE_MULTIPLE_COMMENTS_NOT_ALLOWED = "Multiple test descriptions not allowed";
    static final String PARSE_INVALID_ENABLE_PREVIEW = "invalid value for @enablePreview: ";
    private static final Pattern BOOTCLASSPATH_OPTION = RegressionTestFinder.getOptionPattern("bootclasspath");
    private static final Pattern OTHERVM_OPTION = RegressionTestFinder.getOptionPattern("othervm");
    private static final Pattern MANUAL_OPTION = RegressionTestFinder.getOptionPattern("manual");
    private static final Pattern NATIVE_OPTION = RegressionTestFinder.getOptionPattern("native");
    private static final Pattern SHELL_ACTION = RegressionTestFinder.getActionPattern("shell");
    private static final Pattern JUNIT_ACTION = RegressionTestFinder.getActionPattern("junit");
    private static final Pattern TESTNG_ACTION = RegressionTestFinder.getActionPattern("testng");
    private static final Pattern DRIVER_ACTION = RegressionTestFinder.getActionPattern("driver");
    private static final Pattern IGNORE_ACTION = RegressionTestFinder.getActionPattern("ignore");
    private final Set<String> validTagNames;
    private final TestProperties properties;
    private final boolean checkBugID;
    private final RegressionContext baseContext;
    private static final I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(RegressionTestFinder.class);
    private static final boolean rejectTrailingBuild = !Boolean.getBoolean("javatest.regtest.allowTrailingBuild");
    private static final boolean traceFinder = Flags.get("traceFinder");

    public RegressionTestFinder(TestProperties properties, TestFinder.ErrorHandler errHandler) {
        this.setErrorHandler(errHandler);
        this.properties = properties;
        this.checkBugID = properties.checkBugID;
        Set<String> rootValidKeys = properties.validKeys;
        this.validTagNames = this.getValidTagNames(rootValidKeys != null);
        this.exclude(excludeNames);
        this.addExtension(".sh", ShScriptCommentStream.class);
        this.addExtension(".html", HTMLCommentStream.class);
        this.addExtension(".jasm", JavaCommentStream.class);
        this.addExtension(".jcod", JavaCommentStream.class);
        this.baseContext = RegressionContext.getDefault();
    }

    Set<String> getAllowedExtensions() {
        return ((Map)this.getField("extensionTable")).keySet();
    }

    Set<String> getIgnoredDirectories() {
        return ((Map)this.getField("excludeList")).keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getField(String name) {
        Field f = TagTestFinder.class.getDeclaredField(name);
        try {
            f.setAccessible(true);
            Object object = f.get(this);
            f.setAccessible(false);
            return object;
        }
        catch (Throwable throwable) {
            try {
                f.setAccessible(false);
                throw throwable;
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                e.printStackTrace(System.err);
                return null;
            }
        }
    }

    @Override
    protected void setRoot(File testSuiteRoot) throws TestFinder.Fault {
        super.setRoot(this.canon(testSuiteRoot));
    }

    @Override
    protected void scanFile(File file) {
        if (traceFinder) {
            System.err.println("RegressionTestFinder: reading " + file);
        }
        try {
            File tngRoot = this.properties.getTestNGRoot(file);
            if (tngRoot != null) {
                this.scanTestNGFile(tngRoot, file);
            } else {
                File junitRoot = this.properties.getJUnitRoot(file);
                if (junitRoot != null) {
                    this.scanJUnitFile(junitRoot, file);
                } else {
                    this.modifiedScanFile(file);
                }
            }
        }
        catch (TestSuite.Fault e) {
            this.error(i18n, "finder.cant.read.test.properties", (Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void modifiedScanFile(File file) {
        CommentStream cs;
        boolean super_fastScan;
        I18NResourceBundle super_i18n;
        try {
            Field i18nField = TagTestFinder.class.getDeclaredField("i18n");
            i18nField.setAccessible(true);
            super_i18n = (I18NResourceBundle)i18nField.get(this);
            Field fastScanField = TagTestFinder.class.getDeclaredField("fastScan");
            fastScanField.setAccessible(true);
            super_fastScan = (Boolean)fastScanField.get(this);
        }
        catch (IllegalAccessException | NoSuchFieldException ex) {
            throw new Error(ex);
        }
        int testDescNumber = 0;
        String name = file.getName();
        int dot = name.indexOf(46);
        if (dot == -1) {
            return;
        }
        String extn = name.substring(dot);
        Class<? extends CommentStream> csc = this.getClassForExtension(extn);
        if (csc == null) {
            this.error(super_i18n, "tag.noParser", file, extn);
            return;
        }
        try {
            cs = csc.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            this.error(super_i18n, "tag.cantCreateClass", csc.getName(), extn);
            return;
        }
        try {
            LineCounterBufferedReader r = new LineCounterBufferedReader(new FileReader(file));
            cs.init(r);
            if (super_fastScan) {
                cs.setFastScan(true);
            }
            String comment = cs.readComment();
            int commentLine = r.lineNumber;
            while (comment != null) {
                Map<String, String> tagValues = this.parseComment(comment, file);
                String nextComment = cs.readComment();
                int nextCommentLine = r.lineNumber;
                if (!tagValues.isEmpty()) {
                    if (tagValues.get("id") == null) {
                        if (nextComment != null && nextComment.trim().startsWith("@test") || testDescNumber != 0) {
                            Matcher m;
                            String test = tagValues.get(TEST);
                            String id = test != null && (m = Pattern.compile("id=(?<id>[A-Za-z0-9-_]+)\\b.*").matcher(test)).matches() ? m.group("id") : "id" + testDescNumber;
                            tagValues.put("id", id);
                        }
                        ++testDescNumber;
                    }
                    tagValues.remove(TEST);
                    this.foundTestDescription(tagValues, file, commentLine);
                }
                comment = nextComment;
                commentLine = nextCommentLine;
            }
        }
        catch (FileNotFoundException e) {
            this.error(super_i18n, "tag.cantFindFile", (Object)file);
        }
        catch (IOException e) {
            this.error(super_i18n, "tag.ioError", (Object)file);
        }
        finally {
            try {
                cs.close();
            }
            catch (IOException e) {}
        }
    }

    protected void scanTestNGFile(File tngRoot, File file) throws TestSuite.Fault {
        if (this.isTestNGTest(file)) {
            this.scanFile(tngRoot, file, "testngClass", true);
        }
    }

    protected void scanJUnitFile(File junitRoot, File file) throws TestSuite.Fault {
        if (this.isJUnitTest(file)) {
            this.scanFile(junitRoot, file, "junitClass", false);
        }
    }

    protected void scanFile(File junitRoot, File file, String classPropertyName, boolean setImportsJUnit) throws TestSuite.Fault {
        PackageImportParser p = new PackageImportParser(junitRoot, file);
        p.parse();
        String className = p.inferClassName();
        try (BufferedReader in = new BufferedReader(new FileReader(file));){
            Set<String> libDirs;
            Map<String, String> tagValues = this.readComments(file, in);
            if (tagValues == null) {
                tagValues = new HashMap<String, String>();
            }
            tagValues.put("packageRoot", this.getRootDir().toURI().relativize(junitRoot.toURI()).getPath());
            if (className == null) {
                tagValues.put(ERROR, "cannot determine class name");
            } else {
                tagValues.put(classPropertyName, className);
            }
            if (setImportsJUnit && p.importsJUnit) {
                tagValues.put("importsJUnit", "true");
            }
            if ((libDirs = this.properties.getLibDirs(file)) != null && !libDirs.isEmpty()) {
                tagValues.put(LIBRARY, StringUtils.join(libDirs, " "));
            }
            this.foundTestDescription(tagValues, file, 0);
        }
        catch (IOException e) {
            this.error(i18n, "finder.ioError", (Object)file);
        }
    }

    private Map<String, String> readComments(File file, BufferedReader in) throws IOException {
        String comment;
        JavaCommentStream cs = new JavaCommentStream();
        cs.init(in);
        cs.setFastScan(true);
        Map<String, String> tagValues = null;
        int index = 1;
        while ((comment = ((CommentStream)cs).readComment()) != null) {
            Map<String, String> tv = this.parseComment(comment, file);
            if (tv.isEmpty()) continue;
            if (tagValues == null) {
                tagValues = tv;
            } else {
                tv.put(ERROR, PARSE_MULTIPLE_COMMENTS_NOT_ALLOWED);
                tv.put("id", String.valueOf(index++));
                this.foundTestDescription(tv, file, 0);
            }
            tagValues.remove(TEST);
        }
        return tagValues;
    }

    protected boolean isTestNGTest(File file) {
        return this.isClassOrInterfaceFile(file);
    }

    protected boolean isJUnitTest(File file) {
        return this.isClassOrInterfaceFile(file);
    }

    private boolean isClassOrInterfaceFile(File file) {
        String name = file.getName();
        return name.endsWith(".java") && !name.equals("module-info.java") && !name.equals("package-info.java");
    }

    private File canon(File f) {
        try {
            return f.getCanonicalFile();
        }
        catch (IOException e) {
            return new File(f.getAbsoluteFile().toURI().normalize());
        }
    }

    @Override
    protected Map<String, String> normalize(Map<String, String> tagValues) {
        int sep;
        String lastLine;
        Object className;
        HashMap<String, String> newTagValues = new HashMap<String, String>();
        String fileName = this.getCurrentFile().getName();
        String baseName = fileName.substring(0, fileName.lastIndexOf("."));
        boolean isTestNG = tagValues.containsKey("testngClass");
        boolean isJUnit = tagValues.containsKey("junitClass");
        newTagValues.put("title", " ");
        newTagValues.put("source", fileName);
        if (isTestNG) {
            if (tagValues.get(RUN) != null) {
                tagValues.put(ERROR, PARSE_BAD_RUN);
            }
            className = tagValues.get("testngClass");
            newTagValues.put(RUN, "ASSUMED_ACTION testng " + (String)className + LINESEP);
        } else if (isJUnit) {
            if (tagValues.get(RUN) != null) {
                tagValues.put(ERROR, PARSE_BAD_RUN);
            }
            className = tagValues.get("junitClass");
            newTagValues.put(RUN, "ASSUMED_ACTION junit " + (String)className + LINESEP);
        } else if (fileName.endsWith(".sh")) {
            newTagValues.put(RUN, "ASSUMED_ACTION shell " + fileName + LINESEP);
        } else if (fileName.endsWith(".java")) {
            newTagValues.put(RUN, "ASSUMED_ACTION main " + baseName + LINESEP);
        } else {
            newTagValues.put(RUN, "ASSUMED_ACTION applet " + fileName + LINESEP);
        }
        for (Map.Entry entry : tagValues.entrySet()) {
            String name = (String)entry.getKey();
            Object value = (String)entry.getValue();
            block7 : switch (name) {
                case "summary": {
                    name = "title";
                    int pos = 0;
                    while ((pos = ((String)value).indexOf(".", pos)) != -1 && pos + 1 != ((String)value).length()) {
                        switch (((String)value).charAt(pos + 1)) {
                            case '\b': 
                            case '\t': 
                            case '\n': 
                            case '\f': 
                            case '\r': 
                            case ' ': {
                                value = ((String)value).substring(0, pos + 1);
                                break block7;
                            }
                        }
                        ++pos;
                    }
                    break;
                }
                case "bug": 
                case "key": {
                    name = "keywords";
                    String oldValue = (String)newTagValues.get("keywords");
                    if (oldValue == null) break;
                    value = oldValue + " " + (String)value;
                    break;
                }
                case "test": {
                    name = "keywords";
                    String oldValue = (String)newTagValues.get("keywords");
                    if (oldValue != null) {
                        value = oldValue + " regtest";
                        break;
                    }
                    value = "regtest";
                    break;
                }
            }
            newTagValues.put(name, (String)value);
        }
        String value = (String)newTagValues.get(RUN);
        Set<String> set = this.split((String)newTagValues.get("keywords"), "\\s+");
        if (RegressionTestFinder.match(value, OTHERVM_OPTION) || RegressionTestFinder.match(value, BOOTCLASSPATH_OPTION)) {
            set.add("othervm");
        }
        if (RegressionTestFinder.match(value, MANUAL_OPTION)) {
            set.add("manual");
        }
        if (RegressionTestFinder.match(value, NATIVE_OPTION)) {
            set.add("native");
        }
        if (RegressionTestFinder.match(value, SHELL_ACTION)) {
            set.add("shell");
        }
        if (RegressionTestFinder.match(value, JUNIT_ACTION) || isJUnit) {
            set.add("junit");
        }
        if (RegressionTestFinder.match(value, TESTNG_ACTION) || isTestNG) {
            set.add("testng");
        }
        if (RegressionTestFinder.match(value, DRIVER_ACTION)) {
            set.add("driver");
        }
        if (RegressionTestFinder.match(value, IGNORE_ACTION)) {
            set.add(IGNORE);
        }
        newTagValues.put("keywords", StringUtils.join(set, " "));
        if (rejectTrailingBuild && (lastLine = value.substring((sep = value.lastIndexOf(LINESEP, value.length() - 1 - LINESEP.length())) == -1 ? 0 : sep + LINESEP.length())).startsWith("USER_SPECIFIED build")) {
            newTagValues.put(ERROR, PARSE_RUN_ENDS_WITH_BUILD);
        }
        int maxTimeout = -1;
        Pattern p = Pattern.compile("/timeout=([0-9]+)(?:/| )");
        Matcher m = p.matcher(value);
        while (m.find()) {
            int t = Integer.parseInt(m.group(1));
            if (t == 0) {
                maxTimeout = 0;
                break;
            }
            if (t <= maxTimeout) continue;
            maxTimeout = t;
        }
        if (maxTimeout > 0) {
            newTagValues.put("maxTimeout", String.valueOf(maxTimeout));
        }
        try {
            boolean ep;
            String enablePreview;
            Set<String> defaultModules;
            String modules = (String)newTagValues.get(MODULES);
            if ((modules == null || modules.isEmpty()) && (defaultModules = this.properties.getModules(this.getCurrentFile())) != null && !defaultModules.isEmpty()) {
                this.processModules(newTagValues, defaultModules);
            }
            if ((enablePreview = (String)newTagValues.get(ENABLE_PREVIEW)) == null && (ep = this.properties.getEnablePreview(this.getCurrentFile()))) {
                newTagValues.put(ENABLE_PREVIEW, "true");
            }
        }
        catch (TestSuite.Fault e) {
            this.error(i18n, "finder.cant.read.test.properties", (Object)e.getMessage());
        }
        return newTagValues;
    }

    private static boolean match(CharSequence cs, Pattern p) {
        return p.matcher(cs).matches();
    }

    private Set<String> split(String s, String regex) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        if (s != null) {
            result.addAll(List.of(s.split(regex)));
        }
        return result;
    }

    @Override
    protected void processEntry(Map<String, String> entries, String name, String value) {
        if (name.startsWith(COMPILE) || name.startsWith(CLEAN) || name.startsWith(BUILD) || name.startsWith(IGNORE)) {
            value = name + " " + (String)value;
            name = RUN;
        }
        try {
            switch (name) {
                case "run": {
                    this.processRun(entries, (String)value);
                    break;
                }
                case "bug": {
                    this.processBug(entries, (String)value);
                    break;
                }
                case "requires": {
                    this.processRequires(entries, (String)value);
                    break;
                }
                case "key": {
                    this.processKey(entries, (String)value);
                    break;
                }
                case "modules": {
                    this.processModules(entries, (String)value);
                    break;
                }
                case "library": {
                    this.processLibrary(entries, (String)value);
                    break;
                }
                case "comment": {
                    break;
                }
                case "enablePreview": {
                    this.processEnablePreview(entries, (String)value);
                    break;
                }
                default: {
                    if (!this.validTagNames.contains(name)) {
                        this.parseError(entries, PARSE_TAG_BAD + name);
                        break;
                    }
                    entries.put(name, (String)value);
                    break;
                }
            }
        }
        catch (TestSuite.Fault e) {
            this.reportError(entries, e.getMessage());
        }
    }

    @Override
    protected void foundTestDescription(TestDescription td) {
        String wrp = TestResult.getWorkRelativePath(td);
        TestDescription other = this.paths.get(wrp);
        if (other != null && !td.getRootRelativeURL().equals(other.getRootRelativeURL())) {
            this.error(i18n, "finder.jtrClash", td.getFile(), other.getFile());
            return;
        }
        super.foundTestDescription(td);
        this.paths.put(wrp, td);
    }

    private void parseError(Map<String, String> tagValues, String value) {
        this.reportError(tagValues, "Parse Exception: " + value);
    }

    private void reportError(Map<String, String> tagValues, String value) {
        tagValues.putIfAbsent(ERROR, value);
    }

    private void processRun(Map<String, String> tagValues, String value) {
        String oldValue = tagValues.get(RUN);
        StringBuilder sb = new StringBuilder();
        if (oldValue != null) {
            sb.append(oldValue);
        }
        sb.append("USER_SPECIFIED").append(" ").append(value).append(LINESEP);
        tagValues.put(RUN, sb.toString());
    }

    private void processBug(Map<String, String> tagValues, String value) {
        if (value.trim().length() == 0) {
            this.parseError(tagValues, PARSE_BUG_EMPTY);
            return;
        }
        StringBuilder newValue = new StringBuilder();
        if (tagValues.get(BUG) != null) {
            newValue.append(tagValues.get(BUG));
        }
        for (String bugid : StringUtils.splitWS(value)) {
            if (this.checkBugID && !bugIdPattern.matcher(bugid).matches()) {
                this.parseError(tagValues, PARSE_BUG_INVALID + bugid);
                continue;
            }
            if (newValue.length() > 0) {
                newValue.append(" ");
            }
            newValue.append(BUG).append(bugid);
        }
        if (newValue.length() > 0) {
            tagValues.put(BUG, newValue.toString());
        }
    }

    private void processRequires(Map<String, String> tagValues, String value) throws TestSuite.Fault {
        if (value.trim().length() == 0) {
            this.parseError(tagValues, PARSE_REQUIRES_EMPTY);
            return;
        }
        try {
            Set<String> validPropNames = this.properties.getValidRequiresProperties(this.getCurrentFile());
            RegressionContext c = new RegressionContext(this.baseContext, validPropNames);
            Expr.parse(value, c);
        }
        catch (Expr.Fault f) {
            this.parseError(tagValues, PARSE_REQUIRES_SYNTAX + f.getMessage());
            return;
        }
        tagValues.merge(REQUIRES, value, (a, b) -> "(" + a + ") & (" + b + ")");
    }

    private void processKey(Map<String, String> tagValues, String value) throws TestSuite.Fault {
        if (tagValues.containsKey(KEY)) {
            this.reportError(tagValues, PARSE_MULTIPLE_KEY_NOT_ALLOWED);
            return;
        }
        if (value.trim().length() == 0) {
            this.parseError(tagValues, PARSE_KEY_EMPTY);
            return;
        }
        Set<String> validKeys = this.properties.getValidKeys(this.getCurrentFile());
        StringBuilder newValue = new StringBuilder();
        for (String key : StringUtils.splitWS(value)) {
            String k = key.replace("-", "_");
            if (!validKeys.contains(k)) {
                this.parseError(tagValues, PARSE_KEY_BAD + key);
                continue;
            }
            if (newValue.length() > 0) {
                newValue.append(" ");
            }
            newValue.append(k);
        }
        if (newValue.length() > 0) {
            tagValues.put(KEY, newValue.toString());
        }
    }

    private void processModules(Map<String, String> tagValues, String value) throws TestSuite.Fault {
        if (value.trim().length() == 0) {
            this.parseError(tagValues, PARSE_MODULES_EMPTY);
            return;
        }
        this.processModules(tagValues, List.of(value.trim().split("\\s+")));
    }

    private void processModules(Map<String, String> tagValues, Collection<String> modules) {
        for (String word : modules) {
            try {
                Modules.Entry entry = Modules.parse(word);
            }
            catch (Modules.Fault f) {
                this.parseError(tagValues, PARSE_BAD_MODULE + f.getMessage());
                return;
            }
        }
        String oldValue = tagValues.get(MODULES);
        String value = StringUtils.join(modules, " ");
        if (oldValue == null) {
            tagValues.put(MODULES, value);
        } else {
            tagValues.put(MODULES, oldValue + " " + value);
        }
    }

    private void processLibrary(Map<String, String> tagValues, String value) {
        if (tagValues.get(RUN) == null) {
            if (value.trim().length() != 0) {
                String oldValue = tagValues.get(LIBRARY);
                Object newValue = oldValue != null ? value.trim() + " " + oldValue : value.trim();
                tagValues.put(LIBRARY, (String)newValue);
            } else {
                this.parseError(tagValues, PARSE_LIB_EMPTY);
            }
        } else {
            this.parseError(tagValues, PARSE_LIB_AFTER_RUN);
        }
    }

    private void processEnablePreview(Map<String, String> tagValues, String value) {
        if (value.isEmpty()) {
            tagValues.put(ENABLE_PREVIEW, "true");
        } else {
            String v;
            switch (v = value.trim()) {
                case "false": 
                case "true": {
                    tagValues.put(ENABLE_PREVIEW, v);
                    break;
                }
                default: {
                    this.parseError(tagValues, PARSE_INVALID_ENABLE_PREVIEW + v);
                }
            }
        }
    }

    private Set<String> getValidTagNames(boolean allowKey) {
        HashSet<String> tags = new HashSet<String>();
        tags.add(TEST);
        tags.add(BUG);
        tags.add(SUMMARY);
        tags.add(AUTHOR);
        tags.add(LIBRARY);
        tags.add(MODULES);
        tags.add(CLEAN);
        tags.add(COMPILE);
        tags.add(IGNORE);
        tags.add(RUN);
        tags.add(BUILD);
        tags.add(REQUIRES);
        tags.add(COMMENT);
        tags.add(ENABLE_PREVIEW);
        if (allowKey) {
            tags.add(KEY);
        }
        return tags;
    }

    private static Pattern getActionPattern(String name) {
        return Pattern.compile("(?s).*(USER_SPECIFIED|ASSUMED_ACTION) \\Q" + name + "\\E\\b.*");
    }

    private static Pattern getOptionPattern(String name) {
        return Pattern.compile("(?s).*/" + name + "[/= \t].*");
    }

    private static class LineCounterBufferedReader
    extends BufferedReader {
        int lineNumber = 1;

        LineCounterBufferedReader(FileReader r) {
            super(r);
        }

        @Override
        public int read() throws IOException {
            int ch = super.read();
            this.checkNewline(ch);
            return ch;
        }

        @Override
        public String readLine() throws IOException {
            String line = super.readLine();
            ++this.lineNumber;
            return line;
        }

        @Override
        public int read(char[] buf, int offset, int length) throws IOException {
            int n = super.read(buf, offset, length);
            for (int i = offset; i < offset + n; ++i) {
                this.checkNewline(buf[i]);
            }
            return n;
        }

        private void checkNewline(int ch) {
            if (ch == 10) {
                ++this.lineNumber;
            }
        }
    }

    private class PackageImportParser {
        private final File rootDir;
        private final File file;
        String packageName;
        boolean importsJUnit;

        PackageImportParser(File rootDir, File file) {
            this.rootDir = rootDir;
            this.file = file;
        }

        void parse() {
            try (BufferedReader in = new BufferedReader(new FileReader(this.file));){
                int t;
                StreamTokenizer st = new StreamTokenizer(in);
                st.resetSyntax();
                st.slashSlashComments(true);
                st.slashStarComments(true);
                st.wordChars(97, 122);
                st.wordChars(65, 90);
                st.wordChars(36, 36);
                st.wordChars(95, 95);
                st.wordChars(48, 57);
                st.wordChars(46, 46);
                st.wordChars(42, 42);
                st.whitespaceChars(0, 32);
                st.eolIsSignificant(false);
                while ((t = st.nextToken()) != -1) {
                    if (t != -3) {
                        return;
                    }
                    switch (st.sval) {
                        case "package": {
                            if (st.nextToken() != -3) {
                                return;
                            }
                            this.packageName = st.sval;
                            if (st.nextToken() == 59) break;
                            return;
                        }
                        case "import": {
                            t = st.nextToken();
                            if (t == -3 && st.sval.equals("static")) {
                                t = st.nextToken();
                            }
                            if (t == -3 && st.sval.startsWith("org.junit")) {
                                this.importsJUnit = true;
                                return;
                            }
                            if (st.nextToken() == 59) break;
                            return;
                        }
                    }
                }
            }
            catch (IOException e) {
                RegressionTestFinder.this.error(i18n, "finder.ioError", this.file);
            }
        }

        String inferClassName() {
            String pkg_fn;
            String path = this.rootDir.toURI().relativize(this.file.toURI()).getPath();
            String fn = this.file.getName();
            String cn = fn.replace(".java", "");
            String string = pkg_fn = this.packageName == null ? this.file.getName() : this.packageName.replace('.', '/') + "/" + fn;
            if (path.equalsIgnoreCase(pkg_fn)) {
                return this.packageName == null ? cn : this.packageName + "." + cn;
            }
            if (path.toLowerCase().endsWith("/" + pkg_fn.toLowerCase())) {
                String mn = path.substring(0, path.length() - pkg_fn.length());
                return mn + (String)(this.packageName == null ? cn : this.packageName + "." + cn);
            }
            return null;
        }
    }
}

