/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.exec;

import com.sun.javatest.regtest.TimeoutHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public class DefaultTimeoutHandler
extends TimeoutHandler {
    public DefaultTimeoutHandler(PrintWriter log, File outputDir, Path testJdk) {
        super(log, outputDir, testJdk);
    }

    @Override
    protected void runActions(Process proc, long pid) throws InterruptedException {
        this.runJstack(pid);
    }

    private void runJstack(long pid) throws InterruptedException {
        try {
            this.log.println("Running jstack on process " + pid);
            Path jstack = this.findJstack();
            if (jstack == null) {
                this.log.println("Warning: Could not find jstack in: " + this.testJdk.getAbsolutePath());
                this.log.println("Will not dump jstack output.");
                return;
            }
            ProcessBuilder pb = new ProcessBuilder(jstack.toAbsolutePath().toString(), "" + pid);
            pb.redirectErrorStream(true);
            Process p = pb.start();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    this.log.println(line);
                }
                p.waitFor();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace(this.log);
        }
    }

    private Path findJstack() {
        Path p = this.testJdk.toPath();
        Path jstack = p.resolve("bin").resolve("jstack");
        if (!Files.exists(jstack, new LinkOption[0]) && !Files.exists(jstack = p.resolve("bin").resolve("jstack.exe"), new LinkOption[0])) {
            return null;
        }
        return jstack;
    }
}

