/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.report;

import com.sun.javatest.TestFilter;
import com.sun.javatest.regtest.Main;
import com.sun.javatest.regtest.config.RegressionParameters;
import com.sun.javatest.regtest.config.RegressionTestSuite;
import com.sun.javatest.regtest.config.TestManager;
import com.sun.javatest.regtest.report.ElapsedTimeHandler;
import com.sun.javatest.regtest.report.SummaryReporter;
import com.sun.javatest.regtest.report.TestStats;
import com.sun.javatest.report.Report;
import com.sun.javatest.report.ReportSettings;
import com.sun.javatest.util.HTMLWriter;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.DateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class RegressionReporter {
    final PrintWriter log;
    private File reportDir;
    private TestManager testManager;
    private File parent;
    DateFormat df = DateFormat.getDateTimeInstance();
    String backups = System.getProperty("javatest.report.backups");
    List<String> reportKinds = List.of(System.getProperty("javatest.report.kinds", "html text").split("[ ,]+"));

    public RegressionReporter(PrintWriter log) {
        this.log = log;
    }

    public void report(RegressionParameters params, ElapsedTimeHandler elapsedTimeHandler, TestStats testStats, TestFilter filter, boolean quiet) {
        File rd = params.getReportDir().toFile();
        File wd = params.getWorkDirectory().getRoot();
        try {
            if (Thread.interrupted()) {
                this.log.println("WARNING: interrupt status cleared prior to writing report");
            }
            Report r = new Report();
            ReportSettings s = new ReportSettings(params);
            if (this.reportKinds.contains("html")) {
                s.setEnableHtmlReport(true);
                s.setHtmlMainReport(true, true);
                s.setShowKflReport(false);
            }
            if (this.reportKinds.contains("text")) {
                s.setEnablePlainReport(true);
            }
            if (this.reportKinds.contains("xml")) {
                s.setEnableXmlReport(true);
            }
            s.setFilter(filter);
            if (this.backups == null) {
                s.setEnableBackups(false);
            } else {
                try {
                    s.setBackupLevels(Integer.parseInt(this.backups));
                    s.setEnableBackups(true);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            rd.mkdirs();
            r.writeReports(s, rd);
            if (s.isPlainEnabled()) {
                int countJUnit;
                int countTestNG;
                int sumOfCounts;
                if (elapsedTimeHandler != null) {
                    elapsedTimeHandler.report(r);
                }
                if (testStats != null) {
                    testStats.report(r);
                }
                if ((sumOfCounts = (countTestNG = SummaryReporter.forTestNG(params.getWorkDirectory()).writeReport(rd)) + (countJUnit = SummaryReporter.forJUnit(params.getWorkDirectory()).writeReport(rd))) > 0) {
                    this.log.println(String.format(Locale.ROOT, "Framework-based tests: %,d = %,d TestNG + %,d JUnit", sumOfCounts, countTestNG, countJUnit));
                }
            }
            this.fixupReports(rd, wd);
            if (!quiet) {
                this.logReportWritten(rd);
            }
        }
        catch (IOException | SecurityException e) {
            this.log.println("Error while writing report: " + e);
        }
    }

    public void report(TestManager testManager) throws Main.Fault {
        this.testManager = testManager;
        this.reportDir = testManager.getReportDirectory().toFile();
        this.parent = RegressionReporter.getCommonParent(testManager.getTestSuites());
        if (this.parent != null && this.parent.getParentFile() == null) {
            this.parent = null;
        }
        try {
            if (this.reportKinds.contains("html")) {
                this.writeHTMLReport();
            }
            if (this.reportKinds.contains("text")) {
                this.writeCombinedSummary();
            }
            this.writeIndex();
            this.fixupReports(this.reportDir, testManager.getWorkDirectory().toFile());
            this.logReportWritten(this.reportDir);
        }
        catch (IOException e) {
            this.log.println("Error while writing report: " + e);
        }
    }

    private void logReportWritten(File reportDir) {
        File report = new File(new File(reportDir, "html"), "report.html");
        if (report.exists()) {
            this.log.println("Report written to " + RegressionReporter.canon(report));
        }
    }

    private void writeHTMLReport() throws IOException, Main.Fault {
        String title = this.parent == null ? "MultiRun Report" : "MultiRun Report: " + this.parent;
        File htmlDir = new File(this.reportDir, "html");
        htmlDir.mkdirs();
        File report = new File(htmlDir, "report.html");
        try (BufferedWriter htmlOut = new BufferedWriter(new FileWriter(report));){
            HTMLWriter html = new HTMLWriter(htmlOut);
            html.startTag("html");
            html.startTag("head");
            html.startTag("title");
            html.write(title);
            html.endTag("title");
            html.endTag("head");
            html.startTag("body");
            html.startTag("h1");
            html.write(title);
            html.endTag("h1");
            html.startTag("p");
            html.write("Date of report: " + this.df.format(new Date()));
            html.endTag("p");
            html.startTag("table");
            html.writeAttr("border", "1");
            html.startTag("tr");
            for (String s : new String[]{"Test Suite", "Results", "Report"}) {
                html.startTag("th");
                html.write(s);
                html.endTag("th");
            }
            html.endTag("tr");
            for (RegressionTestSuite testSuite : this.testManager.getTestSuites()) {
                html.startTag("tr");
                html.startTag("td");
                html.startTag("a");
                File ts = testSuite.getRootDir();
                html.writeAttr("href", this.getURIPath(ts));
                html.write(RegressionReporter.relativize(this.parent, ts).getPath());
                html.endTag("a");
                html.endTag("td");
                html.startTag("td");
                html.startTag("a");
                File wd = this.testManager.getWorkDirectory(testSuite).getRoot();
                html.writeAttr("href", this.getURIPath(wd));
                html.write(wd.getName());
                html.endTag("a");
                html.endTag("td");
                html.startTag("td");
                html.startTag("a");
                Path rd = this.testManager.getReportDirectory(testSuite);
                html.writeAttr("href", "../" + this.encode(rd.getFileName().toString()) + "/index.html");
                html.write(rd.getFileName().toString());
                html.endTag("a");
                html.endTag("td");
                html.endTag("tr");
            }
            html.endTag("table");
            html.endTag("body");
            html.endTag("html");
            html.close();
        }
    }

    private void fixupReports(File report, File work) throws IOException {
        work = this.getCanonicalFile(work);
        report = this.getCanonicalFile(report);
        File workParent = work.getParentFile();
        File reportParent = report.getParentFile();
        File htmlDir = new File(report, "html");
        if (RegressionReporter.equal(work, report)) {
            this.fixupReportFiles(report, work, ".");
            this.fixupReportFiles(htmlDir, work, "..");
        } else if (RegressionReporter.equal(report, workParent)) {
            String relPath = this.encode(work.getName());
            this.fixupReportFiles(report, work, relPath);
            this.fixupReportFiles(htmlDir, work, "../" + relPath);
        } else if (RegressionReporter.equal(work, reportParent)) {
            this.fixupReportFiles(report, work, "..");
            this.fixupReportFiles(htmlDir, work, "../..");
        } else if (RegressionReporter.equal(workParent, reportParent)) {
            String relPath = this.encode(work.getName());
            this.fixupReportFiles(report, work, "../" + relPath);
            this.fixupReportFiles(htmlDir, work, "../../" + relPath);
        } else if (RegressionReporter.equal(workParent.getParentFile(), reportParent.getParentFile())) {
            String relPath = "../../" + this.encode(workParent.getName()) + "/" + this.encode(work.getName());
            this.fixupReportFiles(report, work, relPath);
            this.fixupReportFiles(htmlDir, work, "../" + relPath);
        }
    }

    private String encode(String s) throws IOException {
        return URLEncoder.encode(s, StandardCharsets.UTF_8);
    }

    private void fixupReportFiles(File dir, File oldFile, String newPath) throws IOException {
        LinkedHashMap<Object, Object> replaceMap = new LinkedHashMap<Object, Object>();
        replaceMap.put("href=\"" + this.getURIPath(oldFile) + "/", "href=\"" + newPath + "/");
        replaceMap.put("href=\"" + this.getURIPath(oldFile) + "\"", "href=\"" + newPath + "\"");
        replaceMap.put("href=\"" + this.getCanonicalURIPath(oldFile) + "/", "href=\"" + newPath + "/");
        replaceMap.put("href=\"" + this.getCanonicalURIPath(oldFile) + "\"", "href=\"" + newPath + "\"");
        replaceMap.put("href=\"" + this.getURIPath(dir) + "/", "href=\"");
        replaceMap.put("href=\"" + this.getURIPath(dir) + "\"", "href=\".\"");
        replaceMap.put("href=\"" + this.getCanonicalURIPath(dir) + "/", "href=\"");
        replaceMap.put("href=\"" + this.getCanonicalURIPath(dir) + "\"", "href=\".\"");
        replaceMap.put("href=\"#Configuration and Other Settings\"", "href=\"#Configuration%20and%20Other%20Settings\"");
        replaceMap.put("href=\"#Known Failure Analysis\"", "href=\"#Known%20Failure%20Analysis\"");
        File[] children = dir.listFiles();
        if (children == null) {
            this.log.println("Cannot update report files for " + dir);
        } else {
            for (File f : children) {
                if (!f.getName().endsWith(".html")) continue;
                try {
                    String content = this.read(f);
                    for (Map.Entry e : replaceMap.entrySet()) {
                        content = content.replace((CharSequence)e.getKey(), (CharSequence)e.getValue());
                    }
                    this.write(f, content);
                }
                catch (IOException e) {
                    this.log.println("Error while updating report: " + e);
                }
            }
        }
    }

    String getURIPath(File f) {
        String p = f.toURI().getRawPath();
        return p.endsWith("/") ? p.substring(0, p.length() - 1) : p;
    }

    String getCanonicalURIPath(File f) throws IOException {
        File cf = this.getCanonicalFile(f);
        StringBuilder sb = new StringBuilder();
        String path = cf.getPath();
        if (cf.isAbsolute() && !path.startsWith("/")) {
            sb.append('/');
        }
        for (int i = 0; i < path.length(); ++i) {
            char ch = path.charAt(i);
            String encoded = ch == File.separatorChar ? "/" : URLEncoder.encode(String.valueOf(ch), StandardCharsets.UTF_8);
            sb.append(encoded);
        }
        return sb.toString();
    }

    File getCanonicalFile(File f) {
        try {
            return f.getCanonicalFile();
        }
        catch (IOException e) {
            return f.getAbsoluteFile();
        }
    }

    private void writeCombinedSummary() throws IOException, Main.Fault {
        File textDir = new File(this.reportDir, "text");
        textDir.mkdirs();
        File report = new File(textDir, "summary.txt");
        try (BufferedWriter summaryOut = new BufferedWriter(new FileWriter(report));){
            for (RegressionTestSuite ts : this.testManager.getTestSuites()) {
                Path f = this.testManager.getReportDirectory(ts).resolve("text").resolve("summary.txt");
                if (!Files.exists(f, new LinkOption[0])) continue;
                Object s = Files.readString(f);
                if (!((String)s).endsWith("\n")) {
                    s = (String)s + "\n";
                }
                summaryOut.write((String)s);
            }
        }
    }

    private void writeIndex() throws IOException {
        String title = this.parent == null ? "MultiRun Report" : "MultiRun Report: " + this.parent;
        File index = new File(this.reportDir, "index.html");
        try (BufferedWriter indexOut = new BufferedWriter(new FileWriter(index));){
            HTMLWriter html = new HTMLWriter(indexOut);
            html.startTag("html");
            html.startTag("head");
            html.startTag("title");
            html.write(title);
            html.endTag("title");
            html.endTag("head");
            html.startTag("body");
            html.startTag("h1");
            html.write(title);
            html.endTag("h1");
            html.startTag("p");
            html.write("Date of report: " + this.df.format(new Date()));
            html.endTag("p");
            if (this.reportKinds.contains("html")) {
                html.startTag("p");
                html.startTag("a");
                html.writeAttr("href", "html/report.html");
                html.write("HTML Report");
                html.endTag("a");
                html.startTag("br");
                html.write("Contains links to the reports for the tests grouped by test suite.");
                html.endTag("p");
            }
            if (this.reportKinds.contains("text")) {
                html.startTag("p");
                html.startTag("a");
                html.writeAttr("href", "text/summary.txt");
                html.write("Plain Text Report");
                html.endTag("a");
                html.startTag("br");
                html.write("Combined text report for all the tests.");
                html.endTag("p");
            }
            html.endTag("body");
            html.endTag("html");
        }
    }

    private String read(File f) throws IOException {
        byte[] bytes = new byte[(int)f.length()];
        try (DataInputStream fIn = new DataInputStream(new FileInputStream(f));){
            fIn.readFully(bytes);
            String string = new String(bytes);
            return string;
        }
    }

    private void write(File f, String s) throws IOException {
        try (FileOutputStream fOut = new FileOutputStream(f);){
            fOut.write(s.getBytes());
        }
    }

    private static File getCommonParent(Set<RegressionTestSuite> testSuites) {
        String FS = File.separator;
        String path = null;
        for (RegressionTestSuite testSuite : testSuites) {
            int next;
            File file = testSuite.getRootDir();
            File dir = file.isDirectory() ? file : file.getParentFile();
            File absDir = dir == null ? new File(System.getProperty("user.dir")) : dir.getAbsoluteFile();
            Object p = absDir.getPath();
            if (!((String)p).endsWith(FS)) {
                p = (String)p + FS;
            }
            if (path == null || path.startsWith((String)p)) {
                path = p;
                continue;
            }
            if (((String)p).startsWith(path)) continue;
            int i = -1;
            while ((next = path.indexOf(FS, i + 1)) != -1 && next < ((String)p).length() && ((String)p).substring(i + 1, next).equals(path.substring(i + 1, next))) {
                i = next;
            }
            if (i == -1) {
                return null;
            }
            path = path.substring(0, i + 1);
        }
        return path == null ? null : new File(path);
    }

    private static File relativize(File base, File f) {
        if (base != null) {
            StringBuilder sb = new StringBuilder();
            while (f != null) {
                if (f.equals(base)) {
                    return new File(sb.toString());
                }
                if (sb.length() > 0) {
                    sb.insert(0, File.separator);
                }
                sb.insert(0, f.getName());
                f = f.getParentFile();
            }
        }
        return f;
    }

    private static File canon(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            return file.getAbsoluteFile();
        }
    }

    private static <T> boolean equal(T t1, T t2) {
        return t1 == null ? t2 == null : t1.equals(t2);
    }
}

