/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.report;

import com.sun.javatest.Harness;
import com.sun.javatest.Parameters;
import com.sun.javatest.Status;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestFilter;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.regtest.config.RegressionParameters;
import com.sun.javatest.regtest.report.BasicObserver;
import com.sun.javatest.report.Report;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class TestStats {
    private Map<TestFilter, ? extends List<TestDescription>> filterDetails;
    public int[] counts = new int[4];
    int passed_skipped_count;
    int notRun_excluded_count;
    int notRun_keywords_count;
    int notRun_matchList_count;
    int notRun_modules_count;
    int notRun_priorStatus_count;
    int notRun_requires_count;
    int notRun_timeLimit_count;
    int notRun_other_count;
    private static final I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(TestStats.class);

    public void register(Harness h) {
        h.addObserver(new BasicObserver(){
            RegressionParameters params;

            @Override
            public void startingTestRun(Parameters params) {
                this.params = (RegressionParameters)params;
            }

            @Override
            public void finishedTesting(TestResultTable.TreeIterator treeIterator) {
                TestStats.this.filterDetails = treeIterator.getFilterStats();
                TestStats.this.filterDetails.forEach((f, tds) -> {
                    int count = tds.size();
                    switch (f.getName()) {
                        case "jtregExcludeListFilter": {
                            TestStats.this.notRun_excluded_count += count;
                            break;
                        }
                        case "jtregMatchListFilter": {
                            TestStats.this.notRun_matchList_count += count;
                            break;
                        }
                        case "jtregPriorStatusFilter": {
                            TestStats.this.notRun_priorStatus_count += count;
                            break;
                        }
                        case "Keywords": {
                            TestStats.this.notRun_keywords_count += count;
                            break;
                        }
                        case "ModulesFilter": {
                            TestStats.this.notRun_modules_count += count;
                            break;
                        }
                        case "RequiresFilter": {
                            TestStats.this.notRun_requires_count += count;
                            break;
                        }
                        case "TimeLimitFilter": {
                            TestStats.this.notRun_timeLimit_count += count;
                            break;
                        }
                        default: {
                            System.err.println("Filter not recognized: " + f.getName() + "(" + f + ")");
                            TestStats.this.notRun_other_count += count;
                        }
                    }
                });
            }

            @Override
            public synchronized void finishedTest(TestResult tr) {
                TestStats.this.add(tr);
            }
        });
    }

    public void add(TestResult tr) {
        int n = tr.getStatus().getType();
        this.counts[n] = this.counts[n] + 1;
        if (tr.getStatus().getReason().startsWith("Skipped: jtreg.SkippedException")) {
            ++this.passed_skipped_count;
        }
    }

    public void addAll(TestStats other) {
        for (int i = 0; i < this.counts.length; ++i) {
            int n = i;
            this.counts[n] = this.counts[n] + other.counts[i];
        }
    }

    public boolean isOK() {
        return this.counts[1] == 0 && this.counts[2] == 0;
    }

    public void showResultStats(PrintWriter out) {
        Object msg;
        int p = this.counts[0];
        int f = this.counts[1];
        int e = this.counts[2];
        int nr = this.counts[3];
        if (p + f + e + nr == 0) {
            msg = i18n.getString("stats.noTests");
        } else {
            String format = System.getProperty("jtreg.stats.format");
            if (format != null) {
                msg = this.getText(format);
            } else {
                msg = i18n.getString("stats.tests", p, p > 0 && f + e + nr > 0 ? 1 : 0, f, f > 0 && e + nr > 0 ? 1 : 0, e, e > 0 && nr > 0 ? 1 : 0, nr);
                if (this.passed_skipped_count > 0) {
                    msg = (String)msg + i18n.getString("stats.tests.skipped", (Object)this.passed_skipped_count);
                }
                if (this.notRun_excluded_count > 0) {
                    msg = (String)msg + i18n.getString("stats.tests.excluded", (Object)this.notRun_excluded_count);
                }
                if (this.notRun_matchList_count > 0) {
                    msg = (String)msg + i18n.getString("stats.tests.matchList", (Object)this.notRun_matchList_count);
                }
                if (this.notRun_keywords_count > 0) {
                    msg = (String)msg + i18n.getString("stats.tests.keywords", (Object)this.notRun_keywords_count);
                }
                if (this.notRun_modules_count > 0) {
                    msg = (String)msg + i18n.getString("stats.tests.modules", (Object)this.notRun_modules_count);
                }
                if (this.notRun_requires_count > 0) {
                    msg = (String)msg + i18n.getString("stats.tests.requires", (Object)this.notRun_requires_count);
                }
                if (this.notRun_priorStatus_count > 0) {
                    msg = (String)msg + i18n.getString("stats.tests.priorStatus", (Object)this.notRun_priorStatus_count);
                }
                if (this.notRun_timeLimit_count > 0) {
                    msg = (String)msg + i18n.getString("stats.tests.timeLimit", (Object)this.notRun_timeLimit_count);
                }
            }
        }
        out.println((String)msg);
    }

    public void report(Report report) throws IOException {
        File reportDir = report.getReportDir();
        File reportTextDir = new File(reportDir, "text");
        reportTextDir.mkdirs();
        File statsTxt = new File(reportTextDir, "stats.txt");
        this.report(statsTxt);
        File notRunTxt = new File(reportTextDir, "notRun.txt");
        this.reportNotRunTests(notRunTxt);
    }

    public void report(File file) throws IOException {
        try (PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(file)));){
            this.showResultStats(out);
        }
    }

    public void reportNotRunTests(File file) throws IOException {
        try (PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(file)));){
            this.reportNotRunTests(out);
        }
    }

    public void reportNotRunTests(PrintWriter out) {
        if (this.filterDetails == null || this.filterDetails.isEmpty()) {
            out.println("no tests were filtered out");
        } else {
            TreeMap map = new TreeMap(Comparator.comparing(TestDescription::getRootRelativeURL));
            this.filterDetails.forEach((f, tds) -> {
                Status status = new Status(3, f.getReason());
                tds.forEach(td -> map.put((TestDescription)td, status));
            });
            int maxNameLength = map.keySet().stream().map(TestDescription::getRootRelativeURL).mapToInt(String::length).max().getAsInt();
            for (Map.Entry e : map.entrySet()) {
                TestDescription td = (TestDescription)e.getKey();
                String td_url = td.getRootRelativeURL();
                Status status = (Status)e.getValue();
                out.println(td_url + " ".repeat(maxNameLength - td_url.length() + 1) + status);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    String getText(String format) {
        StringBuilder sb = new StringBuilder();
        int sbLen = 0;
        int i = 0;
        while (true) {
            block21: {
                block23: {
                    char c;
                    block22: {
                        if (i >= format.length()) {
                            return sb.substring(0, sbLen);
                        }
                        c = format.charAt(i);
                        if (c != '%' || i + 1 >= format.length()) break block22;
                        c = format.charAt(++i);
                        switch (c) {
                            case 'F': 
                            case 'P': 
                            case 'R': 
                            case 'S': 
                            case 'X': 
                            case 'e': 
                            case 'f': 
                            case 'i': 
                            case 'k': 
                            case 'n': 
                            case 'p': 
                            case 'r': 
                            case 's': 
                            case 't': 
                            case 'x': {
                                int count = this.getNumber(c);
                                if (count >= 0) {
                                    sb.append(String.valueOf(count));
                                    break;
                                }
                                sb.append("%").append(c);
                                break;
                            }
                            case ',': {
                                if (sb.length() > 0) {
                                    sb.append(",");
                                }
                                break block21;
                            }
                            case ' ': {
                                if (sb.length() > 0 && !Character.isWhitespace(sb.charAt(sb.length() - 1))) {
                                    sb.append(' ');
                                }
                                break block21;
                            }
                            case '%': {
                                sb.append("%");
                                break;
                            }
                            case '?': {
                                int count;
                                if (i + 1 < format.length()) {
                                    if ((c = format.charAt(++i)) == '{') {
                                        int j = format.indexOf("}", i);
                                        if (j == -1) {
                                            sb.append("%?").append(format.substring(i));
                                            i = format.length();
                                            break;
                                        }
                                        String text = format.substring(i + 1, j);
                                        i = j;
                                        if (text.length() <= 0) break;
                                        c = text.charAt(text.length() - 1);
                                        int count2 = this.getNumber(c);
                                        if (count2 > 0) {
                                            sb.append(text, 0, text.length() - 1).append(String.valueOf(count2));
                                            break;
                                        }
                                        if (count2 < 0) {
                                            sb.append("%?{").append(text).append("}");
                                            break;
                                        }
                                        break block21;
                                    } else {
                                        count = this.getNumber(c);
                                        if (count > 0) {
                                            sb.append(String.valueOf(count));
                                            break;
                                        }
                                        if (count < 0) {
                                            sb.append("%?").append(c);
                                            break;
                                        }
                                    }
                                    break block21;
                                } else {
                                    sb.append("%").append("?");
                                    break;
                                }
                            }
                            default: {
                                sb.append("%").append(c);
                                break;
                            }
                        }
                        break block23;
                    }
                    sb.append(c);
                }
                sbLen = sb.length();
            }
            ++i;
        }
    }

    int getNumber(char c) {
        switch (c) {
            case 'f': {
                return this.counts[1];
            }
            case 'F': {
                return this.counts[1] + this.counts[2];
            }
            case 'e': {
                return this.counts[2];
            }
            case 'i': 
            case 'k': {
                return this.notRun_keywords_count;
            }
            case 'm': {
                return this.notRun_modules_count;
            }
            case 'n': {
                return this.counts[3];
            }
            case 'o': {
                return this.notRun_other_count;
            }
            case 'p': {
                return this.counts[0];
            }
            case 'P': {
                return this.counts[0] - this.passed_skipped_count;
            }
            case 'r': {
                return this.counts[0] + this.counts[1] + this.counts[2];
            }
            case 'R': {
                return this.notRun_requires_count;
            }
            case 's': {
                return this.passed_skipped_count;
            }
            case 'S': {
                return this.notRun_priorStatus_count;
            }
            case 't': {
                return this.notRun_timeLimit_count;
            }
            case 'x': {
                return this.notRun_excluded_count;
            }
            case 'X': {
                return this.notRun_matchList_count;
            }
        }
        return -1;
    }
}

