/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.tool;

import com.sun.javatest.regtest.agent.SearchPath;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.util.List;
import java.util.Properties;

public class JarManager {
    private final Properties props = new Properties();
    private final Path libDir;

    static Path forClass(Class<?> clazz) {
        URL u = clazz.getProtectionDomain().getCodeSource().getLocation();
        try {
            return Path.of(u.toURI());
        }
        catch (URISyntaxException e) {
            throw new Error(e);
        }
    }

    JarManager(Path libDir) {
        InputStream in = this.getClass().getResourceAsStream("jars.properties");
        if (in == null) {
            throw new Error("Can't find jars.properties");
        }
        try (InputStreamReader r = new InputStreamReader(in);){
            this.props.load(r);
        }
        catch (IOException e) {
            throw new Error("problem reading jars.properties");
        }
        this.libDir = libDir;
    }

    SearchPath getPath(String name) {
        String jars;
        SearchPath result = new SearchPath();
        String p = System.getProperty(name + ".path");
        if (p != null) {
            result.append(p);
            if (!result.isEmpty()) {
                return result;
            }
        }
        if ((jars = this.props.getProperty(name)) != null) {
            for (String jar : jars.split("\\s+")) {
                result.append(this.libDir.resolve(jar));
            }
        }
        return result;
    }

    Path getFile(String name) {
        List<Path> files = this.getPath(name).asList();
        return files.size() == 1 ? files.get(0) : null;
    }
}

