/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.audit;

import com.sun.javatest.ExcludeList;
import com.sun.javatest.Parameters;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestFilter;
import com.sun.javatest.TestFinder;
import com.sun.javatest.TestFinderQueue;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.StringArray;
import java.io.PrintStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;

public class Audit {
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(Audit.class);
    private int testCount;
    private int[] checksumCounts = new int[3];
    private int[] envCounts = new int[2];
    private int[] statusCounts = new int[5];
    private boolean badDates = false;
    private TestDescription[] badTests;
    private TestResult[] badTestCaseTests;
    private TestResult[] badTestDescriptions;
    private TestResult[] badChecksumTests;
    private Date earliestStart;
    private Date latestStart;
    private DateFormat[] dateFormats;
    private Hashtable<String, Vector<String>> envTable = new Hashtable();
    private PrintStream out;

    public Audit(Parameters params) {
        this(Audit.getTestFinderQueue(params), params.getExcludeList(), params.getWorkDirectory());
    }

    public Audit(TestFinderQueue tfq, ExcludeList excludeList, WorkDirectory workDir) {
        TestDescription td;
        Vector<TestResult> badChecksumTestsV = new Vector<TestResult>();
        Vector<TestResult> badTestDescriptionsV = new Vector<TestResult>();
        Vector<TestResult> badTestCaseTestsV = new Vector<TestResult>();
        Vector<TestDescription> badTestsV = new Vector<TestDescription>();
        workDir.getTestResultTable().waitUntilReady();
        while ((td = tfq.next()) != null) {
            try {
                TestResult tr = new TestResult(workDir, TestResult.getWorkRelativePath(td));
                ++this.testCount;
                int n = tr.getStatus().getType();
                this.statusCounts[n] = this.statusCounts[n] + 1;
                byte by = tr.getChecksumState();
                this.checksumCounts[by] = this.checksumCounts[by] + 1;
                if (tr.getChecksumState() == 1) {
                    badChecksumTestsV.add(tr);
                }
                if (!Audit.equal(td, tr.getDescription())) {
                    badTestDescriptionsV.add(tr);
                }
                if (!this.checkTestCases(tr, excludeList)) {
                    badTestCaseTestsV.add(tr);
                }
                Map<String, String> trEnv = tr.getEnvironment();
                for (Map.Entry<String, String> e : trEnv.entrySet()) {
                    String key = e.getKey();
                    String value = e.getValue();
                    Vector<String> allValuesForKey = this.envTable.get(key);
                    if (allValuesForKey == null) {
                        allValuesForKey = new Vector();
                        this.envTable.put(key, allValuesForKey);
                    }
                    if (allValuesForKey.contains(value)) continue;
                    allValuesForKey.add(value);
                }
                String start = tr.getProperty("start");
                if (start == null) {
                    this.badDates = true;
                    continue;
                }
                Date d = this.parseDate(start);
                if (d == null) {
                    this.badDates = true;
                    continue;
                }
                if (this.earliestStart == null || d.before(this.earliestStart)) {
                    this.earliestStart = d;
                }
                if (this.latestStart != null && !d.after(this.latestStart)) continue;
                this.latestStart = d;
            }
            catch (TestResult.Fault e) {
                badTestsV.add(td);
            }
        }
        Enumeration<String> e = this.envTable.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            Vector<String> allValuesForKey = this.envTable.get(key);
            int n = allValuesForKey.size() == 1 ? 0 : 1;
            this.envCounts[n] = this.envCounts[n] + 1;
        }
        if (!badChecksumTestsV.isEmpty()) {
            this.badChecksumTests = badChecksumTestsV.toArray(new TestResult[badChecksumTestsV.size()]);
        }
        if (!badTestDescriptionsV.isEmpty()) {
            this.badTestDescriptions = badTestDescriptionsV.toArray(new TestResult[badTestDescriptionsV.size()]);
        }
        if (!badTestCaseTestsV.isEmpty()) {
            this.badTestCaseTests = badTestCaseTestsV.toArray(new TestResult[badTestCaseTestsV.size()]);
        }
        if (!badTestsV.isEmpty()) {
            this.badTests = badTestsV.toArray(new TestDescription[badTestsV.size()]);
        }
    }

    private static TestFinderQueue getTestFinderQueue(Parameters params) {
        TestSuite ts = params.getTestSuite();
        TestFinder tf = ts.getTestFinder();
        TestFinderQueue tfq = new TestFinderQueue();
        tfq.setTestFinder(tf);
        String[] tests = params.getTests();
        tfq.setTests(tests);
        TestFilter[] filters = params.getFilters();
        tfq.setFilters(filters);
        return tfq;
    }

    private static boolean equal(TestDescription a, TestDescription b) {
        if (a == null || b == null) {
            return a == b;
        }
        Iterator<String> eA = a.getParameterKeys();
        Iterator<String> eB = b.getParameterKeys();
        while (eA.hasNext() && eB.hasNext()) {
            String valB;
            String keyB;
            String keyA = eA.next();
            if (!keyA.equals(keyB = eB.next())) {
                return false;
            }
            String valA = a.getParameter(keyA);
            if (valA.equals(valB = a.getParameter(keyB)) || keyA.equals("keywords") && Audit.keywordMatch(valA, valB)) continue;
            return false;
        }
        return true;
    }

    private static boolean keywordMatch(String a, String b) {
        Object[] aa = StringArray.split(a);
        Arrays.sort(aa);
        Object[] bb = StringArray.split(b);
        Arrays.sort(bb);
        return Arrays.equals(aa, bb);
    }

    public TestResult[] getBadChecksumTests() {
        return this.badChecksumTests;
    }

    public TestResult[] getBadTestDescriptions() {
        return this.badTestDescriptions;
    }

    public TestDescription[] getBadTests() {
        return this.badTests;
    }

    public TestResult[] getBadTestCaseTests() {
        return this.badTestCaseTests;
    }

    public int[] getChecksumCounts() {
        return this.checksumCounts;
    }

    public int[] getEnvCounts() {
        return this.envCounts;
    }

    public Hashtable<String, Vector<String>> getEnvTable() {
        return this.envTable;
    }

    public int[] getStatusCounts() {
        return this.statusCounts;
    }

    public Date getEarliestStartTime() {
        return this.earliestStart;
    }

    public Date getLatestStartTime() {
        return this.latestStart;
    }

    public boolean hasBadStartTimes() {
        return this.badDates;
    }

    public boolean isOK() {
        return this.isStatusCountsOK() && this.isChecksumCountsOK() && this.isDateStampsOK() && this.isAllTestsOK() && this.isAllTestCasesOK() && this.isAllTestDescriptionsOK();
    }

    public boolean isAllTestsOK() {
        return this.badTests == null;
    }

    public boolean isAllTestCasesOK() {
        return this.badTestCaseTests == null;
    }

    public boolean isAllTestDescriptionsOK() {
        return this.badTestDescriptions == null;
    }

    public boolean isChecksumCountsOK() {
        return this.checksumCounts[1] == 0;
    }

    public boolean isDateStampsOK() {
        return this.earliestStart != null && this.latestStart != null && !this.badDates;
    }

    public boolean isStatusCountsOK() {
        if (this.testCount == 0) {
            return false;
        }
        for (int i = 0; i < this.statusCounts.length; ++i) {
            if (i == 0 || this.statusCounts[i] == 0) continue;
            return false;
        }
        return this.statusCounts[0] == this.testCount;
    }

    public synchronized void report(PrintStream out, boolean showAllEnvValues, boolean showMultipleEnvValues) {
        this.out = out;
        this.showResultCounts();
        this.showChecksumCounts();
        this.showDateStampInfo();
        this.showEnvCounts();
        this.showBadChecksums();
        this.showBadTestDescriptions();
        this.showBadTestCaseTests();
        this.showBadTests();
        if (showAllEnvValues || showMultipleEnvValues) {
            this.showEnvValues(showAllEnvValues);
        }
    }

    private void showBadChecksums() {
        if (this.badChecksumTests != null) {
            this.out.println("The following " + this.badChecksumTests.length + " tests had bad checksums.");
            for (TestResult tr : this.badChecksumTests) {
                this.out.println(tr.getWorkRelativePath());
            }
        }
    }

    private void showBadTestDescriptions() {
        if (this.badTestDescriptions != null) {
            this.out.println("The following " + this.badTestDescriptions.length + " tests had bad test descriptions.");
            for (TestResult tr : this.badTestDescriptions) {
                this.out.println(tr.getWorkRelativePath());
            }
        }
    }

    private void showBadTestCaseTests() {
        if (this.badTestCaseTests != null) {
            this.out.println(i18n.getString("adt.tooManyTestCases", (Object)this.badTestCaseTests.length));
            for (TestResult tr : this.badTestCaseTests) {
                this.out.println(tr.getWorkRelativePath());
            }
        }
    }

    private void showBadTests() {
        if (this.badTests != null) {
            this.out.println(i18n.getString("adt.badTests", (Object)this.badTests.length));
            for (TestDescription td : this.badTests) {
                this.out.println(TestResult.getWorkRelativePath(td));
            }
        }
    }

    private void showDateStampInfo() {
        if (this.earliestStart == null || this.latestStart == null) {
            this.out.println(i18n.getString("adt.noDateStamps"));
        } else {
            Integer b = this.badDates ? 1 : 0;
            this.out.println(i18n.getString("adt.earliestResult", this.earliestStart, b));
            this.out.println(i18n.getString("adt.latestResult", this.latestStart, b));
            if (this.badDates) {
                this.out.println(i18n.getString("adt.badDateStamps"));
            }
        }
    }

    private void showEnvCounts() {
        int u = this.envCounts[0];
        int m = this.envCounts[1];
        if (u + m > 0) {
            if (m == 0) {
                this.out.println(i18n.getString("adt.env.allOK"));
            } else {
                this.out.println(i18n.getString("adt.env.count", u, u > 0 && m > 0 ? 1 : 0, m));
            }
        }
    }

    private void showEnvValues(boolean showAll) {
        this.out.println();
        this.out.print(i18n.getString("adt.envList.title"));
        TreeSet<String> ss = new TreeSet<String>();
        Enumeration<String> e = this.envTable.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            ss.add(key);
        }
        for (String key : ss) {
            Vector<String> allValuesForKey = this.envTable.get(key);
            if (allValuesForKey.size() == 1) {
                if (!showAll) continue;
                this.out.println(i18n.getString("adt.envKeyValue", key, allValuesForKey.get(0)));
                continue;
            }
            this.out.println(i18n.getString("adt.envKey", (Object)key));
            for (String s : allValuesForKey) {
                this.out.println(i18n.getString("adt.envValue", (Object)s));
            }
        }
    }

    private void showChecksumCounts() {
        if (this.testCount > 0) {
            int g = this.checksumCounts[2];
            int b = this.checksumCounts[1];
            int n = this.checksumCounts[0];
            if (b == 0 && n == 0) {
                this.out.println(i18n.getString("adt.cs.allOK"));
            } else {
                this.out.println(i18n.getString("adt.cs.count", g, g > 0 && b + n > 0 ? 1 : 0, b, b > 0 && n > 0 ? 1 : 0, n));
            }
        }
    }

    private void showResultCounts() {
        if (this.testCount == 0) {
            this.out.println(i18n.getString("adt.status.noTests"));
        } else {
            int p = this.statusCounts[0];
            int f = this.statusCounts[1];
            int e = this.statusCounts[2];
            int nr = this.statusCounts[3];
            if (p == this.testCount) {
                this.out.println(i18n.getString("adt.status.allOK"));
            } else {
                this.out.println(i18n.getString("adt.status.count", p, p > 0 && f + e + nr > 0 ? 1 : 0, f, f > 0 && e + nr > 0 ? 1 : 0, e, e > 0 && nr > 0 ? 1 : 0, nr));
            }
        }
    }

    private boolean showCount(String msg, boolean needSep, int count) {
        if (count == 0) {
            return needSep;
        }
        this.out.print(i18n.getString(msg, needSep ? 1 : 0, count));
        return true;
    }

    private boolean checkTestCases(TestResult tr, ExcludeList excludeList) throws TestResult.Fault {
        String etcTestProp = tr.getProperty("excludedTestCases");
        if (etcTestProp == null) {
            return true;
        }
        String[] etcTest = StringArray.split(etcTestProp);
        if (excludeList.excludesAllOf(tr.getDescription())) {
            return true;
        }
        String[] etcTable = excludeList.getTestCases(tr.getDescription());
        if (etcTable == null) {
            return false;
        }
        block0: for (String anEtcTest : etcTest) {
            for (String anEtcTable : etcTable) {
                if (anEtcTest.equals(anEtcTable)) continue block0;
            }
            return false;
        }
        return true;
    }

    private Date parseDate(String s) {
        if (this.dateFormats == null) {
            this.initDateFormats();
        }
        for (int i = 0; i < this.dateFormats.length; ++i) {
            try {
                Date d = this.dateFormats[i].parse(s);
                if (i > 0) {
                    DateFormat tmp = this.dateFormats[i];
                    System.arraycopy(this.dateFormats, 0, this.dateFormats, 1, i);
                    this.dateFormats[0] = tmp;
                }
                return d;
            }
            catch (ParseException parseException) {
                continue;
            }
        }
        return null;
    }

    private void initDateFormats() {
        Vector<DateFormat> v = new Vector<DateFormat>();
        v.add(DateFormat.getDateTimeInstance());
        v.add(DateFormat.getDateTimeInstance(2, 2, Locale.ENGLISH));
        v.add(new SimpleDateFormat("EEE, dd MMMM yyyy HH:mm:ss zzz"));
        v.add(new SimpleDateFormat("EEE, dd MMMM yyyy HH:mm:ss zzz", Locale.ENGLISH));
        v.add(new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy"));
        v.add(new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.ENGLISH));
        String s = System.getProperty("javatest.date.format");
        if (s != null) {
            v.add(new SimpleDateFormat(s));
        }
        this.dateFormats = v.toArray(new DateFormat[v.size()]);
    }
}

