/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.core;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.util.UnrecoverableExceptions;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.Filter;
import org.junit.platform.engine.FilterResult;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestEngine;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.EngineDescriptor;
import org.junit.platform.launcher.EngineDiscoveryResult;
import org.junit.platform.launcher.LauncherDiscoveryListener;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.PostDiscoveryFilter;
import org.junit.platform.launcher.core.ClasspathAlignmentChecker;
import org.junit.platform.launcher.core.DelegatingLauncherDiscoveryRequest;
import org.junit.platform.launcher.core.DiscoveryIssueCollector;
import org.junit.platform.launcher.core.DiscoveryIssueException;
import org.junit.platform.launcher.core.DiscoveryIssueNotifier;
import org.junit.platform.launcher.core.EngineDiscoveryResultValidator;
import org.junit.platform.launcher.core.EngineFilterer;
import org.junit.platform.launcher.core.EngineIdValidator;
import org.junit.platform.launcher.core.LauncherDiscoveryResult;
import org.junit.platform.launcher.core.LauncherPhase;
import org.junit.platform.launcher.core.ListenerRegistry;

@API(status=API.Status.INTERNAL, since="1.7", consumers={"org.junit.platform.testkit", "org.junit.platform.suite.engine"})
public class EngineDiscoveryOrchestrator {
    private static final Logger logger = LoggerFactory.getLogger(EngineDiscoveryOrchestrator.class);
    private final EngineDiscoveryResultValidator discoveryResultValidator = new EngineDiscoveryResultValidator();
    private final Iterable<TestEngine> testEngines;
    private final Collection<PostDiscoveryFilter> postDiscoveryFilters;
    private final ListenerRegistry<LauncherDiscoveryListener> launcherDiscoveryListenerRegistry;

    public EngineDiscoveryOrchestrator(Iterable<TestEngine> testEngines, Collection<PostDiscoveryFilter> postDiscoveryFilters) {
        this(testEngines, postDiscoveryFilters, ListenerRegistry.forLauncherDiscoveryListeners());
    }

    EngineDiscoveryOrchestrator(Iterable<TestEngine> testEngines, Collection<PostDiscoveryFilter> postDiscoveryFilters, ListenerRegistry<LauncherDiscoveryListener> launcherDiscoveryListenerRegistry) {
        this.testEngines = EngineIdValidator.validate(testEngines);
        this.postDiscoveryFilters = postDiscoveryFilters;
        this.launcherDiscoveryListenerRegistry = launcherDiscoveryListenerRegistry;
    }

    public LauncherDiscoveryResult discover(LauncherDiscoveryRequest request) {
        return this.discover(request, Optional.empty(), UniqueId::forEngine);
    }

    LauncherDiscoveryResult discover(LauncherDiscoveryRequest request, LauncherPhase phase) {
        return this.discover(request, Optional.of(phase), UniqueId::forEngine);
    }

    public LauncherDiscoveryResult discover(LauncherDiscoveryRequest request, UniqueId parentId) {
        LauncherDiscoveryResult result = this.discover(request, Optional.empty(), parentId::appendEngine);
        return result.withRetainedEngines(TestDescriptor::containsTests);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LauncherDiscoveryResult discover(LauncherDiscoveryRequest request, Optional<LauncherPhase> phase, Function<String, UniqueId> uniqueIdCreator) {
        LauncherDiscoveryResult discoveryResult;
        DiscoveryIssueCollector issueCollector = new DiscoveryIssueCollector(request.getConfigurationParameters());
        final LauncherDiscoveryListener listener = this.getLauncherDiscoveryListener(request, issueCollector);
        DelegatingLauncherDiscoveryRequest delegatingRequest = new DelegatingLauncherDiscoveryRequest(request){

            @Override
            public LauncherDiscoveryListener getDiscoveryListener() {
                return listener;
            }
        };
        listener.launcherDiscoveryStarted(request);
        try {
            Map<TestEngine, LauncherDiscoveryResult.EngineResultInfo> testEngineResults = this.discoverSafely(delegatingRequest, phase, issueCollector, uniqueIdCreator);
            discoveryResult = new LauncherDiscoveryResult(testEngineResults, request.getConfigurationParameters(), request.getOutputDirectoryCreator());
        }
        finally {
            listener.launcherDiscoveryFinished(request);
        }
        if (EngineDiscoveryOrchestrator.shouldReportDiscoveryIssues(request, phase)) {
            EngineDiscoveryOrchestrator.reportDiscoveryIssues(discoveryResult);
        }
        return discoveryResult;
    }

    private static boolean shouldReportDiscoveryIssues(LauncherDiscoveryRequest request, Optional<LauncherPhase> phase) {
        ConfigurationParameters configurationParameters = request.getConfigurationParameters();
        return LauncherPhase.getDiscoveryIssueFailurePhase(configurationParameters).orElse(phase.orElse(null)) == LauncherPhase.DISCOVERY;
    }

    private static void reportDiscoveryIssues(LauncherDiscoveryResult discoveryResult) {
        DiscoveryIssueException exception = null;
        for (TestEngine testEngine : discoveryResult.getTestEngines()) {
            LauncherDiscoveryResult.EngineResultInfo engineResult = discoveryResult.getEngineResult(testEngine);
            DiscoveryIssueNotifier discoveryIssueNotifier = engineResult.getDiscoveryIssueNotifier();
            discoveryIssueNotifier.logCriticalIssues(testEngine);
            discoveryIssueNotifier.logNonCriticalIssues(testEngine);
            if (exception != null) continue;
            exception = discoveryIssueNotifier.createExceptionForCriticalIssues(testEngine);
        }
        if (exception != null) {
            throw exception;
        }
    }

    private Map<TestEngine, LauncherDiscoveryResult.EngineResultInfo> discoverSafely(LauncherDiscoveryRequest request, Optional<LauncherPhase> phase, DiscoveryIssueCollector issueCollector, Function<String, UniqueId> uniqueIdCreator) {
        LinkedHashMap<TestEngine, LauncherDiscoveryResult.EngineResultInfo> testEngineDescriptors = new LinkedHashMap<TestEngine, LauncherDiscoveryResult.EngineResultInfo>();
        EngineFilterer engineFilterer = new EngineFilterer(request.getEngineFilters());
        for (TestEngine testEngine : this.testEngines) {
            boolean engineIsExcluded = engineFilterer.isExcluded(testEngine);
            if (engineIsExcluded) {
                logger.debug(() -> String.format("Test discovery for engine '%s' was skipped due to an EngineFilter%s.", testEngine.getId(), phase.map(it -> String.format(" in %s phase", it)).orElse("")));
                continue;
            }
            logger.debug(() -> String.format("Discovering tests%s in engine '%s'.", phase.map(it -> String.format(" during Launcher %s phase", it)).orElse(""), testEngine.getId()));
            LauncherDiscoveryResult.EngineResultInfo engineResult = this.discoverEngineRoot(testEngine, request, issueCollector, uniqueIdCreator);
            testEngineDescriptors.put(testEngine, engineResult);
        }
        engineFilterer.performSanityChecks();
        LinkedList<PostDiscoveryFilter> filters = new LinkedList<PostDiscoveryFilter>(this.postDiscoveryFilters);
        filters.addAll(request.getPostDiscoveryFilters());
        this.applyPostDiscoveryFilters(testEngineDescriptors, filters);
        this.prune(testEngineDescriptors);
        return testEngineDescriptors;
    }

    private LauncherDiscoveryResult.EngineResultInfo discoverEngineRoot(TestEngine testEngine, LauncherDiscoveryRequest request, DiscoveryIssueCollector issueCollector, Function<String, UniqueId> uniqueIdCreator) {
        UniqueId uniqueEngineId = uniqueIdCreator.apply(testEngine.getId());
        LauncherDiscoveryListener listener = request.getDiscoveryListener();
        try {
            listener.engineDiscoveryStarted(uniqueEngineId);
            TestDescriptor engineRoot = testEngine.discover(request, uniqueEngineId);
            this.discoveryResultValidator.validate(testEngine, engineRoot);
            listener.engineDiscoveryFinished(uniqueEngineId, EngineDiscoveryResult.successful());
            return LauncherDiscoveryResult.EngineResultInfo.completed(engineRoot, issueCollector.toNotifier());
        }
        catch (Throwable throwable) {
            UnrecoverableExceptions.rethrowIfUnrecoverable(throwable);
            JUnitException cause = null;
            if (throwable instanceof LinkageError) {
                cause = ClasspathAlignmentChecker.check((LinkageError)throwable).orElse(null);
            }
            if (cause == null) {
                String message = String.format("TestEngine with ID '%s' failed to discover tests", testEngine.getId());
                cause = new JUnitException(message, throwable);
            }
            listener.engineDiscoveryFinished(uniqueEngineId, EngineDiscoveryResult.failed(cause));
            return LauncherDiscoveryResult.EngineResultInfo.errored(new EngineDescriptor(uniqueEngineId, testEngine.getId()), issueCollector.toNotifier(), cause);
        }
    }

    LauncherDiscoveryListener getLauncherDiscoveryListener(LauncherDiscoveryRequest discoveryRequest, DiscoveryIssueCollector issueCollector) {
        return ListenerRegistry.copyOf(this.launcherDiscoveryListenerRegistry).add(discoveryRequest.getDiscoveryListener()).add(issueCollector).getCompositeListener();
    }

    private void applyPostDiscoveryFilters(Map<TestEngine, LauncherDiscoveryResult.EngineResultInfo> testEngineDescriptors, List<PostDiscoveryFilter> filters) {
        Filter postDiscoveryFilter = Filter.composeFilters(filters);
        LinkedHashMap<String, List<TestDescriptor>> excludedTestDescriptorsByReason = new LinkedHashMap<String, List<TestDescriptor>>();
        TestDescriptor.Visitor removeExcludedTestDescriptors = descriptor -> {
            FilterResult filterResult = postDiscoveryFilter.apply(descriptor);
            if (!descriptor.isRoot() && this.isExcluded(descriptor, filterResult)) {
                this.populateExclusionReasonInMap(filterResult.getReason(), descriptor, excludedTestDescriptorsByReason);
                descriptor.removeFromHierarchy();
            }
        };
        this.acceptInAllTestEngines(testEngineDescriptors, removeExcludedTestDescriptors);
        this.logTestDescriptorExclusionReasons(excludedTestDescriptorsByReason);
    }

    private void populateExclusionReasonInMap(Optional<String> reason, TestDescriptor testDescriptor, Map<String, List<TestDescriptor>> excludedTestDescriptorsByReason) {
        excludedTestDescriptorsByReason.computeIfAbsent(reason.orElse("Unknown"), list -> new LinkedList()).add(testDescriptor);
    }

    private void logTestDescriptorExclusionReasons(Map<String, List<TestDescriptor>> excludedTestDescriptorsByReason) {
        excludedTestDescriptorsByReason.forEach((exclusionReason, testDescriptors) -> {
            String displayNames = testDescriptors.stream().map(TestDescriptor::getDisplayName).collect(Collectors.joining(", "));
            long containerCount = testDescriptors.stream().filter(TestDescriptor::isContainer).count();
            long methodCount = testDescriptors.stream().filter(TestDescriptor::isTest).count();
            logger.config(() -> String.format("%d containers and %d tests were %s", containerCount, methodCount, exclusionReason));
            logger.debug(() -> String.format("The following containers and tests were %s: %s", exclusionReason, displayNames));
        });
    }

    private void prune(Map<TestEngine, LauncherDiscoveryResult.EngineResultInfo> testEngineResults) {
        this.acceptInAllTestEngines(testEngineResults, TestDescriptor::prune);
    }

    private boolean isExcluded(TestDescriptor descriptor, FilterResult filterResult) {
        return descriptor.getChildren().isEmpty() && filterResult.excluded();
    }

    private void acceptInAllTestEngines(Map<TestEngine, LauncherDiscoveryResult.EngineResultInfo> testEngineResults, TestDescriptor.Visitor visitor) {
        testEngineResults.values().forEach(result -> result.getRootDescriptor().accept(visitor));
    }
}

