/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.asmutils;

import java.util.List;

public class HexUtils {
    private static final String hexString = "0123456789ABCDEF";
    private static final char[] hexTable = "0123456789ABCDEF".toCharArray();

    public static String toHex(long val, int width) {
        StringBuffer sb = new StringBuffer();
        for (int i = width - 1; i >= 0; --i) {
            sb.append(hexTable[(int)(val >> 4 * i) & 0xF]);
        }
        String s = sb.toString();
        return "0x" + (s.isEmpty() ? "0" : s);
    }

    public static String toHex(byte val) {
        int width;
        for (width = 2; width > 0 && val >> (width - 1) * 4 == 0; --width) {
        }
        return HexUtils.toHex(val, width);
    }

    public static String toHex(long val) {
        int width;
        for (width = 16; width > 0 && val >> (width - 1) * 4 == 0L; --width) {
        }
        return HexUtils.toHex(val, width);
    }

    public static String toHex(int val) {
        int width;
        for (width = 8; width > 0 && val >> (width - 1) * 4 == 0; --width) {
        }
        return HexUtils.toHex(val, width);
    }

    public static byte[] toByteArray(List<Byte> byteList) {
        int length = byteList.size();
        byte[] array = new byte[length];
        for (int i = 0; i < length; ++i) {
            array[i] = byteList.get(i);
        }
        return array;
    }
}

