/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.common;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.openjdk.asmtools.common.ILogger;
import org.openjdk.asmtools.common.ToolLogger;
import org.openjdk.asmtools.common.inputs.ToolInput;
import org.openjdk.asmtools.common.outputs.ToolOutput;
import org.openjdk.asmtools.common.outputs.log.DualStreamToolOutput;

public abstract class Environment<T extends ToolLogger>
implements ILogger {
    public static final int OK = 0;
    public static final int FAILED = 1;
    T toolLogger;
    private boolean ignorePackage = false;
    private ToolInput toolInput;
    private ToolOutput toolOutput;
    private boolean verboseFlag;
    private boolean traceFlag;

    public boolean isTraceFlag() {
        return this.traceFlag;
    }

    protected Environment(Builder builder) {
        this.toolOutput = builder.toolOutput;
        this.toolLogger = builder.toolLogger;
    }

    public void setToolInput(ToolInput toolInput) throws IOException, URISyntaxException {
        this.toolInput = toolInput;
        ((ToolLogger)this.toolLogger).setInputFileName(toolInput);
    }

    public void setTraceFlag(boolean flag) {
        this.traceFlag = flag;
    }

    public void setIgnoreWarningsOn() {
        ((ToolLogger)this.toolLogger).ignoreWarnings = true;
    }

    public void setStrictWarningsOn() {
        ((ToolLogger)this.toolLogger).strictWarnings = true;
    }

    public boolean isIgnorePackage() {
        return this.ignorePackage;
    }

    public Environment<T> setIgnorePackage(boolean ignorePackage) {
        this.ignorePackage = ignorePackage;
        return this;
    }

    public String getSimpleInputFileName() {
        return ((ToolLogger)this.toolLogger).getSimpleInputFileName();
    }

    public String getSourceName() {
        String sourceFileName = this.getSimpleInputFileName();
        String sourceName = sourceFileName.contains(".") ? sourceFileName.substring(0, sourceFileName.indexOf(46)) : sourceFileName;
        return sourceName;
    }

    public ToolInput getToolInput() {
        return this.toolInput;
    }

    protected DataInputStream getDataInputStream() throws URISyntaxException, IOException {
        Objects.requireNonNull(this.toolInput, "Input must be defined.");
        return this.toolInput.getDataInputStream(Optional.of(this));
    }

    @Override
    public void traceln(String id, Object ... args) {
        if (this.traceFlag) {
            ILogger.super.traceln(id, args);
        }
    }

    public void traceln(Supplier<String> supplier) {
        if (this.traceFlag) {
            ILogger.super.traceln(supplier.get(), new Object[0]);
        }
    }

    @Override
    public void trace(String id, Object ... args) {
        if (this.traceFlag) {
            ILogger.super.trace(id, args);
        }
    }

    @Override
    public void error(String id, Object ... args) {
        this.toolLogger.error(id, args);
    }

    @Override
    public void error(Throwable exception) {
        this.toolLogger.error(exception);
    }

    public void trace(Supplier<String> supplier) {
        if (this.traceFlag) {
            ILogger.super.trace(supplier.get(), new Object[0]);
        }
    }

    @Override
    public void info(String id, Object ... args) {
        this.toolLogger.info(id, args);
    }

    @Override
    public String getInfo(String id, Object ... args) {
        return this.toolLogger.getInfo(id, args);
    }

    public void usage(List<String> ids) {
        ((ToolLogger)this.toolLogger).usage(ids);
    }

    public void usage(List<String> ids, Function<String, String> func) {
        ((ToolLogger)this.toolLogger).usage(ids, func);
    }

    @Override
    public void printException(Throwable throwable) {
        if (this.verboseFlag) {
            ((ToolLogger)this.toolLogger).printException(throwable);
        }
    }

    @Override
    public DualStreamToolOutput getOutputs() {
        return ((ToolLogger)this.getLogger()).getOutputs();
    }

    @Override
    public void setOutputs(DualStreamToolOutput nw) {
        ((ToolLogger)this.getLogger()).setOutputs(nw);
    }

    @Override
    public ToolOutput getToolOutput() {
        return this.toolOutput;
    }

    @Override
    public void setToolOutput(ToolOutput toolOutput) {
        this.toolOutput = toolOutput;
    }

    public boolean getVerboseFlag() {
        return this.verboseFlag;
    }

    public Environment setVerboseFlag(boolean value) {
        this.verboseFlag = value;
        return this;
    }

    public T getLogger() {
        return this.toolLogger;
    }

    public static abstract class Builder<E extends Environment, T extends ToolLogger> {
        T toolLogger;
        public ToolOutput toolOutput;

        public Builder(ToolOutput toolOutput, T toolLogger) {
            this.toolOutput = toolOutput;
            this.toolLogger = toolLogger;
        }

        public abstract E build();
    }
}

