/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.common;

import java.io.File;
import java.util.ArrayList;
import org.openjdk.asmtools.common.Environment;
import org.openjdk.asmtools.common.NotImplementedException;
import org.openjdk.asmtools.common.ToolLogger;
import org.openjdk.asmtools.common.inputs.StdinInput;
import org.openjdk.asmtools.common.inputs.ToolInput;
import org.openjdk.asmtools.common.outputs.FSOutput;
import org.openjdk.asmtools.common.outputs.ToolOutput;
import org.openjdk.asmtools.common.outputs.log.DualStreamToolOutput;

public abstract class Tool<T extends Environment<? extends ToolLogger>> {
    protected final ArrayList<ToolInput> fileList = new ArrayList();
    protected T environment;
    private ToolOutput toolOutput;

    protected Tool(ToolOutput toolOutput, DualStreamToolOutput outerLog) {
        this.environment = this.getEnvironment(toolOutput, outerLog);
    }

    public Environment<?> setVerboseFlag(boolean value) {
        ((Environment)this.environment).setVerboseFlag(value);
        return this.environment;
    }

    public Environment<?> setTraceFlag(boolean value) {
        ((Environment)this.environment).setTraceFlag(value);
        return this.environment;
    }

    public T getEnvironment() {
        return this.environment;
    }

    public T getEnvironment(ToolOutput toolOutput, DualStreamToolOutput outerLog) {
        throw new NotImplementedException();
    }

    protected abstract void usage();

    protected abstract void parseArgs(String ... var1);

    protected void setFSDestination(FSOutput.FSDestination destination, int index, String ... argv) {
        if (index >= argv.length) {
            ((Environment)this.environment).error(destination == FSOutput.FSDestination.FILE ? "err.f_requires_argument" : "err.d_requires_argument", new Object[0]);
            this.usage();
            throw new IllegalArgumentException();
        }
        String fname = argv[index];
        File file = new File(fname);
        if (destination == FSOutput.FSDestination.DIR && !file.exists()) {
            ((Environment)this.environment).error("err.does_not_exist", fname);
            throw new IllegalArgumentException();
        }
        if (this.toolOutput == null) {
            this.toolOutput = new FSOutput();
        }
        switch (destination) {
            case FILE: {
                ((Environment)this.environment).setToolOutput(((FSOutput)this.toolOutput).setFile(new File("."), fname));
                break;
            }
            case DIR: {
                ((Environment)this.environment).setToolOutput(((FSOutput)this.toolOutput).setDir(file));
            }
        }
    }

    protected void addStdIn() {
        for (ToolInput toolInput : this.fileList) {
            if (!(toolInput instanceof StdinInput)) continue;
            return;
        }
        this.fileList.add(new StdinInput());
    }
}

