/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.common.inputs;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import org.openjdk.asmtools.common.Environment;
import org.openjdk.asmtools.common.inputs.ToolInput;

public class ByteInput
implements ToolInput {
    private boolean detailedInput = false;
    private MessageDigest md = null;
    protected byte[] bytes;

    public ByteInput(byte[] bytes) {
        this.bytes = bytes;
    }

    protected ByteInput() {
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    @Override
    public ByteInput setDetailedInput(boolean detailedInput) {
        this.detailedInput = detailedInput;
        return this;
    }

    @Override
    public MessageDigest getMessageDigest() {
        return this.md;
    }

    @Override
    public int getSize() {
        return this.bytes.length;
    }

    @Override
    public String getName() {
        return "bytes/bytes";
    }

    public String toString() {
        return this.getName();
    }

    protected void init() {
    }

    @Override
    public DataInputStream getDataInputStream(Optional<Environment> logger) {
        this.init();
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(this.bytes);
            if (this.detailedInput) {
                this.md = MessageDigest.getInstance("SHA-256");
                DigestInputStream dis = new DigestInputStream(bais, this.md);
                return new DataInputStream(dis);
            }
            return new DataInputStream(bais);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Collection<String> readAllLines() throws IOException {
        this.init();
        ArrayList<String> resultingLines = new ArrayList<String>();
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(this.bytes), "utf-8"));){
            String l;
            while ((l = br.readLine()) != null) {
                resultingLines.add(l);
            }
        }
        return resultingLines;
    }
}

