/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.common.inputs;

import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Optional;
import org.openjdk.asmtools.common.Environment;
import org.openjdk.asmtools.common.inputs.ToolInput;

public class FileInput
implements ToolInput {
    private boolean detailedInput = false;
    private final String fileName;
    private MessageDigest md = null;
    private CapacityInputStream cis = null;

    public FileInput(String fileName) {
        this.fileName = fileName;
    }

    @Override
    public String getName() {
        return this.fileName;
    }

    @Override
    public Collection<String> readAllLines() throws IOException {
        return Files.readAllLines(Paths.get(this.getName(), new String[0]));
    }

    @Override
    public FileInput setDetailedInput(boolean detailedInput) {
        this.detailedInput = detailedInput;
        return this;
    }

    @Override
    public MessageDigest getMessageDigest() {
        return this.md;
    }

    @Override
    public int getSize() {
        return this.cis != null ? this.cis.size() : 0;
    }

    @Override
    public DataInputStream getDataInputStream(Optional<Environment> logger) throws URISyntaxException, IOException {
        try {
            FileInputStream fis = new FileInputStream(this.getName());
            if (this.detailedInput) {
                this.cis = new CapacityInputStream(fis);
                this.md = MessageDigest.getInstance("SHA-256");
                DigestInputStream dis = new DigestInputStream(this.cis, this.md);
                return new DataInputStream(dis);
            }
            return new DataInputStream(fis);
        }
        catch (IOException ex) {
            if (this.getName().matches("^[A-Za-z]+:.*")) {
                try {
                    URI uri = new URI(this.getName());
                    URL url = uri.toURL();
                    URLConnection conn = url.openConnection();
                    conn.setUseCaches(false);
                    return new DataInputStream(conn.getInputStream());
                }
                catch (IOException | URISyntaxException exception) {
                    if (logger.isPresent()) {
                        logger.get().error("err.cannot.read", this.getName());
                    }
                    throw exception;
                }
            }
            throw ex;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return this.getName();
    }

    private static class CapacityInputStream
    extends FilterInputStream {
        private int size;

        CapacityInputStream(InputStream in) {
            super(in);
        }

        int size() {
            return this.size;
        }

        @Override
        public int read(byte[] buf, int offset, int length) throws IOException {
            int n = super.read(buf, offset, length);
            if (n > 0) {
                this.size += n;
            }
            return n;
        }

        @Override
        public int read() throws IOException {
            int b = super.read();
            ++this.size;
            return b;
        }
    }
}

