/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.common.outputs;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Optional;
import java.util.stream.Collectors;
import org.openjdk.asmtools.common.Environment;
import org.openjdk.asmtools.common.outputs.NamedToolOutput;

public class ByteOutput
extends NamedToolOutput {
    private final ArrayList<NamedBinary> outputs = new ArrayList();
    private ByteArrayOutputStream currentClass;

    public ArrayList<NamedBinary> getOutputs() {
        return this.outputs;
    }

    public String toString() {
        return this.outputs.stream().map(a -> a.toString()).collect(Collectors.joining(System.lineSeparator()));
    }

    @Override
    public DataOutputStream getDataOutputStream() throws FileNotFoundException {
        return new DataOutputStream(this.currentClass);
    }

    @Override
    public void startClass(String fullyQualifiedName, Optional<String> suffix, Environment logger) throws IOException {
        super.startClass(fullyQualifiedName, suffix, logger);
        this.currentClass = new ByteArrayOutputStream(1024);
    }

    @Override
    public void finishClass(String fullyQualifiedName) throws IOException {
        String fqn = this.getCurrentClassName();
        if (fqn != null && !fqn.equals(fullyQualifiedName)) {
            throw new RuntimeException("Ended different class: %s then was started %s".formatted(fullyQualifiedName, fqn));
        }
        if (this.currentClass != null) {
            this.outputs.add(new NamedBinary(fullyQualifiedName, this.currentClass.toByteArray()));
        }
        super.finishClass(fullyQualifiedName);
        this.currentClass = null;
    }

    @Override
    public void printlns(String line) {
        try {
            this.currentClass.write((line + System.lineSeparator()).getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void prints(String line) {
        try {
            this.currentClass.write(line.getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void prints(char line) {
        this.currentClass.write(line);
    }

    @Override
    public void flush() {
    }

    @Override
    public String getName() {
        return "byte stream";
    }

    public class NamedBinary {
        private final String fqn;
        private final byte[] body;

        public NamedBinary(String fqn, byte[] body) {
            this.fqn = fqn;
            this.body = body;
        }

        public String getFqn() {
            return this.fqn;
        }

        public byte[] getBody() {
            return this.body;
        }

        public String toString() {
            return this.fqn + ": " + this.body.length + "b";
        }
    }
}

