/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.common.structure;

import org.openjdk.asmtools.common.structure.ClassFileContext;
import org.openjdk.asmtools.common.structure.EModifier;

public class CFVersion {
    public static final int DEFAULT_MAJOR_VERSION = 45;
    public static final int DEFAULT_MINOR_VERSION = 3;
    public static final int DEFAULT_MODULE_MAJOR_VERSION = 53;
    public static final int DEFAULT_MODULE_MINOR_VERSION = 0;
    public static final int UNDEFINED_VERSION = -1;
    public static final int SPLIT_VERIFIER_CFV = 50;
    public static final int VALUE_OBJECTS_MAJOR_VERSION = 69;
    public static final int VALUE_OBJECTS_MINOR_VERSION = 65535;
    private int major_version;
    private int minor_version;
    private int threshold_major_version;
    private int threshold_minor_version;
    private boolean frozen;
    private boolean isSetByParameter;

    public CFVersion() {
        this.setVersion(-1, -1);
        this.threshold_major_version = -1;
        this.threshold_minor_version = -1;
        EModifier.setGlobalContext(ClassFileContext.ORDINARY);
        this.isSetByParameter = false;
        this.frozen = false;
    }

    public CFVersion(CFVersion other) {
        this.setVersion(other.major_version, other.minor_version);
        this.threshold_major_version = other.threshold_major_version;
        this.threshold_minor_version = other.threshold_minor_version;
        this.isSetByParameter = other.isSetByParameter;
        if (this.isValueObjectContext()) {
            EModifier.setGlobalContext(ClassFileContext.VALUE_OBJECTS);
        } else {
            EModifier.setGlobalContext(ClassFileContext.ORDINARY);
        }
        this.frozen = other.frozen;
    }

    public CFVersion(int major_version, int minor_version) {
        this.major_version = major_version;
        this.minor_version = minor_version;
        if (this.isValueObjectContext()) {
            EModifier.setGlobalContext(ClassFileContext.VALUE_OBJECTS);
        } else {
            EModifier.setGlobalContext(ClassFileContext.ORDINARY);
        }
    }

    public CFVersion setFrozen(boolean frozen) {
        this.frozen = frozen;
        return this;
    }

    public CFVersion setThreshold(int major_version, int minor_version) {
        this.threshold_major_version = major_version;
        this.threshold_minor_version = minor_version;
        return this;
    }

    public CFVersion setVersion(int major_version, int minor_version) {
        this.major_version = major_version;
        this.minor_version = minor_version;
        if (this.isValueObjectContext()) {
            EModifier.setGlobalContext(ClassFileContext.VALUE_OBJECTS);
        }
        return this;
    }

    public CFVersion setFileVersion(int major_version, int minor_version) {
        if (this.isSet() && this.isFrozen()) {
            if (this.isThresholdSet()) {
                if (major_version < this.threshold_major_version || major_version == this.threshold_major_version && minor_version < this.threshold_minor_version) {
                    return this;
                }
            } else {
                return this;
            }
        }
        return this.setVersion(major_version, minor_version);
    }

    public CFVersion setMajorVersion(int major_version) {
        if (!this.frozen) {
            this.setVersion(major_version, this.minor_version);
        }
        return this;
    }

    public CFVersion setMinorVersion(int minor_version) {
        if (!this.frozen) {
            this.setVersion(this.major_version, minor_version);
        }
        return this;
    }

    public CFVersion setByParameter(boolean parameter) {
        this.isSetByParameter = parameter;
        return this;
    }

    public boolean isSet() {
        return this.major_version != -1 && this.minor_version != -1;
    }

    public boolean isThresholdSet() {
        return this.threshold_major_version != -1 && this.threshold_minor_version != -1;
    }

    public boolean isSetByParameter() {
        return this.isSetByParameter;
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public String asString() {
        return String.format("%s:%s", this.major_version == -1 ? "(undef)" : Integer.valueOf(this.major_version), this.minor_version == -1 ? "(undef)" : Integer.valueOf(this.minor_version));
    }

    public String asThresholdString() {
        return String.format("%s:%s-%s:%s", this.threshold_major_version == -1 ? "(undef)" : Integer.valueOf(this.threshold_major_version), this.threshold_minor_version == -1 ? "(undef)" : Integer.valueOf(this.threshold_minor_version), this.major_version == -1 ? "(undef)" : Integer.valueOf(this.major_version), this.minor_version == -1 ? "(undef)" : Integer.valueOf(this.minor_version));
    }

    public boolean isTypeCheckingVerifier() {
        return this.isSet() ? this.major_version >= 50 : false;
    }

    public CFVersion initModuleDefaultVersion() {
        if (!this.isSet()) {
            this.setVersion(53, 0);
        }
        return this;
    }

    public CFVersion initClassDefaultVersion() {
        if (!this.isSet()) {
            if (EModifier.GlobalContext() == ClassFileContext.VALUE_OBJECTS) {
                this.setVersion(69, 65535);
            } else {
                this.setVersion(45, 3);
            }
        }
        return this;
    }

    public static CFVersion copyOf(CFVersion cfv) {
        CFVersion cfVersion = new CFVersion(cfv);
        return cfVersion;
    }

    public int minor_version() {
        return this.minor_version;
    }

    public int major_version() {
        return this.major_version;
    }

    public boolean isValueObjectContext() {
        return this.major_version > 69 || this.major_version == 69 && this.minor_version == 65535;
    }

    public static boolean isValueObjectContext(int major_version, int minor_version) {
        return major_version > 69 || major_version == 69 && minor_version == 65535;
    }

    public static CFVersion ValueObjectsVersion() {
        return new CFVersion(69, 65535);
    }

    public boolean isSyntheticAttributeContext() {
        return this.major_version <= 45;
    }
}

