/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.common.structure;

import org.openjdk.asmtools.common.structure.EModifier;

public enum ClassFileContext {
    NONE(0, "n/a", false),
    CLASS(1, "class", false),
    FIELD(2, "field", false),
    METHOD(4, "method", false),
    INNER_CLASS(8, "inner-class", false),
    MODULE(16, "module", false),
    REQUIRES(32, "requires", false),
    EXPORTS(64, "exports", false),
    OPENS(128, "opens", false),
    METHOD_PARAMETERS(256, "method parameters", false),
    MODULE_DIRECTIVES(224, "module directives", false),
    ORDINARY(512, "ordinary", true),
    VALUE_OBJECTS(512, "value classes and objects", true);

    private final int id;
    private final String printVal;
    private final boolean globalContext;

    private ClassFileContext(int id, String print, boolean globalContext) {
        this.id = id;
        this.printVal = print;
        this.globalContext = globalContext;
    }

    public int getID() {
        return this.id;
    }

    public String getName() {
        return this.printVal;
    }

    public boolean isGlobal() {
        return this.globalContext;
    }

    public boolean isOneOf(ClassFileContext ... contexts) {
        for (ClassFileContext cfc : contexts) {
            if ((cfc.id & this.id) == 0) continue;
            return true;
        }
        return false;
    }

    public boolean belongToContextOf(EModifier modifier) {
        return (this.id & modifier.getAllovedContextMask()) != 0;
    }
}

