/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.common.structure;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.openjdk.asmtools.asmutils.FormatConsumer;
import org.openjdk.asmtools.asmutils.Range;

public class StackMap {
    public static VerificationType getVerificationType(int verificationTypeID, Optional<FormatConsumer<String, Object>> errorConsumer) {
        if (VerificationType.isValidVerificationType(verificationTypeID)) {
            return VerificationType.get(verificationTypeID);
        }
        errorConsumer.ifPresent(c -> c.format("error.stackmap.unknown.type", verificationTypeID));
        return VerificationType.ITEM_UNKNOWN;
    }

    public static VerificationType getVerificationType(String printName) {
        return VerificationType.getByPrintName(printName);
    }

    public static EntryType stackMapEntryType(int tag) {
        EntryType entryType = EntryType.getByTag(tag);
        return entryType;
    }

    public static int getFrameTypeTagByName(String frameTypeName) {
        return EntryType.getByTagName(frameTypeName).fromTag();
    }

    public static EntryType getEntryTypeByName(String entryTypeName) {
        return EntryType.getByTagName(entryTypeName);
    }

    public static boolean isValidEntryType(int tag) {
        return EntryType.isValid(tag);
    }

    public static enum VerificationType {
        ITEM_UNKNOWN(-1, "??? Unknown verification type", "UNKNOWN"),
        ITEM_Bogus(0, "bogus", "B"),
        ITEM_Integer(1, "int", "I"),
        ITEM_Float(2, "float", "F"),
        ITEM_Double(3, "double", "D"),
        ITEM_Long(4, "long", "L"),
        ITEM_Null(5, "null", "N"),
        ITEM_InitObject(6, "this", "IO"),
        ITEM_Object(7, "CP", "O"),
        ITEM_NewObject(8, "at", "NO");

        private static HashMap<String, VerificationType> printNameToType;
        private static HashMap<String, VerificationType> parseKeyToType;
        private static HashMap<Integer, VerificationType> tagToType;
        private final String printName;
        private final String parseKey;
        private Integer tag;

        private VerificationType(Integer tag, String printName, String parseKey) {
            this.tag = tag;
            this.printName = printName;
            this.parseKey = parseKey;
        }

        static boolean isValidVerificationType(int tag) {
            return tag >= VerificationType.ITEM_Bogus.tag && tag <= VerificationType.ITEM_NewObject.tag;
        }

        public static VerificationType getByPrintName(String printName) {
            if (printNameToType == null) {
                printNameToType = (HashMap)Arrays.stream(VerificationType.values()).collect(Collectors.toMap(VerificationType::printName, Function.identity()));
            }
            return printNameToType.get(printName);
        }

        public static VerificationType getByParseKey(String parseKey) {
            VerificationType verificationType;
            if (parseKeyToType == null) {
                parseKeyToType = (HashMap)Arrays.stream(VerificationType.values()).collect(Collectors.toMap(VerificationType::parseKey, Function.identity()));
            }
            return (verificationType = parseKeyToType.get(parseKey)) == null ? ITEM_UNKNOWN : verificationType;
        }

        public static VerificationType get(int tag) {
            if (tagToType == null) {
                tagToType = (HashMap)Arrays.stream(VerificationType.values()).collect(Collectors.toMap(VerificationType::tag, Function.identity()));
            }
            return tagToType.get(tag);
        }

        public String parseKey() {
            return this.parseKey;
        }

        public String printName() {
            return this.printName;
        }

        public Integer tag() {
            return this.tag;
        }
    }

    public static enum EntryType {
        UNKNOWN_TYPE(-1, -1, "unknown", false, false, false),
        SAME_FRAME(0, 63, "same", false, false, false),
        SAME_LOCALS_1_STACK_ITEM_FRAME(64, 127, "stack1", false, true, false),
        RESERVED(128, 245, "reserved", false, false, false),
        EARLY_LARVAL(246, 246, "early_larval", false, false, true),
        SAME_LOCALS_1_STACK_ITEM_FRAME_EXTENDED(247, 247, "stack1_ex", false, true, false),
        CHOP_1_FRAME(250, 250, "chop1", false, false, false),
        CHOP_2_FRAME(249, 249, "chop2", false, false, false),
        CHOP_3_FRAME(248, 248, "chop3", false, false, false),
        SAME_FRAME_EXTENDED(251, 251, "same_ex", false, false, false),
        APPEND_FRAME(252, 254, "append", true, false, false),
        FULL_FRAME(255, 255, "full", true, true, false);

        private static HashMap<String, EntryType> tagNameToFrameType;
        private final Range<Integer> tagRange;
        private final String tagName;
        private final boolean localMap;
        private final boolean stackMap;
        private final boolean fields;

        private EntryType(int from, int to, String tagName, boolean localMap, boolean stackMap, boolean fields) {
            this.tagRange = new Range<Integer>(from, to);
            this.tagName = tagName;
            this.localMap = localMap;
            this.stackMap = stackMap;
            this.fields = fields;
        }

        public boolean hasLocalMap() {
            return this.localMap;
        }

        public boolean hasStackMap() {
            return this.stackMap;
        }

        public boolean hasFields() {
            return this.fields;
        }

        public static EntryType getByTagName(String tagName) {
            EntryType type;
            if (tagNameToFrameType == null) {
                tagNameToFrameType = (HashMap)Arrays.stream(EntryType.values()).collect(Collectors.toMap(EntryType::tagName, Function.identity()));
            }
            return (type = tagNameToFrameType.get(tagName)) == null ? UNKNOWN_TYPE : type;
        }

        public static EntryType getByTag(int tag) {
            for (EntryType type : EntryType.values()) {
                if (!type.inRange(tag)) continue;
                return type;
            }
            return UNKNOWN_TYPE;
        }

        public int fromTag() {
            return this.tagRange.from();
        }

        public String tagName() {
            return this.tagName;
        }

        public String printName() {
            String buf = this.name().toLowerCase().replace("_frame", "");
            return buf.startsWith("chop") ? this.tagName : buf;
        }

        public boolean inRange(int tag) {
            return this.tagRange.in(tag);
        }

        public static boolean isValid(int tag) {
            for (EntryType entryType : Set.of(UNKNOWN_TYPE, RESERVED)) {
                if (!entryType.inRange(tag)) continue;
                return false;
            }
            return true;
        }
    }
}

