/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jasm;

import java.io.PrintWriter;
import java.util.HashMap;

public final class ClassFileConst {
    public static final int JAVA_MAGIC = -889275714;
    private static final HashMap<String, SubTag> NameToSubTag = new HashMap(9);
    private static final HashMap<Integer, SubTag> SubTags = new HashMap(9);
    private static final HashMap<String, BasicType> NameToBasicType = new HashMap(10);
    private static final HashMap<Integer, BasicType> BasicTypes = new HashMap(10);
    private static final HashMap<Character, AnnotationElementType> AnnotationElementTypes = new HashMap(10);
    private static final HashMap<String, ConstType> NameToConstantType = new HashMap(20);
    private static final HashMap<String, ConstType> BSMArgumentNameToConstantType = new HashMap(20);
    private static final HashMap<Integer, ConstType> ConstantTypes = new HashMap(20);

    public static ConstType getByTag(int i) {
        ConstType constType = ConstantTypes.get(i);
        return constType == null ? ConstType.CONSTANT_UNKNOWN : constType;
    }

    public static ConstType getByParseKey(String parseKey) {
        return NameToConstantType.get(parseKey);
    }

    public static ConstType getBSMArgumentTypeByParseKey(String parseKey) {
        return BSMArgumentNameToConstantType.get(parseKey);
    }

    private static void registerConstantType(ConstType constType) {
        NameToConstantType.put(constType.parseKey, constType);
        if (constType.isBsmType) {
            BSMArgumentNameToConstantType.put(constType.parseKey, constType);
        }
        if (!ConstantTypes.containsKey(constType.tag)) {
            ConstantTypes.put(constType.tag, constType);
        }
    }

    private static void registerSubtag(SubTag tg) {
        NameToSubTag.put(tg.printValue, tg);
        SubTags.put(tg.value, tg);
    }

    public static SubTag subTag(String subtag) {
        return NameToSubTag.get(subtag);
    }

    public static SubTag subTag(int subtag) {
        return SubTags.get(subtag);
    }

    private static void registerBasicType(BasicType basicType) {
        NameToBasicType.put(basicType.printValue, basicType);
        BasicTypes.put(basicType.value, basicType);
    }

    public static BasicType getBasicType(String idValue) {
        return NameToBasicType.get(idValue);
    }

    public static BasicType getBasicType(int subtag) {
        return BasicTypes.get(subtag);
    }

    public static int basicTypeValue(String idValue) {
        int retval = -1;
        BasicType tg = NameToBasicType.get(idValue);
        if (tg != null) {
            retval = tg.value;
        }
        return retval;
    }

    private static void registerAnnotationElementType(AnnotationElementType annotationElementType) {
        AnnotationElementTypes.put(Character.valueOf(annotationElementType.value.charAt(0)), annotationElementType);
    }

    public static AnnotationElementType getAnnotationElementType(char subTag) {
        AnnotationElementType elementType = AnnotationElementTypes.get(Character.valueOf(subTag));
        if (elementType == null) {
            elementType = AnnotationElementType.AE_UNKNOWN;
        }
        return elementType;
    }

    static {
        for (ConstType constType : ConstType.values()) {
            ClassFileConst.registerConstantType(constType);
        }
        for (Enum enum_ : SubTag.values()) {
            ClassFileConst.registerSubtag((SubTag)enum_);
        }
        for (Enum enum_ : BasicType.values()) {
            ClassFileConst.registerBasicType((BasicType)enum_);
        }
        for (Enum enum_ : AnnotationElementType.values()) {
            ClassFileConst.registerAnnotationElementType((AnnotationElementType)enum_);
        }
    }

    public static enum ConstType {
        CONSTANT_UNKNOWN(-1, "CONSTANT_UNKNOWN", "", AnnotationElementType.AE_NOT_APPLICABLE, false),
        CONSTANT_ZERO(0, "CONSTANT_ZERO", "", AnnotationElementType.AE_NOT_APPLICABLE, false),
        CONSTANT_UTF8(1, "CONSTANT_UTF8", "Utf8", AnnotationElementType.AE_STRING, true),
        CONSTANT_ASCIZ(1, "CONSTANT_UTF8", "Asciz", AnnotationElementType.AE_STRING, true),
        CONSTANT_INTEGER(3, "CONSTANT_INTEGER", "Integer", AnnotationElementType.AE_INT, true),
        CONSTANT_INT(3, "CONSTANT_INTEGER", AnnotationElementType.AE_INT.printValue, AnnotationElementType.AE_INT, true),
        CONSTANT_BYTE(3, "CONSTANT_INTEGER", AnnotationElementType.AE_BYTE.printValue, AnnotationElementType.AE_BYTE, true),
        CONSTANT_C_BYTE(3, "CONSTANT_INTEGER", "Byte", AnnotationElementType.AE_BYTE, true),
        CONSTANT_CHAR(3, "CONSTANT_INTEGER", AnnotationElementType.AE_CHAR.printValue, AnnotationElementType.AE_CHAR, true),
        CONSTANT_C_CHAR(3, "CONSTANT_INTEGER", "Char", AnnotationElementType.AE_CHAR, true),
        CONSTANT_SHORT(3, "CONSTANT_INTEGER", AnnotationElementType.AE_SHORT.printValue, AnnotationElementType.AE_SHORT, true),
        CONSTANT_C_SHORT(3, "CONSTANT_INTEGER", "Short", AnnotationElementType.AE_SHORT, true),
        CONSTANT_BOOLEAN(3, "CONSTANT_INTEGER", AnnotationElementType.AE_BOOLEAN.printValue, AnnotationElementType.AE_BOOLEAN, true),
        CONSTANT_C_BOOLEAN(3, "CONSTANT_INTEGER", "Boolean", AnnotationElementType.AE_BOOLEAN, true),
        CONSTANT_C_FLOAT(4, "CONSTANT_FLOAT", "Float", AnnotationElementType.AE_FLOAT, true),
        CONSTANT_FLOAT(4, "CONSTANT_FLOAT", "float", AnnotationElementType.AE_FLOAT, true),
        CONSTANT_C_LONG(5, "CONSTANT_LONG", "Long", AnnotationElementType.AE_LONG, true),
        CONSTANT_LONG(5, "CONSTANT_LONG", "long", AnnotationElementType.AE_LONG, true),
        CONSTANT_C_DOUBLE(6, "CONSTANT_DOUBLE", "Double", AnnotationElementType.AE_DOUBLE, true),
        CONSTANT_DOUBLE(6, "CONSTANT_DOUBLE", "double", AnnotationElementType.AE_DOUBLE, true),
        CONSTANT_C_CLASS(7, "CONSTANT_CLASS", "Class", AnnotationElementType.AE_CLASS, true),
        CONSTANT_CLASS(7, "CONSTANT_CLASS", "class", AnnotationElementType.AE_CLASS, true),
        CONSTANT_STRING(8, "CONSTANT_STRING", "String", AnnotationElementType.AE_NOT_APPLICABLE, true),
        CONSTANT_L_STRING(8, "CONSTANT_STRING", "string", AnnotationElementType.AE_NOT_APPLICABLE, false),
        CONSTANT_FIELD(9, "CONSTANT_FIELD", "Field", AnnotationElementType.AE_NOT_APPLICABLE, true),
        CONSTANT_FIELDREF(9, "CONSTANT_FIELDREF", "Fieldref", AnnotationElementType.AE_NOT_APPLICABLE, true),
        CONSTANT_METHOD(10, "CONSTANT_METHOD", "Method", AnnotationElementType.AE_NOT_APPLICABLE, true),
        CONSTANT_METHODREF(10, "CONSTANT_METHODREF", "Methodref", AnnotationElementType.AE_NOT_APPLICABLE, true),
        CONSTANT_INTERFACEMETHOD(11, "CONSTANT_INTERFACEMETHOD", "InterfaceMethod", AnnotationElementType.AE_NOT_APPLICABLE, true),
        CONSTANT_INTERFACEMETHODREF(11, "CONSTANT_INTERFACEMETHODREF", "InterfaceMethodref", AnnotationElementType.AE_NOT_APPLICABLE, true),
        CONSTANT_NAMEANDTYPE(12, "CONSTANT_NAMEANDTYPE", "NameAndType", AnnotationElementType.AE_NOT_APPLICABLE, true),
        CONSTANT_METHODHANDLE(15, "CONSTANT_METHODHANDLE", "MethodHandle", AnnotationElementType.AE_NOT_APPLICABLE, true),
        CONSTANT_METHODTYPE(16, "CONSTANT_METHODTYPE", "MethodType", AnnotationElementType.AE_NOT_APPLICABLE, true),
        CONSTANT_DYNAMIC(17, "CONSTANT_DYNAMIC", "Dynamic", AnnotationElementType.AE_NOT_APPLICABLE, true),
        CONSTANT_INVOKEDYNAMIC(18, "CONSTANT_INVOKEDYNAMIC", "InvokeDynamic", AnnotationElementType.AE_NOT_APPLICABLE, true),
        CONSTANT_MODULE(19, "CONSTANT_MODULE", "Module", AnnotationElementType.AE_NOT_APPLICABLE, true),
        CONSTANT_PACKAGE(20, "CONSTANT_PACKAGE", "Package", AnnotationElementType.AE_NOT_APPLICABLE, true);

        public static final int maxTag = 20;
        private final int tag;
        private final String printVal;
        private final String parseKey;
        private final AnnotationElementType annotationElementType;
        private final boolean isBsmType;

        public boolean equals(ConstType other) {
            if (other != null) {
                return this.tag == other.tag;
            }
            return false;
        }

        private ConstType(int tag, String printVal, String parseKey, AnnotationElementType annotationElementType, boolean isBsmType) {
            this.tag = tag;
            this.printVal = printVal;
            this.parseKey = parseKey;
            this.annotationElementType = annotationElementType;
            this.isBsmType = isBsmType;
        }

        public boolean oneOf(ConstType ... constTypes) {
            for (ConstType constType : constTypes) {
                if (this.tag != constType.tag) continue;
                return true;
            }
            return false;
        }

        public char getAnnotationElementTypeValue() {
            return this.annotationElementType.tag();
        }

        public byte getTag() {
            return (byte)this.tag;
        }

        public String parseKey() {
            return this.parseKey;
        }

        public String printVal() {
            return this.printVal;
        }

        public void print(PrintWriter out) {
            out.print(this.parseKey);
        }

        public String toString() {
            return this.printVal + "." + this.tag;
        }
    }

    public static enum SubTag {
        REF_GETFIELD(1, "REF_getField"),
        REF_GETSTATIC(2, "REF_getStatic"),
        REF_PUTFIELD(3, "REF_putField"),
        REF_PUTSTATIC(4, "REF_putStatic"),
        REF_INVOKEVIRTUAL(5, "REF_invokeVirtual"),
        REF_INVOKESTATIC(6, "REF_invokeStatic"),
        REF_INVOKESPECIAL(7, "REF_invokeSpecial"),
        REF_NEWINVOKESPECIAL(8, "REF_newInvokeSpecial"),
        REF_INVOKEINTERFACE(9, "REF_invokeInterface");

        private final Integer value;
        private final String printValue;

        private SubTag(Integer val, String print) {
            this.value = val;
            this.printValue = print;
        }

        public String printValue() {
            return this.printValue;
        }

        public Integer value() {
            return this.value;
        }
    }

    public static enum BasicType {
        T_INT(10, "int"),
        T_LONG(11, "long"),
        T_FLOAT(6, "float"),
        T_DOUBLE(7, "double"),
        T_CLASS(2, "class"),
        T_BOOLEAN(4, "boolean"),
        T_CHAR(5, "char"),
        T_BYTE(8, "byte"),
        T_SHORT(9, "short");

        private final Integer value;
        private final String printValue;

        private BasicType(Integer value, String printValue) {
            this.value = value;
            this.printValue = printValue;
        }

        public String printValue() {
            return this.printValue;
        }
    }

    public static enum AnnotationElementType {
        AE_BYTE("B", "byte"),
        AE_CHAR("C", "char"),
        AE_SHORT("S", "short"),
        AE_INT("I", "int"),
        AE_LONG("J", "long"),
        AE_FLOAT("F", "float"),
        AE_DOUBLE("D", "double"),
        AE_BOOLEAN("Z", "boolean"),
        AE_STRING("s", "string"),
        AE_ENUM("e", "enum"),
        AE_CLASS("c", "class"),
        AE_ANNOTATION("@", "annotation"),
        AE_ARRAY("[", "array"),
        AE_UNKNOWN("U", "unknown"),
        AE_NOT_APPLICABLE("N", "not applicable");

        private final String value;
        private final String printValue;

        private AnnotationElementType(String value, String printValue) {
            this.value = value;
            this.printValue = printValue;
        }

        public String value() {
            return this.value;
        }

        public String printValue() {
            return this.printValue;
        }

        public char tag() {
            return this.value.charAt(0);
        }

        public static boolean isSet(char tagChar) {
            return AE_NOT_APPLICABLE.tag() != tagChar && AE_UNKNOWN.tag() != tagChar;
        }
    }
}

