/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jasm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.openjdk.asmtools.common.SyntaxError;
import org.openjdk.asmtools.common.structure.EAttribute;
import org.openjdk.asmtools.jasm.AnnotationData;
import org.openjdk.asmtools.jasm.AttrData;
import org.openjdk.asmtools.jasm.CheckedDataOutputStream;
import org.openjdk.asmtools.jasm.ClassData;
import org.openjdk.asmtools.jasm.ConstCell;
import org.openjdk.asmtools.jasm.ConstantPool;
import org.openjdk.asmtools.jasm.DataVector;
import org.openjdk.asmtools.jasm.DataVectorAttr;
import org.openjdk.asmtools.jasm.DataWriter;
import org.openjdk.asmtools.jasm.ExceptionData;
import org.openjdk.asmtools.jasm.FieldType;
import org.openjdk.asmtools.jasm.Indexer;
import org.openjdk.asmtools.jasm.Instr;
import org.openjdk.asmtools.jasm.JasmEnvironment;
import org.openjdk.asmtools.jasm.LineNumberData;
import org.openjdk.asmtools.jasm.LocalVariableData;
import org.openjdk.asmtools.jasm.MethodData;
import org.openjdk.asmtools.jasm.OpcodeTables;
import org.openjdk.asmtools.jasm.Parser;
import org.openjdk.asmtools.jasm.StackMapData;
import org.openjdk.asmtools.jasm.SwitchTable;
import org.openjdk.asmtools.jasm.TypeAnnotationData;

class CodeAttr
extends AttrData {
    protected final List<LocalVariableData> locVarSlots;
    protected final List<LocalVariableData> locVarTypeSlots;
    private final LocalVariableData VACANT = null;
    protected ClassData classData;
    protected MethodData methodData;
    protected JasmEnvironment environment;
    protected Indexer max_stack;
    protected Indexer max_locals;
    protected Instr zeroInstr;
    protected Instr lastInstr;
    protected int curPC = 0;
    protected DataVector<ExceptionData> exceptionTable;
    protected DataVectorAttr<LineNumberData> lineNumberTable;
    protected long lastLineNumber = 0L;
    protected DataVectorAttr<LocalVariableData> localVariableTable;
    protected DataVectorAttr<LocalVariableData> localVariableTypeTable;
    protected DataVector<DataVectorAttr<? extends DataWriter>> attributes;
    protected HashMap<String, Label> labelsHash;
    protected HashMap<String, RangePC> trapsHash;
    protected List<StackMapData> stackMapEntries = new ArrayList<StackMapData>();
    protected DataVectorAttr<StackMapData> stackMapTable;
    protected DataVectorAttr<TypeAnnotationData> visTypeAnnotations = null;
    protected DataVectorAttr<TypeAnnotationData> inVisTypeAnnotations = null;

    public CodeAttr(MethodData methodData, int paramCount, Indexer max_stack, Indexer max_locals) {
        super(methodData.pool, EAttribute.ATT_Code);
        this.methodData = methodData;
        this.classData = methodData.classData;
        this.environment = (JasmEnvironment)methodData.getEnvironment();
        this.max_stack = max_stack;
        this.max_locals = max_locals;
        this.locVarSlots = new ArrayList<LocalVariableData>(Collections.nCopies(max_locals != null ? max_locals.value() : paramCount, this.VACANT));
        this.locVarTypeSlots = new ArrayList<LocalVariableData>(Collections.nCopies(max_locals != null ? max_locals.value() : paramCount, this.VACANT));
        this.lastInstr = this.zeroInstr = new Instr(methodData, this.environment);
        this.exceptionTable = new DataVector(0);
        this.attributes = new DataVector();
        if (this.environment.getVerboseFlag()) {
            this.lineNumberTable = new DataVectorAttr(methodData.pool, EAttribute.ATT_LineNumberTable);
            this.attributes.add(this.lineNumberTable);
        }
    }

    void endCode() {
        this.checkTraps();
        this.checkLocVars(OpcodeTables.Opcode.opc_var);
        this.checkLocVars(OpcodeTables.Opcode.opc_type);
        this.checkLabels();
        if (this.visTypeAnnotations != null) {
            this.attributes.add(this.visTypeAnnotations);
        }
        if (this.inVisTypeAnnotations != null) {
            this.attributes.add(this.inVisTypeAnnotations);
        }
    }

    public void addAnnotations(ArrayList<AnnotationData> list) {
        for (AnnotationData item : list) {
            boolean invisible = item.invisible;
            if (!(item instanceof TypeAnnotationData)) continue;
            TypeAnnotationData typeAnnotationData = (TypeAnnotationData)item;
            if (invisible) {
                if (this.inVisTypeAnnotations == null) {
                    this.inVisTypeAnnotations = new DataVectorAttr(this.methodData.pool, EAttribute.ATT_RuntimeInvisibleTypeAnnotations);
                }
                this.inVisTypeAnnotations.add(typeAnnotationData);
                continue;
            }
            if (this.visTypeAnnotations == null) {
                this.visTypeAnnotations = new DataVectorAttr(this.methodData.pool, EAttribute.ATT_RuntimeVisibleTypeAnnotations);
            }
            this.visTypeAnnotations.add(typeAnnotationData);
        }
    }

    public void fillLineTable(List<LineNumberData> list) {
        if (this.lineNumberTable != null) {
            this.lineNumberTable.clear();
        } else {
            this.lineNumberTable = new DataVectorAttr(this.methodData.pool, EAttribute.ATT_LineNumberTable);
            this.attributes.add(this.lineNumberTable);
        }
        this.lineNumberTable.addAll((Collection<LineNumberData>)list);
    }

    public void fillLocalVariableTable(boolean isTypeTable, List<LocalVariableData> list) {
        DataVectorAttr<LocalVariableData> vector;
        DataVectorAttr<LocalVariableData> dataVectorAttr = vector = isTypeTable ? this.localVariableTypeTable : this.localVariableTable;
        if (vector == null) {
            vector = new DataVectorAttr(this.methodData.pool, isTypeTable ? EAttribute.ATT_LocalVariableTypeTable : EAttribute.ATT_LocalVariableTable);
            this.attributes.add(vector);
        }
        vector.addAll((Collection<LocalVariableData>)list);
    }

    public void fillStackMapTable(List<StackMapData> list) {
        if (this.stackMapTable == null) {
            DataVectorAttr table = this.attributes.findFirst(item -> item.getAttribute().isOneOf(EAttribute.ATT_StackMapTable, EAttribute.ATT_StackMap)).orElse(null);
            if (table == null) {
                this.stackMapTable = new DataVectorAttr(this.classData.pool, this.classData.cfv.isTypeCheckingVerifier() ? EAttribute.ATT_StackMapTable : EAttribute.ATT_StackMap);
                this.attributes.add(this.stackMapTable);
            } else {
                this.stackMapTable = table;
            }
        }
        this.stackMapTable.addAll((Collection<StackMapData>)list);
    }

    RangePC trapDecl(long pos, String name) {
        RangePC local;
        if (this.trapsHash == null) {
            this.trapsHash = new HashMap(10);
            local = null;
        } else {
            local = this.trapsHash.get(name);
        }
        if (local == null) {
            local = new RangePC(pos, name);
            this.trapsHash.put(name, local);
        }
        return local;
    }

    void beginTrap(long pos, String name) {
        RangePC rangePC = this.trapDecl(pos, name);
        if (rangePC.start_pc != -1) {
            this.environment.error("err.trap.tryredecl", name);
            return;
        }
        rangePC.start_pc = this.curPC;
    }

    void endTrap(long pos, String name) {
        RangePC rangePC = this.trapDecl(pos, name);
        if (rangePC.end_pc != -1) {
            this.environment.error("err.trap.endtryredecl", name);
            return;
        }
        rangePC.end_pc = this.curPC;
    }

    void trapHandler(long pos, String name, Indexer type) {
        RangePC rangePC = this.trapDecl(pos, name);
        rangePC.isReferred = true;
        ExceptionData exceptionData = new ExceptionData(pos, rangePC, this.curPC, type);
        this.exceptionTable.addElement(exceptionData);
    }

    void checkTraps() {
        if (this.trapsHash == null) {
            return;
        }
        for (RangePC rangePC : this.trapsHash.values()) {
            if (rangePC.isReferred) continue;
            this.environment.warning(rangePC.pos, "warn.trap.notref", rangePC.name);
        }
        for (ExceptionData exceptionData : this.exceptionTable) {
            RangePC rangePCLabel = exceptionData.rangePC;
            if (rangePCLabel.start_pc == -1) {
                this.environment.error(exceptionData.pos, "err.trap.notry", rangePCLabel.name);
            }
            if (rangePCLabel.end_pc != -1) continue;
            this.environment.error(exceptionData.pos, "err.trap.noendtry", rangePCLabel.name);
        }
    }

    Label labelDecl(String name) {
        Label local;
        if (this.labelsHash == null) {
            this.labelsHash = new HashMap(10);
            local = null;
        } else {
            local = this.labelsHash.get(name);
        }
        if (local == null) {
            local = new Label(name);
            this.labelsHash.put(name, local);
        }
        return local;
    }

    public Label LabelDef(long pos, String name) {
        Label label = this.labelDecl(name);
        if (label.isDefined) {
            this.environment.error(pos, "err.label.redecl", name);
            return null;
        }
        label.isDefined = true;
        label.cpIndex = this.curPC;
        return label;
    }

    public Label LabelRef(String name) {
        Label label = this.labelDecl(name);
        label.isReferred = true;
        return label;
    }

    void checkLabels() {
        if (this.labelsHash == null) {
            return;
        }
        for (Label local : this.labelsHash.values()) {
            if (local.isDefined) continue;
            this.environment.error("err.label.undecl", local.name);
        }
    }

    public void LocVarDataDef(OpcodeTables.Opcode opcode, long position, int index, ConstCell<?> nameCell, ConstCell<?> descriptorCell) {
        List<LocalVariableData> slots;
        FieldType fieldType = null;
        LocalVariableData localVariableData = new LocalVariableData((short)index, (short)this.curPC, nameCell, descriptorCell);
        if (opcode == OpcodeTables.Opcode.opc_var) {
            slots = this.locVarSlots;
            fieldType = localVariableData.getFieldType();
            if (this.localVariableTable == null) {
                this.localVariableTable = new DataVectorAttr(this.methodData.pool, EAttribute.ATT_LocalVariableTable);
                this.attributes.add(this.localVariableTable);
            }
            this.localVariableTable.add(localVariableData);
        } else {
            LocalVariableData lvd;
            slots = this.locVarTypeSlots;
            if (this.localVariableTable != null && (lvd = (LocalVariableData)this.localVariableTable.findFirst(lv -> lv.getIndex() == index).orElse(null)) != null) {
                fieldType = lvd.getFieldType();
            }
            if (this.localVariableTypeTable == null) {
                this.localVariableTypeTable = new DataVectorAttr(this.methodData.pool, EAttribute.ATT_LocalVariableTypeTable);
                this.attributes.add(this.localVariableTypeTable);
            }
            this.localVariableTypeTable.add(localVariableData);
        }
        if (fieldType == null) {
            this.environment.throwErrorException(position, "err.fieldType.undecl", index);
        } else {
            localVariableData.setFieldType(fieldType);
            for (int i = 0; i < fieldType.getSlotsCount(); ++i) {
                if (!this.max_locals.inRange(index + i)) {
                    this.environment.throwErrorException(position, "err.locvar.wrong.index", index + i, this.max_locals.value() - 1);
                }
                if (slots.get(index + i) != this.VACANT) {
                    this.environment.throwErrorException(position, "err.locvar.slot.occupied", index + i);
                }
                slots.set(index + i, localVariableData);
            }
        }
    }

    public void LocVarDataEnd(OpcodeTables.Opcode opcode, short slot, long position) {
        LocalVariableData localVariableData;
        if (!this.max_locals.inRange(slot)) {
            this.environment.throwErrorException(position, "err.locvar.wrong.index", slot, this.max_locals.value() - 1);
        }
        LocalVariableData localVariableData2 = localVariableData = opcode == OpcodeTables.Opcode.opc_var ? this.locVarSlots.get(slot) : this.locVarTypeSlots.get(slot);
        if (localVariableData == this.VACANT) {
            this.environment.throwErrorException(position, "err.locvar.undecl", slot);
        } else {
            localVariableData.setLength(this.curPC);
            List<LocalVariableData> slots = opcode == OpcodeTables.Opcode.opc_var ? this.locVarSlots : this.locVarTypeSlots;
            for (int i = 0; i < localVariableData.getSlotsCount(); ++i) {
                if (i > 0 && !this.max_locals.inRange(slot + i)) {
                    this.environment.error(position, "err.locvar.wrong.index", slot + i, this.max_locals.value() - 1);
                    throw new SyntaxError();
                }
                if (i > 0 && slots.get(slot + i) == this.VACANT) {
                    this.environment.error(position, "err.locvar.undecl", slot + i);
                    throw new SyntaxError();
                }
                slots.set(slot + i, this.VACANT);
            }
        }
    }

    void checkLocVars(OpcodeTables.Opcode opcode) {
        List<LocalVariableData> slots = opcode == OpcodeTables.Opcode.opc_var ? this.locVarSlots : this.locVarTypeSlots;
        for (int i = 0; i < slots.size(); ++i) {
            if (slots.get(i) == this.VACANT) continue;
            slots.get(i).setLength(this.curPC);
            this.environment.warning(this.environment.getPosition(), opcode == OpcodeTables.Opcode.opc_var ? "warn.locvar.ambiqous" : "warn.loctype.ambiqous", i);
        }
    }

    public StackMapData getStackMapTable() {
        StackMapData entry;
        int len = this.stackMapEntries.size();
        if (len == 0) {
            entry = new StackMapData(this.environment, this.isTypeCheckingVerifier());
            this.stackMapEntries.add(entry);
        } else {
            entry = this.stackMapEntries.get(len - 1);
        }
        return entry;
    }

    public StackMapData getNextStackMapTable() {
        StackMapData entry = new StackMapData(this.environment, this.isTypeCheckingVerifier());
        this.stackMapEntries.add(entry);
        return entry;
    }

    public boolean isTypeCheckingVerifier() {
        return this.classData.cfv.isTypeCheckingVerifier();
    }

    void addInstr(long mnenoc_pos, OpcodeTables.Opcode opcode, Indexer arg, Object arg2) {
        long ln;
        Instr newInstr;
        this.lastInstr.next = newInstr = new Instr(this.methodData, this.environment).set(this.curPC, this.environment.getPosition(), opcode, arg, arg2);
        this.lastInstr = newInstr;
        int len = opcode.length();
        switch (opcode) {
            case opc_tableswitch: {
                len = ((SwitchTable)arg2).recalcTableSwitch(this.curPC);
                if (len < OpcodeTables.MAX_TABLESWITCH_LENGTH) break;
                this.environment.error(mnenoc_pos, "err.instr.oversize", OpcodeTables.Opcode.opc_tableswitch.parseKey(), len, OpcodeTables.MAX_TABLESWITCH_LENGTH);
                break;
            }
            case opc_lookupswitch: {
                len = ((SwitchTable)arg2).calcLookupSwitch(this.curPC);
                if (len < OpcodeTables.MAX_LOOKUPSWITCH_LENGTH) break;
                this.environment.error(mnenoc_pos, "err.instr.oversize", OpcodeTables.Opcode.opc_lookupswitch.parseKey(), len, OpcodeTables.MAX_LOOKUPSWITCH_LENGTH);
                break;
            }
            case opc_ldc: {
                ((ConstCell)arg).setRank(ConstantPool.ReferenceRank.LDC);
                break;
            }
            default: {
                ConstantPool.ReferenceRank rank;
                if (!(arg instanceof ConstCell) || (rank = ((ConstCell)arg).rank) == ConstantPool.ReferenceRank.LDC) break;
                ((ConstCell)arg).setRank(ConstantPool.ReferenceRank.ANY);
            }
        }
        if (this.environment.getVerboseFlag() && (ln = this.environment.lineNumber(mnenoc_pos)) != this.lastLineNumber) {
            this.lineNumberTable.add(new LineNumberData(this.curPC, ln));
            this.lastLineNumber = ln;
        }
        if (!this.stackMapEntries.isEmpty()) {
            StackMapData prevStackFrame = this.getPreviousStackMapEntry();
            for (StackMapData entry : this.stackMapEntries) {
                if (entry.isWrapper()) continue;
                entry.setPC(this.curPC);
                entry.setOffset(prevStackFrame);
            }
            this.stackMapTable.addAll((Collection<StackMapData>)this.stackMapEntries);
            this.stackMapEntries.clear();
        }
        this.curPC += len;
    }

    private StackMapData getPreviousStackMapEntry() {
        if (this.stackMapTable == null) {
            this.stackMapTable = new DataVectorAttr(this.classData.pool, this.classData.cfv.isTypeCheckingVerifier() ? EAttribute.ATT_StackMapTable : EAttribute.ATT_StackMap);
            this.attributes.add(this.stackMapTable);
        } else if (!this.stackMapTable.isEmpty()) {
            for (int i = this.stackMapTable.size() - 1; i >= 0; --i) {
                StackMapData entry = this.stackMapTable.get(i);
                if (entry.isWrapper()) continue;
                return entry;
            }
        }
        return null;
    }

    @Override
    public int attrLength() {
        return 8 + this.curPC + this.exceptionTable.getLength() + this.attributes.getLength();
    }

    @Override
    public void write(CheckedDataOutputStream out) throws IOException, Parser.CompilerError {
        int maxStack = this.max_stack != null ? this.max_stack.cpIndex : 0;
        int maxLocals = this.max_locals != null ? this.max_locals.cpIndex : Math.max(this.locVarSlots.size(), this.locVarTypeSlots.size());
        super.write(out);
        out.writeShort(maxStack);
        out.writeShort(maxLocals);
        out.writeInt(this.curPC);
        Instr instr = this.zeroInstr.next;
        while (instr != null) {
            instr.write(out);
            instr = instr.next;
        }
        this.exceptionTable.write(out);
        this.attributes.write(out);
    }

    public boolean isEmpty() {
        return this.curPC == 0;
    }

    static class RangePC
    extends Local {
        int start_pc = -1;
        int end_pc = -1;
        long pos;

        RangePC(long pos, String name) {
            super(name);
            this.pos = pos;
        }
    }

    public static class Label
    extends Local {
        public Label(String name) {
            super(name);
        }
    }

    public static class Local
    extends Indexer {
        String name;
        boolean isDefined = false;
        boolean isReferred = false;

        public Local(String name) {
            this.name = name;
        }
    }
}

