/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jasm;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import org.openjdk.asmtools.common.CompilerLogger;
import org.openjdk.asmtools.common.EMessageKind;
import org.openjdk.asmtools.common.Environment;
import org.openjdk.asmtools.common.inputs.TextInput;
import org.openjdk.asmtools.common.inputs.ToolInput;
import org.openjdk.asmtools.common.outputs.ToolOutput;
import org.openjdk.asmtools.common.outputs.log.DualStreamToolOutput;

public class JasmEnvironment
extends Environment<CompilerLogger> {
    InputFile inputFile;

    private JasmEnvironment(Environment.Builder<JasmEnvironment, CompilerLogger> builder) {
        super(builder);
    }

    @Override
    public void setToolInput(ToolInput toolInput) throws IOException, URISyntaxException {
        try {
            super.setToolInput(toolInput);
            this.inputFile = new InputFile(this.getDataInputStream());
        }
        catch (IOException ioe) {
            this.error("err.cannot.read", toolInput);
            throw ioe;
        }
    }

    @Override
    public void warning(long where, String id, Object ... args) {
        ((CompilerLogger)this.getLogger()).warning(where, id, args);
    }

    @Override
    public void error(long where, String id, Object ... args) {
        ((CompilerLogger)this.getLogger()).error(where, id, args);
    }

    @Override
    public void warning(String id, Object ... args) {
        ((CompilerLogger)this.getLogger()).warning(Integer.MAX_VALUE, id, args);
    }

    @Override
    public void error(String id, Object ... args) {
        ((CompilerLogger)this.getLogger()).error(Integer.MAX_VALUE, id, args);
    }

    @Override
    public long getCount(EMessageKind kind) {
        return ((CompilerLogger)this.getLogger()).getCount(kind);
    }

    public boolean hasMessages() {
        return !((CompilerLogger)super.getLogger()).noMessages();
    }

    public long lineNumber(long where) {
        return ((CompilerLogger)this.getLogger()).lineNumber(where);
    }

    public long lineOffset(long lineNumber, long where) {
        return ((CompilerLogger)this.getLogger()).lineOffset(lineNumber, where);
    }

    public void throwErrorException(String id, Object ... args) throws Error {
        this.error(id, args);
        throw new Error();
    }

    public void throwErrorException(long where, String id, Object ... args) throws Error {
        this.error(where, id, args);
        throw new Error();
    }

    public int flush(boolean printTotals) {
        return ((CompilerLogger)super.getLogger()).flush(printTotals);
    }

    public long getPosition() {
        return this.inputFile == null ? 0L : this.inputFile.position;
    }

    public int read() {
        return this.inputFile.readUTF();
    }

    public int lookForward() {
        return this.inputFile.lookForwardUTF();
    }

    public int convertUnicode() {
        return this.inputFile.convertUnicodeUTF();
    }

    private class InputFile
    extends TextInput {
        InputFile(DataInputStream dataInputStream) throws IOException {
            super(dataInputStream);
        }

        int lookForwardUTF() {
            try {
                return this.strData.charAt(this.charPos);
            }
            catch (StringIndexOutOfBoundsException e) {
                return -1;
            }
        }

        @Override
        public int readUTF() {
            char ch;
            this.position = (long)this.linepos << 32 | (long)this.charPos;
            try {
                ch = this.strData.charAt(this.charPos);
                ++this.charPos;
                switch (ch) {
                    case '\n': {
                        ++this.linepos;
                        break;
                    }
                    case '\r': {
                        if (this.strData.charAt(this.charPos) == '\n') {
                            ++this.charPos;
                        }
                        ++this.linepos;
                    }
                }
            }
            catch (StringIndexOutOfBoundsException e) {
                return -1;
            }
            return ch;
        }

        int convertUnicodeUTF() {
            try {
                char ch;
                while ((ch = this.strData.charAt(this.charPos)) == 'u') {
                    ++this.charPos;
                }
                int d = 0;
                for (int i = 0; i < 4; ++i) {
                    switch (ch) {
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            d = (d << 4) + ch - 48;
                            break;
                        }
                        case 'a': 
                        case 'b': 
                        case 'c': 
                        case 'd': 
                        case 'e': 
                        case 'f': {
                            d = (d << 4) + 10 + ch - 97;
                            break;
                        }
                        case 'A': 
                        case 'B': 
                        case 'C': 
                        case 'D': 
                        case 'E': 
                        case 'F': {
                            d = (d << 4) + 10 + ch - 65;
                            break;
                        }
                        default: {
                            JasmEnvironment.this.error(this.position, "err.invalid.escape.char", new Object[0]);
                            return d;
                        }
                    }
                    ch = this.strData.charAt(++this.charPos);
                }
                return d;
            }
            catch (StringIndexOutOfBoundsException e) {
                JasmEnvironment.this.error(this.position, "err.invalid.escape.char", new Object[0]);
                return -1;
            }
        }
    }

    static class JasmBuilder
    extends Environment.Builder<JasmEnvironment, CompilerLogger> {
        public JasmBuilder(ToolOutput toolOutput, DualStreamToolOutput logger) {
            super(toolOutput, new CompilerLogger("jasm", JasmEnvironment.class, logger));
        }

        @Override
        public JasmEnvironment build() {
            return new JasmEnvironment((Environment.Builder<JasmEnvironment, CompilerLogger>)this);
        }
    }
}

