/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jasm;

import java.io.IOException;
import org.openjdk.asmtools.common.ToolLogger;
import org.openjdk.asmtools.jasm.CheckedDataOutputStream;
import org.openjdk.asmtools.jasm.ConstCell;
import org.openjdk.asmtools.jasm.ConstValue;
import org.openjdk.asmtools.jasm.DataWriter;
import org.openjdk.asmtools.jasm.FieldType;
import org.openjdk.asmtools.jdis.notations.Signature;

class LocalVariableData
implements DataWriter {
    private final short index;
    FieldType fieldType;
    Signature<ToolLogger> fieldSignature;
    private short start_pc;
    private short length;
    private ConstCell nameCell;
    private ConstCell descriptorCell;

    public LocalVariableData(short index, short curPC, ConstCell nameCell, ConstCell descriptorCell) {
        this.index = index;
        this.start_pc = curPC;
        this.nameCell = nameCell;
        this.descriptorCell = descriptorCell;
    }

    public LocalVariableData(short start_pc, short length, short slot, ConstCell nameCell, ConstCell descriptorCell) {
        this.start_pc = start_pc;
        this.length = length;
        this.index = slot;
        this.nameCell = nameCell;
        this.descriptorCell = descriptorCell;
    }

    public FieldType getFieldType() {
        if (this.fieldType == null) {
            this.fieldType = FieldType.getFieldType(((String)((ConstValue)this.descriptorCell.ref).value).charAt(0));
        }
        return this.fieldType;
    }

    public LocalVariableData setFieldType(FieldType fieldType) {
        this.fieldType = fieldType;
        return this;
    }

    public Signature<ToolLogger> getSignature(ToolLogger logger) {
        if (this.fieldSignature == null) {
            this.fieldSignature = new Signature<ToolLogger>(logger, (String)((ConstValue)this.descriptorCell.ref).value);
        }
        return this.fieldSignature;
    }

    public LocalVariableData setFieldSignature(Signature<ToolLogger> fieldSignature) {
        this.fieldSignature = fieldSignature;
        return this;
    }

    public int getSlotsCount() {
        return this.getFieldType() == null ? 0 : this.fieldType.getSlotsCount();
    }

    public short getIndex() {
        return this.index;
    }

    @Override
    public int getLength() {
        return 10;
    }

    public void setLength(int CurrentPC) {
        this.length = (short)(CurrentPC - this.start_pc);
    }

    @Override
    public void write(CheckedDataOutputStream out) throws IOException {
        out.writeShort(this.start_pc);
        out.writeShort(this.length);
        out.writeShort(this.nameCell.cpIndex);
        out.writeShort(this.descriptorCell.cpIndex);
        out.writeShort(this.index);
    }

    public void setStartPc(short start_pc) {
        this.start_pc = start_pc;
    }
}

