/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jasm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.TreeMap;
import java.util.stream.IntStream;
import org.openjdk.asmtools.common.SyntaxError;
import org.openjdk.asmtools.common.structure.EAttribute;
import org.openjdk.asmtools.jasm.AnnotationData;
import org.openjdk.asmtools.jasm.CheckedDataOutputStream;
import org.openjdk.asmtools.jasm.ClassFileConst;
import org.openjdk.asmtools.jasm.ConstCell;
import org.openjdk.asmtools.jasm.ConstValue;
import org.openjdk.asmtools.jasm.ConstantPool;
import org.openjdk.asmtools.jasm.ConstantPoolDataVisitor;
import org.openjdk.asmtools.jasm.DataWriter;
import org.openjdk.asmtools.jasm.DefaultAnnotationAttr;
import org.openjdk.asmtools.jasm.JasmEnvironment;
import org.openjdk.asmtools.jasm.JasmTokens;
import org.openjdk.asmtools.jasm.MethodData;
import org.openjdk.asmtools.jasm.ParseBase;
import org.openjdk.asmtools.jasm.Parser;
import org.openjdk.asmtools.jasm.Scanner;
import org.openjdk.asmtools.jasm.TypeAnnotationData;
import org.openjdk.asmtools.jasm.TypeAnnotationTargetInfoData;
import org.openjdk.asmtools.jasm.TypeAnnotationTypes;

public class ParseAnnotation
extends ParseBase {
    private static final TargetTypeVisitor targetTypeVisitor = new TargetTypeVisitor();

    protected ParseAnnotation(Parser parentParser) {
        super.init(parentParser);
        targetTypeVisitor.init(this.scanner);
    }

    protected void scanParamName(int totalParams, int paramNum, MethodData curMethod) throws SyntaxError {
        ConstCell nameCell;
        this.scanner.debugScan(" - - - > [ParserAnnotation.scanParamName]: Begin ");
        this.scanner.scan();
        this.scanner.expect(JasmTokens.Token.LBRACE);
        if (this.scanner.token == JasmTokens.Token.IDENT || this.scanner.checkTokenIdent()) {
            nameCell = this.parser.parseName();
        } else if (this.scanner.token == JasmTokens.Token.CPINDEX) {
            int cpx = this.scanner.intValue;
            nameCell = this.parser.pool.getCell(cpx);
            Object nameCellValue = nameCell.ref;
            if (!(nameCellValue instanceof ConstantPool.ConstValue_UTF8)) {
                this.environment.error(this.scanner.pos, "err.paramname.constnum.invaltype", cpx);
                throw new SyntaxError();
            }
        } else {
            this.environment.error(this.scanner.pos, "err.paramname.token.unexpected", this.scanner.stringValue);
            throw new SyntaxError();
        }
        int mod = this.parser.scanModifiers();
        this.scanner.expect(JasmTokens.Token.RBRACE);
        curMethod.addMethodParameter(totalParams, paramNum, nameCell, mod);
        this.scanner.debugScan(" - - - > [ParserAnnotation.scanParamName]: End ");
    }

    ArrayList<AnnotationData> parseAnnotations() throws SyntaxError {
        ArrayList<AnnotationData> list = new ArrayList<AnnotationData>();
        while (this.scanner.token == JasmTokens.Token.ANNOTATION) {
            if (JasmTokens.AnnotationType.isAnnotationToken(this.scanner.stringValue)) {
                list.add(this.parseAnnotation());
                continue;
            }
            if (JasmTokens.AnnotationType.isTypeAnnotationToken(this.scanner.stringValue)) {
                list.add(this.parseTypeAnnotation());
                continue;
            }
            return null;
        }
        return list.size() > 0 ? list : null;
    }

    protected DefaultAnnotationAttr parseDefaultAnnotation() throws SyntaxError {
        this.scanner.scan();
        DataWriter value = null;
        this.scanner.expect(JasmTokens.Token.LBRACE);
        if (this.scanner.token != JasmTokens.Token.EOF && this.scanner.token != JasmTokens.Token.RBRACE) {
            value = this.scanAnnotationData("default");
        }
        this.scanner.expect(JasmTokens.Token.RBRACE);
        DefaultAnnotationAttr attr = new DefaultAnnotationAttr(this.parser.pool, EAttribute.ATT_AnnotationDefault, value);
        return attr;
    }

    protected void parseParamAnnotation(int totalParams, MethodData curMethod) throws SyntaxError {
        this.scanner.debugScan(" - - - > [ParserAnnotation.parseParamAnnots]: Begin, totalParams =  " + totalParams + " ");
        TreeMap<Integer, ArrayList<AnnotationData>> pAnnots = new TreeMap<Integer, ArrayList<AnnotationData>>();
        while (this.scanner.token == JasmTokens.Token.INTVAL) {
            int paramNum = this.scanner.intValue;
            Integer iParamNum = paramNum;
            if (paramNum < 0 || paramNum >= totalParams) {
                this.environment.error(this.scanner.pos, "err.invalid.paramnum", paramNum);
            }
            if (pAnnots.get(iParamNum) != null) {
                this.environment.error(this.scanner.pos, "err.duplicate.paramnum", paramNum);
            }
            this.scanner.scan();
            this.scanner.expect(JasmTokens.Token.COLON);
            if (this.scanner.token == JasmTokens.Token.PARAM_NAME) {
                this.scanParamName(totalParams, iParamNum, curMethod);
            }
            if (this.scanner.token != JasmTokens.Token.ANNOTATION) continue;
            ArrayList<AnnotationData> pAnnot = this.parseAnnotations();
            pAnnots.put(iParamNum, pAnnot);
            for (AnnotationData data : pAnnot) {
                curMethod.addParamAnnotation(totalParams, paramNum, data);
            }
        }
    }

    private AnnotationData parseTypeAnnotation() throws SyntaxError {
        TypeAnnotationData ta;
        boolean isInvisible = JasmTokens.AnnotationType.isInvisibleAnnotationToken(this.scanner.stringValue);
        this.scanner.scan();
        if (this.scanner.token == JasmTokens.Token.CPINDEX) {
            int cpIndex = this.scanner.intValue;
            this.scanner.debugScan("     [ParserAnnotation.parseTypeAnnotation]: cpIndex = #%d".formatted(cpIndex));
            ta = new TypeAnnotationData(this.parser.pool.getCell(cpIndex), isInvisible);
        } else {
            String value = this.scanner.stringValue;
            this.scanner.debugScan("     [ParserAnnotation.parseTypeAnnotation]: value = %s".formatted(value));
            ta = new TypeAnnotationData(this.parser.pool.findUTF8Cell(value), isInvisible);
        }
        this.scanner.scan();
        this.scanner.expect(JasmTokens.Token.LBRACE);
        this._scanAnnotation(ta);
        this._scanTypeTarget(ta);
        if (this.scanner.token != JasmTokens.Token.RBRACE) {
            this._scanTargetPath(ta);
        }
        this.scanner.expect(JasmTokens.Token.RBRACE);
        return ta;
    }

    private AnnotationData parseAnnotation() throws SyntaxError {
        AnnotationData ad;
        boolean isInvisible = JasmTokens.AnnotationType.isInvisibleAnnotationToken(this.scanner.stringValue);
        this.scanner.debugScan(" - - - > [ParserAnnotation.parseAnnotation]: Begin ");
        this.scanner.scan();
        if (this.scanner.token == JasmTokens.Token.CPINDEX) {
            int cpIndex = this.scanner.intValue;
            this.scanner.debugScan("     [ParserAnnotation.parseAnnotation]: cpIndex = #%d".formatted(cpIndex));
            ad = new AnnotationData(this.parser.pool.getCell(cpIndex), isInvisible);
        } else {
            String value = this.scanner.stringValue;
            this.scanner.debugScan("     [ParserAnnotation.parseAnnotation]: value = %s".formatted(value));
            ad = new AnnotationData(this.parser.pool.findUTF8Cell(value), isInvisible);
        }
        this.scanner.scan();
        this._scanAnnotation(ad);
        return ad;
    }

    private void _scanAnnotation(AnnotationData annotData) throws SyntaxError {
        this.scanner.debugScan(" - - - > [ParserAnnotation._scanAnnotation]: Begin");
        this.scanner.expect(JasmTokens.Token.LBRACE);
        while (this.scanner.token != JasmTokens.Token.EOF && this.scanner.token != JasmTokens.Token.RBRACE) {
            ConstCell nameCell = this.parser.parseName();
            this.scanner.expect(JasmTokens.Token.ASSIGN);
            if (nameCell.isSet()) {
                Object refValue = nameCell.ref;
                if (((ConstValue)refValue).tag != ClassFileConst.ConstType.CONSTANT_UTF8) {
                    throw new SyntaxError();
                }
                String name = ((ConstValue)refValue).asString();
                this.scanner.debugScan("     [ParserAnnotation._scanAnnotation]: Annot - Field Name: " + name);
                DataWriter dataWriter = this.scanAnnotationData(name);
                annotData.add(new AnnotationData.ElemValuePair(nameCell, dataWriter));
            } else if (this.scanner.token == JasmTokens.Token.CPINDEX) {
                ConstCell refCell = this.parser.parseName();
                this.scanner.debugScan("     [ParserAnnotation._scanAnnotation]: " + nameCell.cpIndex + " = " + refCell.cpIndex);
                annotData.add(new AnnotationData.ElemValuePair(nameCell, refCell));
            } else {
                DataWriter dataWriter = this.scanAnnotationData("unknown");
                annotData.add(new AnnotationData.ElemValuePair(nameCell, dataWriter));
            }
            if (this.scanner.token != JasmTokens.Token.COMMA) continue;
            this.scanner.scan();
        }
        this.scanner.expect(JasmTokens.Token.RBRACE);
    }

    private void _scanTypeTarget(TypeAnnotationData annotData) throws SyntaxError {
        this.scanner.debugScan("     [ParserAnnotation._scanTypeTarget]: Begin ");
        this.scanner.expect(JasmTokens.Token.LBRACE);
        this.scanner.expect(JasmTokens.Token.IDENT);
        this.scanner.debugScan("     [ParserAnnotation._scanTypeTarget]: TargetType: " + this.scanner.idValue);
        TypeAnnotationTypes.ETargetType targetType = TypeAnnotationTypes.ETargetType.getTargetType(this.scanner.idValue);
        if (targetType == null) {
            this.environment.error(this.scanner.pos, "err.incorrect.typeannot.target", this.scanner.idValue);
            throw new SyntaxError();
        }
        this.scanner.debugScan("     [ParserAnnotation._scanTypeTarget]: Got TargetType: " + targetType);
        if (ParseAnnotation.targetTypeVisitor.scanner == null) {
            ParseAnnotation.targetTypeVisitor.scanner = this.scanner;
        }
        targetTypeVisitor.visitExcept(targetType);
        annotData.targetInfo = targetTypeVisitor.getTargetInfo();
        annotData.targetType = targetType;
        this.scanner.debugScan("     [ParserAnnotation._scanTypeTarget]: Got TargetInfo: " + annotData.targetInfo);
        this.scanner.expect(JasmTokens.Token.RBRACE);
    }

    private void _scanTargetPath(TypeAnnotationData annotData) throws SyntaxError {
        this.scanner.expect(JasmTokens.Token.LBRACE);
        while (this.scanner.token != JasmTokens.Token.EOF && this.scanner.token != JasmTokens.Token.RBRACE) {
            TypeAnnotationTypes.TypePathEntry tpe = this._scanTypePathEntry();
            annotData.addTypePathEntry(tpe);
            if (this.scanner.token != JasmTokens.Token.COMMA) continue;
            this.scanner.scan();
        }
        this.scanner.expect(JasmTokens.Token.RBRACE);
    }

    private TypeAnnotationTypes.TypePathEntry _scanTypePathEntry() throws SyntaxError {
        TypeAnnotationTypes.TypePathEntry tpe;
        if (this.scanner.token != JasmTokens.Token.EOF && this.scanner.token.possibleTypePathKind()) {
            TypeAnnotationTypes.EPathKind pathKind = TypeAnnotationTypes.EPathKind.getPathKind(this.scanner.stringValue);
            if (pathKind == TypeAnnotationTypes.EPathKind.TYPE_ARGUMENT) {
                this.scanner.scan();
                this.scanner.expect(JasmTokens.Token.LBRACE);
                if (this.scanner.token == JasmTokens.Token.EOF || this.scanner.token != JasmTokens.Token.INTVAL) {
                    this.environment.error(this.scanner.pos, "err.incorrect.typeannot.pathentry.argindex", new Object[]{this.scanner.token});
                    throw new SyntaxError();
                }
                int index = this.scanner.intValue;
                this.scanner.scan();
                tpe = new TypeAnnotationTypes.TypePathEntry(pathKind, index);
                this.scanner.expect(JasmTokens.Token.RBRACE);
            } else {
                tpe = new TypeAnnotationTypes.TypePathEntry(pathKind, 0);
                this.scanner.scan();
            }
        } else {
            this.environment.error(this.scanner.pos, "err.incorrect.typeannot.pathentry", new Object[]{this.scanner.token});
            throw new SyntaxError();
        }
        return tpe;
    }

    private ArrayElemValue scanAnnotationArray(String name) throws SyntaxError {
        this.scanner.scan();
        ArrayElemValue arrayElem = new ArrayElemValue();
        while (this.scanner.token != JasmTokens.Token.EOF && this.scanner.token != JasmTokens.Token.RBRACE) {
            DataWriter dataWriter = this.scanAnnotationData(name + " {}");
            arrayElem.add(dataWriter);
            if (this.scanner.token != JasmTokens.Token.COMMA) continue;
            this.scanner.scan();
        }
        this.scanner.expect(JasmTokens.Token.RBRACE);
        return arrayElem;
    }

    private DataWriter scanAnnotationClass(String name) throws SyntaxError {
        ConstantPoolDataVisitor constVal;
        this.scanner.scan();
        switch (this.scanner.token) {
            case IDENT: 
            case STRINGVAL: {
                this.environment.traceln("[ParserAnnotation.scanAnnotationData]:: Constant Class Field: " + name + " = " + this.scanner.stringValue, new Object[0]);
                String desc = this.scanner.stringValue;
                constVal = new ConstElemValue(ClassFileConst.AnnotationElementType.AE_CLASS.tag(), this.parser.pool.findUTF8Cell(desc));
                this.scanner.scan();
                break;
            }
            case CPINDEX: {
                this.environment.traceln("[ParserAnnotation.scanAnnotationData]:: Constant Class Field: " + name + " = " + this.scanner.stringValue, new Object[0]);
                Integer ConstNmCPX = Integer.valueOf(this.scanner.stringValue);
                constVal = new ClassElemValue(this.parser.pool.getCell(ConstNmCPX));
                this.scanner.scan();
                break;
            }
            default: {
                this.environment.error(this.scanner.pos, "err.incorrect.annot.class", this.scanner.stringValue);
                throw new SyntaxError();
            }
        }
        return constVal;
    }

    private EnumElemValue scanAnnotationEnum() throws SyntaxError {
        EnumElemValue enumval;
        this.scanner.scan();
        block0 : switch (this.scanner.token) {
            case IDENT: 
            case STRINGVAL: {
                String type = this.scanner.stringValue;
                ConstElemValue typeConst = new ConstElemValue(ClassFileConst.AnnotationElementType.AE_STRING.tag(), this.parser.pool.findUTF8Cell(type));
                this.scanner.scan();
                this.scanner.expect(JasmTokens.Token.FIELD);
                switch (this.scanner.token) {
                    case IDENT: 
                    case STRINGVAL: {
                        String name = this.scanner.stringValue;
                        ConstElemValue nameConst = new ConstElemValue(ClassFileConst.AnnotationElementType.AE_STRING.tag(), this.parser.pool.findUTF8Cell(name));
                        enumval = new EnumElemValue(typeConst.constCell, nameConst.constCell);
                        this.scanner.scan();
                        break block0;
                    }
                    case CPINDEX: {
                        int nameCpx = this.scanner.intValue;
                        enumval = new EnumElemValue(typeConst.constCell, this.parser.pool.getCell(nameCpx));
                        this.scanner.scan();
                        break block0;
                    }
                }
                this.environment.error(this.scanner.pos, "err.incorrect.annot.enum.name", this.scanner.stringValue);
                throw new SyntaxError();
            }
            case CPINDEX: {
                int typeCpx = this.scanner.intValue;
                this.scanner.scan();
                if (this.scanner.token == JasmTokens.Token.FIELD) {
                    this.scanner.scan();
                }
                switch (this.scanner.token) {
                    case CPINDEX: {
                        int nameCpx = this.scanner.intValue;
                        enumval = new EnumElemValue(this.parser.pool.getCell(typeCpx), this.parser.pool.getCell(nameCpx));
                        this.scanner.scan();
                        break block0;
                    }
                    case IDENT: 
                    case STRINGVAL: {
                        String enumName = this.scanner.stringValue;
                        ConstElemValue nameConst = new ConstElemValue(ClassFileConst.AnnotationElementType.AE_STRING.tag(), this.parser.pool.findUTF8Cell(enumName));
                        enumval = new EnumElemValue(this.parser.pool.getCell(typeCpx), nameConst.constCell);
                        this.scanner.scan();
                        break block0;
                    }
                }
                this.environment.error(this.scanner.pos, "err.incorrect.annot.enum.name", this.scanner.stringValue);
                throw new SyntaxError();
            }
            default: {
                this.environment.error(this.scanner.pos, "err.incorrect.annot.enum.type", this.scanner.stringValue);
                throw new SyntaxError();
            }
        }
        return enumval;
    }

    private DataWriter scanAnnotationData(String name) {
        DataWriter dataWriter;
        switch (this.scanner.token) {
            case INTVAL: {
                this.environment.traceln("[ParserAnnotation.scanAnnotationData]:: Integer Field: " + name + " = " + this.scanner.intValue, new Object[0]);
                dataWriter = new ConstElemValue(ClassFileConst.ConstType.CONSTANT_INTEGER.getAnnotationElementTypeValue(), this.parser.pool.findIntegerCell(this.scanner.intValue));
                this.scanner.scan();
                break;
            }
            case DOUBLEVAL: {
                this.environment.traceln("[ParserAnnotation.scanAnnotationData]:: Double Field: " + name + " = " + this.scanner.doubleValue, new Object[0]);
                double dval = this.scanner.doubleValue;
                Long val = Double.doubleToLongBits(dval);
                dataWriter = new ConstElemValue(ClassFileConst.ConstType.CONSTANT_DOUBLE.getAnnotationElementTypeValue(), this.parser.pool.findDoubleCell(val));
                this.scanner.scan();
                break;
            }
            case FLOATVAL: {
                this.environment.traceln("[ParserAnnotation.scanAnnotationData]:: Float Field: " + name + " = " + this.scanner.floatValue, new Object[0]);
                float fval = this.scanner.floatValue;
                Integer val1 = Float.floatToIntBits(fval);
                dataWriter = new ConstElemValue(ClassFileConst.ConstType.CONSTANT_FLOAT.getAnnotationElementTypeValue(), this.parser.pool.findFloatCell(val1));
                this.scanner.scan();
                break;
            }
            case LONGVAL: {
                this.environment.traceln("[ParserAnnotation.scanAnnotationData]:: Long Field: " + name + " = " + this.scanner.longValue, new Object[0]);
                dataWriter = new ConstElemValue(ClassFileConst.ConstType.CONSTANT_LONG.getAnnotationElementTypeValue(), this.parser.pool.findLongCell(this.scanner.longValue));
                this.scanner.scan();
                break;
            }
            case STRINGVAL: {
                this.environment.traceln("[ParserAnnotation.scanAnnotationData]:: String Field: " + name + " = " + this.scanner.stringValue, new Object[0]);
                dataWriter = new ConstElemValue(ClassFileConst.ConstType.CONSTANT_UTF8.getAnnotationElementTypeValue(), this.parser.pool.findUTF8Cell(this.scanner.stringValue));
                this.scanner.scan();
                break;
            }
            case CLASS: {
                this.environment.traceln("[ParserAnnotation.scanAnnotationData]:: Class) keyword: " + this.scanner.stringValue, new Object[0]);
                dataWriter = this.scanAnnotationClass(name);
                break;
            }
            case ENUM: {
                this.environment.traceln("[ParserAnnotation.scanAnnotationData]:: Enum) keyword: " + this.scanner.stringValue, new Object[0]);
                dataWriter = this.scanAnnotationEnum();
                break;
            }
            case IDENT: {
                this.environment.traceln("[ParserAnnotation.scanAnnotationData]:: JASM Keyword: (annotation field name: " + name + ") keyword: " + this.scanner.stringValue, new Object[0]);
                dataWriter = this.scanAnnotationIdent(this.scanner.stringValue, name);
                break;
            }
            case ANNOTATION: {
                this.environment.traceln("[ParserAnnotation.scanAnnotationData]:: Annotation Field: " + name + " = " + this.scanner.stringValue, new Object[0]);
                dataWriter = new AnnotationElemValue(this.parseAnnotation());
                break;
            }
            case LBRACE: {
                this.environment.traceln("[ParserAnnotation.scanAnnotationData]:: Annotation Array Field: " + name, new Object[0]);
                dataWriter = this.scanAnnotationArray(name);
                break;
            }
            case CPINDEX: {
                this.environment.traceln("[ParserAnnotation.scanAnnotationData]:: Constant Field by index: " + name + " = #" + this.scanner.stringValue, new Object[0]);
                int cpIndex = Integer.parseInt(this.scanner.stringValue);
                dataWriter = this.getElementValueByCPIndex(cpIndex);
                this.scanner.scan();
                break;
            }
            default: {
                this.environment.error(this.scanner.pos, "err.incorrect.annot.token", new Object[]{this.scanner.token});
                throw new SyntaxError();
            }
        }
        return dataWriter;
    }

    private DataWriter getElementValueByCPIndex(int cpIndex) {
        ConstCell cell = this.parser.pool.getCell(cpIndex);
        ClassFileConst.ConstType type = cell.getType();
        ConstantPoolDataVisitor dataWriter = type.oneOf(ClassFileConst.ConstType.CONSTANT_UNKNOWN, ClassFileConst.ConstType.CONSTANT_INTEGER, ClassFileConst.ConstType.CONSTANT_FLOAT, ClassFileConst.ConstType.CONSTANT_LONG, ClassFileConst.ConstType.CONSTANT_DOUBLE, ClassFileConst.ConstType.CONSTANT_UTF8) ? new ConstElemValue(type.getAnnotationElementTypeValue(), cell) : new ClassElemValue(this.parser.pool.getCell(cpIndex));
        return dataWriter;
    }

    private DataWriter scanAnnotationIdent(String ident, String name) throws SyntaxError {
        ConstElemValue dataWriter;
        ClassFileConst.BasicType type = ClassFileConst.getBasicType(ident);
        block0 : switch (type) {
            case T_BOOLEAN: {
                this.scanner.scan();
                switch (this.scanner.token) {
                    case INTVAL: {
                        this.environment.traceln("Boolean Field: " + name + " = " + this.scanner.intValue, new Object[0]);
                        int val = this.scanner.intValue;
                        if (val > 1 || val < 0) {
                            this.environment.traceln("Warning: Boolean Field: " + name + " value is not 0 or 1, value = " + this.scanner.intValue, new Object[0]);
                        }
                        dataWriter = new ConstElemValue(ClassFileConst.AnnotationElementType.AE_BOOLEAN.tag(), this.parser.pool.findIntegerCell(val));
                        this.scanner.scan();
                        break block0;
                    }
                    case IDENT: {
                        int val1 = switch (this.scanner.stringValue) {
                            case "true" -> 1;
                            case "false" -> 0;
                            default -> {
                                this.environment.error(this.scanner.pos, "err.incorrect.annotation", ClassFileConst.AnnotationElementType.AE_BOOLEAN.printValue(), JasmTokens.Token.INTVAL.parseKey() + ", " + JasmTokens.Token.CPINDEX.parseKey() + ", " + JasmTokens.Token.TRUE.parseKey() + ", " + JasmTokens.Token.FALSE.parseKey(), this.scanner.stringValue);
                                throw new SyntaxError();
                            }
                        };
                        this.environment.traceln("Boolean Field: " + name + " = " + this.scanner.stringValue, new Object[0]);
                        dataWriter = new ConstElemValue(ClassFileConst.AnnotationElementType.AE_BOOLEAN.tag(), this.parser.pool.findIntegerCell(val1));
                        this.scanner.scan();
                        break block0;
                    }
                    case CPINDEX: {
                        int cpIndex = Integer.parseInt(this.scanner.stringValue);
                        dataWriter = new ConstElemValue(ClassFileConst.AnnotationElementType.AE_BOOLEAN.tag(), this.parser.pool.getCell(cpIndex));
                        this.scanner.scan();
                        break block0;
                    }
                }
                this.environment.error(this.scanner.pos, "err.incorrect.annotation", ClassFileConst.AnnotationElementType.AE_BOOLEAN.printValue(), JasmTokens.Token.INTVAL.parseKey() + ", " + JasmTokens.Token.CPINDEX.parseKey(), this.scanner.stringValue);
                throw new SyntaxError();
            }
            case T_BYTE: {
                this.scanner.scan();
                switch (this.scanner.token) {
                    case INTVAL: {
                        this.environment.traceln("Byte Field: " + name + " = " + this.scanner.intValue, new Object[0]);
                        int val = this.scanner.intValue;
                        if (val > 255) {
                            this.environment.traceln("Warning: Byte Field: " + name + " value is greater than 0xFF, value = " + this.scanner.intValue, new Object[0]);
                        }
                        dataWriter = new ConstElemValue(ClassFileConst.AnnotationElementType.AE_BYTE.tag(), this.parser.pool.findIntegerCell(val));
                        this.scanner.scan();
                        break block0;
                    }
                    case CPINDEX: {
                        int cpIndex = Integer.parseInt(this.scanner.stringValue);
                        dataWriter = new ConstElemValue(ClassFileConst.AnnotationElementType.AE_BYTE.tag(), this.parser.pool.getCell(cpIndex));
                        this.scanner.scan();
                        break block0;
                    }
                }
                this.environment.error(this.scanner.pos, "err.incorrect.annotation", ClassFileConst.AnnotationElementType.AE_BYTE.printValue(), JasmTokens.Token.INTVAL.parseKey() + ", " + JasmTokens.Token.CPINDEX.parseKey(), this.scanner.stringValue);
                throw new SyntaxError();
            }
            case T_CHAR: {
                this.scanner.scan();
                switch (this.scanner.token) {
                    case INTVAL: {
                        this.environment.traceln("Char Field: " + name + " = " + this.scanner.intValue, new Object[0]);
                        Integer val = this.scanner.intValue;
                        dataWriter = new ConstElemValue(ClassFileConst.AnnotationElementType.AE_CHAR.tag(), this.parser.pool.findIntegerCell(val));
                        this.scanner.scan();
                        break block0;
                    }
                    case CPINDEX: {
                        int cpIndex = Integer.parseInt(this.scanner.stringValue);
                        dataWriter = new ConstElemValue(ClassFileConst.AnnotationElementType.AE_CHAR.tag(), this.parser.pool.getCell(cpIndex));
                        this.scanner.scan();
                        break block0;
                    }
                }
                this.environment.error(this.scanner.pos, "err.incorrect.annotation", ClassFileConst.AnnotationElementType.AE_CHAR.printValue(), JasmTokens.Token.INTVAL.parseKey() + ", " + JasmTokens.Token.CPINDEX.parseKey(), this.scanner.stringValue);
                throw new SyntaxError();
            }
            case T_SHORT: {
                this.scanner.scan();
                switch (this.scanner.token) {
                    case INTVAL: {
                        this.environment.traceln("Short Field: " + name + " = " + this.scanner.intValue, new Object[0]);
                        int val = this.scanner.intValue;
                        if (val > 65535) {
                            this.environment.traceln("Warning: Short Field: " + name + " value is greater than 0xFFFF, value = " + this.scanner.intValue, new Object[0]);
                        }
                        dataWriter = new ConstElemValue(ClassFileConst.AnnotationElementType.AE_SHORT.tag(), this.parser.pool.findIntegerCell(val));
                        this.scanner.scan();
                        break block0;
                    }
                    case CPINDEX: {
                        int cpIndex = Integer.parseInt(this.scanner.stringValue);
                        dataWriter = new ConstElemValue(ClassFileConst.AnnotationElementType.AE_SHORT.tag(), this.parser.pool.getCell(cpIndex));
                        this.scanner.scan();
                        break block0;
                    }
                }
                this.environment.error(this.scanner.pos, "err.incorrect.annotation", ClassFileConst.AnnotationElementType.AE_SHORT.printValue(), JasmTokens.Token.INTVAL.parseKey() + ", " + JasmTokens.Token.CPINDEX.parseKey(), this.scanner.stringValue);
                throw new SyntaxError();
            }
            default: {
                this.environment.error(this.scanner.pos, "err.incorrect.annot.keyword", ident);
                throw new SyntaxError();
            }
        }
        return dataWriter;
    }

    private static class TargetTypeVisitor
    extends TypeAnnotationTypes.TypeAnnotationTargetVisitor {
        private TypeAnnotationTargetInfoData targetInfoData;
        private SyntaxError syntaxError;
        private Scanner scanner;
        private JasmEnvironment environment;

        private TargetTypeVisitor() {
        }

        public void init(Scanner scanner) {
            this.scanner = scanner;
            this.environment = scanner.environment;
            this.reset();
        }

        public final void reset() {
            this.targetInfoData = null;
            this.syntaxError = null;
        }

        public void visitExcept(TypeAnnotationTypes.ETargetType targetType) throws SyntaxError {
            this.reset();
            this.visit(targetType);
            if (this.syntaxError != null) {
                throw this.syntaxError;
            }
        }

        public TypeAnnotationTargetInfoData getTargetInfo() {
            return this.targetInfoData;
        }

        private int scanIntVal(TypeAnnotationTypes.ETargetType targetType) {
            int ret = -1;
            if (this.scanner.token == JasmTokens.Token.INTVAL) {
                ret = this.scanner.intValue;
                try {
                    this.scanner.scan();
                }
                catch (SyntaxError se) {
                    this.syntaxError = se;
                }
            } else {
                this.environment.error(this.scanner.pos, "err.incorrect.typeannot.targtype.int", new Object[]{targetType.parseKey(), this.scanner.token});
                this.syntaxError = new SyntaxError();
            }
            return ret;
        }

        private String scanStringVal(TypeAnnotationTypes.ETargetType targetType) {
            String ret = "";
            if (this.scanner.token == JasmTokens.Token.STRINGVAL) {
                ret = this.scanner.stringValue;
                try {
                    this.scanner.scan();
                }
                catch (SyntaxError se) {
                    this.syntaxError = se;
                }
            } else {
                this.environment.error(this.scanner.pos, "err.incorrect.typeannot.targtype.string", new Object[]{targetType.parseKey(), this.scanner.token});
                this.syntaxError = new SyntaxError();
            }
            return ret;
        }

        private void scanBrace(boolean left) {
            try {
                this.scanner.expect(left ? JasmTokens.Token.LBRACE : JasmTokens.Token.RBRACE);
            }
            catch (SyntaxError se) {
                this.syntaxError = se;
            }
        }

        private boolean errorFound() {
            return this.syntaxError != null;
        }

        @Override
        public void visit_type_param_target(TypeAnnotationTypes.ETargetType targetType) {
            this.environment.traceln("Type Param Target: ", new Object[0]);
            int byteval = this.scanIntVal(targetType);
            if (!this.errorFound()) {
                this.targetInfoData = new TypeAnnotationTargetInfoData.type_parameter_target(targetType, byteval);
            }
        }

        @Override
        public void visit_supertype_target(TypeAnnotationTypes.ETargetType targetType) {
            this.environment.traceln("SuperType Target: ", new Object[0]);
            int shortval = this.scanIntVal(targetType);
            if (!this.errorFound()) {
                this.targetInfoData = new TypeAnnotationTargetInfoData.supertype_target(targetType, shortval);
            }
        }

        @Override
        public void visit_typeparam_bound_target(TypeAnnotationTypes.ETargetType targetType) {
            this.environment.traceln("TypeParam Bound Target: ", new Object[0]);
            int byteval1 = this.scanIntVal(targetType);
            if (this.errorFound()) {
                return;
            }
            int byteval2 = this.scanIntVal(targetType);
            if (this.errorFound()) {
                return;
            }
            this.targetInfoData = new TypeAnnotationTargetInfoData.type_parameter_bound_target(targetType, byteval1, byteval2);
        }

        @Override
        public void visit_empty_target(TypeAnnotationTypes.ETargetType targetType) {
            this.environment.traceln("Empty Target: ", new Object[0]);
            if (!this.errorFound()) {
                this.targetInfoData = new TypeAnnotationTargetInfoData.empty_target(targetType);
            }
        }

        @Override
        public void visit_methodformalparam_target(TypeAnnotationTypes.ETargetType targetType) {
            this.environment.traceln("MethodParam Target: ", new Object[0]);
            int byteval = this.scanIntVal(targetType);
            if (!this.errorFound()) {
                this.targetInfoData = new TypeAnnotationTargetInfoData.formal_parameter_target(targetType, byteval);
            }
        }

        @Override
        public void visit_throws_target(TypeAnnotationTypes.ETargetType targetType) {
            this.environment.traceln("Throws Target: ", new Object[0]);
            int shortval = this.scanIntVal(targetType);
            if (!this.errorFound()) {
                this.targetInfoData = new TypeAnnotationTargetInfoData.throws_target(targetType, shortval);
            }
        }

        @Override
        public void visit_localvar_target(TypeAnnotationTypes.ETargetType targetType) {
            this.environment.traceln("LocalVar Target: ", new Object[0]);
            TypeAnnotationTargetInfoData.localvar_target locvartab = new TypeAnnotationTargetInfoData.localvar_target(targetType, 0);
            this.targetInfoData = locvartab;
            while (this.scanner.token != JasmTokens.Token.EOF && this.scanner.token != JasmTokens.Token.RBRACE) {
                this.scanBrace(true);
                if (this.errorFound()) {
                    return;
                }
                int shortval1 = this.scanIntVal(targetType);
                if (this.errorFound()) {
                    return;
                }
                int shortval2 = this.scanIntVal(targetType);
                if (this.errorFound()) {
                    return;
                }
                int shortval3 = this.scanIntVal(targetType);
                locvartab.addEntry(shortval1, shortval2, shortval3);
                this.scanBrace(false);
                if (!this.errorFound()) continue;
                return;
            }
        }

        @Override
        public void visit_catch_target(TypeAnnotationTypes.ETargetType targetType) {
            this.environment.traceln("Catch Target: ", new Object[0]);
            int shortval = this.scanIntVal(targetType);
            this.targetInfoData = new TypeAnnotationTargetInfoData.catch_target(targetType, shortval);
        }

        @Override
        public void visit_offset_target(TypeAnnotationTypes.ETargetType targetType) {
            this.environment.traceln("Offset Target: ", new Object[0]);
            int shortval = this.scanIntVal(targetType);
            if (!this.errorFound()) {
                this.targetInfoData = new TypeAnnotationTargetInfoData.offset_target(targetType, shortval);
            }
        }

        @Override
        public void visit_typearg_target(TypeAnnotationTypes.ETargetType targetType) {
            this.environment.traceln("TypeArg Target: ", new Object[0]);
            int shortval = this.scanIntVal(targetType);
            if (this.errorFound()) {
                return;
            }
            int byteval = this.scanIntVal(targetType);
            if (this.errorFound()) {
                return;
            }
            this.targetInfoData = new TypeAnnotationTargetInfoData.type_argument_target(targetType, shortval, byteval);
        }
    }

    static class ArrayElemValue
    implements ConstantPoolDataVisitor {
        ArrayList<DataWriter> elemValues = new ArrayList();

        ArrayElemValue() {
        }

        void add(DataWriter elemValue) {
            this.elemValues.add(elemValue);
        }

        @Override
        public void write(CheckedDataOutputStream out) throws IOException {
            out.writeByte(ClassFileConst.AnnotationElementType.AE_ARRAY.tag());
            out.writeShort(this.elemValues.size());
            for (DataWriter eval : this.elemValues) {
                eval.write(out);
            }
        }

        @Override
        public int getLength() {
            return 3 + this.elemValues.stream().flatMapToInt(elem -> IntStream.of(elem.getLength())).sum();
        }

        @Override
        public <T extends DataWriter> T visit(ConstantPool pool) {
            for (DataWriter element : this.elemValues) {
                this.visitData(element, pool);
            }
            return (T)this;
        }
    }

    static class ConstElemValue
    implements ConstantPoolDataVisitor {
        char tag;
        ConstCell constCell;

        ConstElemValue(char tag, ConstCell constCell) {
            this.tag = tag;
            this.constCell = constCell;
        }

        @Override
        public void write(CheckedDataOutputStream out) throws IOException {
            out.writeByte(this.tag);
            this.constCell.write(out);
        }

        @Override
        public int getLength() {
            return 3;
        }

        @Override
        public <T extends DataWriter> T visit(ConstantPool pool) {
            if (!this.constCell.isSet()) {
                this.constCell = (ConstCell)this.visitConstCell(this.constCell, pool);
                if (!ClassFileConst.AnnotationElementType.isSet(this.tag)) {
                    this.tag = this.constCell.getAnnotationElementTypeValue();
                }
            }
            return (T)this;
        }
    }

    static class ClassElemValue
    implements ConstantPoolDataVisitor {
        ConstCell constCell;

        ClassElemValue(ConstCell constCell) {
            this.constCell = constCell;
        }

        @Override
        public void write(CheckedDataOutputStream out) throws IOException {
            out.writeByte(ClassFileConst.AnnotationElementType.AE_CLASS.tag());
            this.constCell.write(out);
        }

        @Override
        public int getLength() {
            return 3;
        }

        @Override
        public <T extends DataWriter> T visit(ConstantPool pool) {
            this.constCell = (ConstCell)this.visitConstCell(this.constCell, pool);
            return (T)this;
        }
    }

    static class EnumElemValue
    implements ConstantPoolDataVisitor {
        ConstCell type;
        ConstCell name;

        EnumElemValue(ConstCell type, ConstCell name) {
            this.type = type;
            this.name = name;
        }

        @Override
        public void write(CheckedDataOutputStream out) throws IOException {
            out.writeByte(ClassFileConst.AnnotationElementType.AE_ENUM.tag());
            this.type.write(out);
            this.name.write(out);
        }

        @Override
        public int getLength() {
            return 5;
        }

        @Override
        public <T extends DataWriter> T visit(ConstantPool pool) {
            this.type = (ConstCell)this.visitConstCell(this.type, pool);
            this.name = (ConstCell)this.visitConstCell(this.name, pool);
            return (T)this;
        }
    }

    static class AnnotationElemValue
    implements ConstantPoolDataVisitor {
        AnnotationData annotationData;

        AnnotationElemValue(AnnotationData annotationData) {
            this.annotationData = annotationData;
        }

        @Override
        public void write(CheckedDataOutputStream out) throws IOException {
            out.writeByte(ClassFileConst.AnnotationElementType.AE_ANNOTATION.tag());
            this.annotationData.write(out);
        }

        @Override
        public int getLength() {
            return 1 + this.annotationData.getLength();
        }

        @Override
        public <T extends DataWriter> T visit(ConstantPool pool) {
            this.annotationData = this.visitData(this.annotationData, pool);
            return (T)this;
        }
    }
}

