/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jasm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.openjdk.asmtools.common.SyntaxError;
import org.openjdk.asmtools.common.structure.StackMap;
import org.openjdk.asmtools.jasm.ConstCell;
import org.openjdk.asmtools.jasm.DataVector;
import org.openjdk.asmtools.jasm.JasmTokens;
import org.openjdk.asmtools.jasm.LineNumberData;
import org.openjdk.asmtools.jasm.LocalVariableData;
import org.openjdk.asmtools.jasm.ParseBase;
import org.openjdk.asmtools.jasm.Parser;
import org.openjdk.asmtools.jasm.StackMapData;

public class ParseAttribute
extends ParseBase {
    private static final String LocalVariableTable_HEADER = JasmTokens.Token.START.parseKey() + JasmTokens.Token.LENGTH.parseKey() + JasmTokens.Token.SLOT.parseKey() + JasmTokens.Token.NAME.parseKey() + JasmTokens.Token.DESCRIPTOR.parseKey();
    private static final String LocalVariableTypeTable_HEADER = JasmTokens.Token.START.parseKey() + JasmTokens.Token.LENGTH.parseKey() + JasmTokens.Token.SLOT.parseKey() + JasmTokens.Token.NAME.parseKey() + JasmTokens.Token.SIGNATURE.parseKey();
    private static final int LocalVariableTable_HEADER_LENGTH = LocalVariableTable_HEADER.length();
    private static final int LocalVariableTypeTable_HEADER_LENGTH = LocalVariableTypeTable_HEADER.length();

    protected ParseAttribute(Parser parentParser) {
        super.init(parentParser);
    }

    public List<LocalVariableData> parseLocalVariableTable(boolean isTypeTable) {
        String attributeName = isTypeTable ? "LocalVariableTypeTable" : "LocalVariableTable";
        String parseKey = isTypeTable ? JasmTokens.Token.SIGNATURE.parseKey() : JasmTokens.Token.DESCRIPTOR.parseKey();
        String header = isTypeTable ? LocalVariableTypeTable_HEADER : LocalVariableTable_HEADER;
        int headerLength = isTypeTable ? LocalVariableTypeTable_HEADER_LENGTH : LocalVariableTable_HEADER_LENGTH;
        ArrayList<LocalVariableData> list = new ArrayList<LocalVariableData>();
        this.scanner.scan();
        if (this.scanner.token == JasmTokens.Token.COLON) {
            this.scanner.scan();
        }
        Object buffer = "";
        int slot = -1;
        int start_pc = -1;
        int length = -1;
        ConstCell nameCell = null;
        ConstCell descriptorCell = null;
        while (this.scanner.token != JasmTokens.Token.EOF && this.scanner.token != JasmTokens.Token.RBRACE) {
            switch (this.scanner.token) {
                case START: 
                case LENGTH: 
                case SLOT: 
                case NAME: 
                case DESCRIPTOR: 
                case SIGNATURE: {
                    if (((String)buffer).length() == headerLength || ((String)buffer).contains(this.scanner.stringValue)) {
                        this.environment.throwErrorException(this.scanner.pos, "err.header.locvars", parseKey);
                    }
                    if (header.startsWith((String)(buffer = (String)buffer + this.scanner.stringValue))) break;
                    this.environment.throwErrorException(this.scanner.pos, "err.header.locvars", parseKey);
                    break;
                }
                case INTVAL: {
                    if (((String)buffer).length() != headerLength) {
                        this.environment.throwErrorException(this.scanner.pos, "err.header.expected.locvars", parseKey);
                    }
                    if (start_pc == -1) {
                        start_pc = (short)this.scanner.intValue;
                        break;
                    }
                    if (length == -1) {
                        length = (short)this.scanner.intValue;
                        break;
                    }
                    if (slot == -1) {
                        slot = (short)this.scanner.intValue;
                        break;
                    }
                    if (nameCell == null) {
                        this.environment.throwErrorException(this.scanner.pos, "err.expected.locvars", attributeName, "\"" + JasmTokens.Token.NAME.parseKey() + "\"");
                    }
                    if (descriptorCell != null) break;
                    this.environment.throwErrorException(this.scanner.pos, "err.expected.locvars", attributeName, "\"" + parseKey + "\"");
                    break;
                }
                case STRINGVAL: {
                    this.verifyPosition((String)buffer, headerLength, attributeName, parseKey, (short)start_pc, (short)length, (short)slot);
                    String str = this.scanner.stringValue;
                    if (nameCell == null) {
                        nameCell = this.parser.pool.findUTF8Cell(str);
                        break;
                    }
                    if (descriptorCell == null) {
                        descriptorCell = this.parser.pool.findUTF8Cell(str);
                        list.add(new LocalVariableData((short)start_pc, (short)length, (short)slot, nameCell, descriptorCell));
                        length = -1;
                        start_pc = -1;
                        slot = -1;
                        descriptorCell = null;
                        nameCell = null;
                        break;
                    }
                    this.environment.throwErrorException(this.scanner.pos, "err.header.expected.locvars", parseKey);
                    break;
                }
                case CPINDEX: {
                    this.verifyPosition((String)buffer, headerLength, attributeName, parseKey, (short)start_pc, (short)length, (short)slot);
                    String str = this.scanner.stringValue;
                    if (nameCell == null) {
                        nameCell = this.parser.pool.findUTF8Cell(str);
                        break;
                    }
                    if (descriptorCell == null) {
                        descriptorCell = this.parser.pool.findUTF8Cell(str);
                        list.add(new LocalVariableData((short)start_pc, (short)length, (short)slot, nameCell, descriptorCell));
                        length = -1;
                        start_pc = -1;
                        slot = -1;
                        descriptorCell = null;
                        nameCell = null;
                        break;
                    }
                    this.environment.throwErrorException(this.scanner.pos, "err.header.expected.locvars", parseKey);
                    break;
                }
                default: {
                    if (((String)buffer).length() != headerLength) {
                        this.environment.throwErrorException(this.scanner.pos, "err.header.locvars", parseKey);
                    }
                    if (slot != -1 || start_pc != -1 || length != -1 || nameCell != null || descriptorCell != null) {
                        this.environment.throwErrorException(this.scanner.pos, "err.expected.locvars", attributeName, " either the line {start_pc length slot \"name\" \"descriptor\"} or {start_pc length slot name_index descriptor_index}");
                    }
                    return list;
                }
            }
            this.scanner.scan();
        }
        return list;
    }

    private void verifyPosition(String buffer, int headerLength, String attributeName, String parseKey, short start_pc, short length, short slot) {
        if (buffer.length() != headerLength) {
            this.environment.throwErrorException(this.scanner.pos, "err.header.locvars", parseKey);
        }
        if (start_pc == -1) {
            this.environment.throwErrorException(this.scanner.pos, "err.expected.locvars", attributeName, "\"start_pc\"");
        } else if (length == -1) {
            this.environment.throwErrorException(this.scanner.pos, "err.expected.locvars", attributeName, "\"length\"");
        } else if (slot == -1) {
            this.environment.throwErrorException(this.scanner.pos, "err.expected.locvars", attributeName, "\"slot\"");
        }
    }

    public List<StackMapData> parseStackMap() throws SyntaxError, IOException {
        if (this.scanner.token == JasmTokens.Token.COLON) {
            this.scanner.scan();
        }
        ArrayList<StackMapData> list = new ArrayList<StackMapData>();
        int numEntries = 0;
        StackMap.EntryType entryType = StackMap.EntryType.UNKNOWN_TYPE;
        StackMapData stackMapData = null;
        block6: while (this.scanner.token != JasmTokens.Token.EOF && this.scanner.token != JasmTokens.Token.RBRACE) {
            switch (this.scanner.token) {
                case NUMBEROFENTRIES: {
                    this.scanner.scan();
                    this.scanner.expect(JasmTokens.Token.ASSIGN);
                    if (this.scanner.token != JasmTokens.Token.INTVAL) {
                        this.environment.throwErrorException(this.scanner.pos, "err.stackmap.expected", "\"number of entries\"");
                    }
                    numEntries = this.scanner.intValue;
                    break;
                }
                case BYTECODEOFFSET: {
                    if (stackMapData != null) {
                        list.add(stackMapData);
                    }
                    this.scanner.scan();
                    this.scanner.expect(JasmTokens.Token.ASSIGN);
                    if (this.scanner.token != JasmTokens.Token.INTVAL) {
                        this.environment.throwErrorException(this.scanner.pos, "err.stackmap.expected", "The offset value");
                    }
                    stackMapData = new StackMapData(this.environment, false);
                    stackMapData.setPC(this.scanner.intValue);
                    break;
                }
                case LOCALSMAP: {
                    if (stackMapData == null) {
                        this.environment.throwErrorException(this.scanner.pos, "err.stackmap.expected", "\"%s\"".formatted(JasmTokens.Token.BYTECODEOFFSET.parseKey()));
                        break;
                    }
                    if (stackMapData.localsMap != null && stackMapData.localsMap.size() > 0) {
                        this.environment.warning(this.scanner.pos, "warn.stackmap.redeclared", "\"%s\"".formatted(JasmTokens.Token.LOCALSMAP.parseKey()));
                    }
                    this.scanner.scan();
                    this.scanner.expect(JasmTokens.Token.ASSIGN);
                    if (this.scanner.token == JasmTokens.Token.IDENT && this.scanner.stringValue.equals(JasmTokens.Token.LSQBRACKET.parseKey() + JasmTokens.Token.RSQBRACKET.parseKey())) {
                        stackMapData.localsMap = new DataVector();
                        break;
                    }
                    this.scanner.expectIdentContent(JasmTokens.Token.LSQBRACKET);
                    DataVector localsMap = new DataVector();
                    stackMapData.localsMap = localsMap;
                    while (this.scanner.token != JasmTokens.Token.EOF) {
                        if (this.scanner.token == JasmTokens.Token.SEMICOLON) {
                            this.scanner.scan();
                            this.scanner.expectIdentContent(JasmTokens.Token.RSQBRACKET);
                            continue block6;
                        }
                        if (this.scanner.token == JasmTokens.Token.IDENT && this.scanner.stringValue.equals(JasmTokens.Token.RSQBRACKET.parseKey())) continue block6;
                        this.parser.parseMapItem(localsMap);
                        if (this.scanner.token != JasmTokens.Token.COMMA) {
                            if (this.scanner.token == JasmTokens.Token.SEMICOLON) continue;
                            this.environment.throwErrorException(this.scanner.pos, "err.token.expected", "\"" + JasmTokens.Token.SEMICOLON.parseKey() + "\"");
                            continue;
                        }
                        this.scanner.scan();
                    }
                    continue block6;
                }
                case STACKMAP: {
                    if (stackMapData == null) {
                        this.environment.throwErrorException(this.scanner.pos, "err.stackmap.expected", "\"%s\"".formatted(JasmTokens.Token.BYTECODEOFFSET.parseKey()));
                        break;
                    }
                    if (stackMapData.stackMap != null && stackMapData.stackMap.size() > 0) {
                        this.environment.warning(this.scanner.pos, "warn.stackmap.redeclared", "\"%s\"".formatted(JasmTokens.Token.STACKMAP.parseKey()));
                    }
                    this.scanner.scan();
                    this.scanner.expect(JasmTokens.Token.ASSIGN);
                    if (this.scanner.token == JasmTokens.Token.IDENT && this.scanner.stringValue.equals(JasmTokens.Token.LSQBRACKET.parseKey() + JasmTokens.Token.RSQBRACKET.parseKey())) {
                        stackMapData.stackMap = new DataVector();
                        break;
                    }
                    this.scanner.expectIdentContent(JasmTokens.Token.LSQBRACKET);
                    DataVector stackMap = new DataVector();
                    stackMapData.stackMap = stackMap;
                    while (this.scanner.token != JasmTokens.Token.EOF) {
                        if (this.scanner.token == JasmTokens.Token.SEMICOLON) {
                            this.scanner.scan();
                            this.scanner.expectIdentContent(JasmTokens.Token.RSQBRACKET);
                            continue block6;
                        }
                        if (this.scanner.token == JasmTokens.Token.IDENT && this.scanner.stringValue.equals(JasmTokens.Token.RSQBRACKET.parseKey())) continue block6;
                        this.parser.parseMapItem(stackMap);
                        if (this.scanner.token != JasmTokens.Token.COMMA) {
                            if (this.scanner.token == JasmTokens.Token.SEMICOLON) continue;
                            this.environment.throwErrorException(this.scanner.pos, "err.token.expected", "\"" + JasmTokens.Token.SEMICOLON.parseKey() + "\"");
                            continue;
                        }
                        this.scanner.scan();
                    }
                    continue block6;
                }
            }
            this.scanner.scan();
        }
        if (stackMapData != null) {
            list.add(stackMapData);
        }
        return list;
    }

    public List<StackMapData> parseStackMapTable() throws SyntaxError, IOException {
        int wrapLevel = 0;
        int numEntries = 0;
        ArrayList<StackMapData> list = new ArrayList<StackMapData>();
        int stackFrameTypeValue = -1;
        StackMap.EntryType entryType = StackMap.EntryType.UNKNOWN_TYPE;
        StackMapData stackMapData = null;
        this.scanner.scan();
        if (this.scanner.token == JasmTokens.Token.COLON) {
            this.scanner.scan();
        }
        block10: while (this.scanner.token != JasmTokens.Token.EOF) {
            switch (this.scanner.token) {
                case LBRACE: {
                    if (wrapLevel != 0) break;
                    this.environment.throwErrorException(this.scanner.pos, "err.larvar.frame.expected", new Object[0]);
                    break;
                }
                case RBRACE: {
                    if (wrapLevel == 0) {
                        return list;
                    }
                    --wrapLevel;
                    break;
                }
                case NUMBEROFENTRIES: {
                    this.scanner.scan();
                    this.scanner.expect(JasmTokens.Token.ASSIGN);
                    if (this.scanner.token != JasmTokens.Token.INTVAL) {
                        this.environment.throwErrorException(this.scanner.pos, "err.stackmap.expected", "\"number of entries\"");
                    }
                    numEntries = this.scanner.intValue;
                    break;
                }
                case FRAMETYPE: 
                case ENTRYTYPE: {
                    JasmTokens.Token expectedToken;
                    this.scanner.scan();
                    this.scanner.expect(JasmTokens.Token.ASSIGN);
                    if (this.scanner.token == JasmTokens.Token.INTVAL) {
                        stackFrameTypeValue = this.scanner.intValue;
                        entryType = StackMap.EntryType.getByTag(stackFrameTypeValue);
                    }
                    if (entryType == StackMap.EntryType.UNKNOWN_TYPE) {
                        this.environment.throwErrorException(this.scanner.pos, "err.stackmap.expected", "An integer within the range of [0 to 255]");
                    }
                    if (entryType == StackMap.EntryType.EARLY_LARVAL) {
                        if (wrapLevel > 2) {
                            this.environment.throwErrorException(this.scanner.pos, "err.base.frame.expected", new Object[0]);
                        }
                        ++wrapLevel;
                    }
                    if (stackMapData == null) {
                        stackMapData = new StackMapData(this.environment, this.parser.curCodeAttr.isTypeCheckingVerifier());
                    } else {
                        expectedToken = stackMapData.checkIntegrity();
                        if (expectedToken == null) {
                            list.add(stackMapData);
                            stackMapData = new StackMapData(this.environment, this.parser.curCodeAttr.isTypeCheckingVerifier());
                        } else if (expectedToken == JasmTokens.Token.STACKMAP || stackMapData.getFrameType() == StackMap.EntryType.FULL_FRAME) {
                            stackMapData.stackMap = new DataVector();
                            list.add(stackMapData);
                            stackMapData = new StackMapData(this.environment, this.parser.curCodeAttr.isTypeCheckingVerifier());
                            this.environment.warning(this.scanner.pos, "warn.stackmap.expected", "\"%s\"".formatted(expectedToken.parseKey()));
                        } else {
                            this.environment.throwErrorException(this.scanner.pos, "err.stackmap.expected", "\"%s\"".formatted(expectedToken.parseKey()));
                        }
                    }
                    stackMapData.setStackFrameType(stackFrameTypeValue);
                    if (stackMapData.checkIntegrity() != null) continue block10;
                    list.add(stackMapData);
                    stackMapData = null;
                    continue block10;
                }
                case OFFSETDELTA: {
                    if (stackMapData == null || stackMapData.getFrameType() == StackMap.EntryType.SAME_FRAME) {
                        if (wrapLevel > 0) {
                            this.environment.throwErrorException(this.scanner.pos, "err.token.expected", JasmTokens.Token.RBRACE.parseKey());
                            break;
                        }
                        this.environment.throwErrorException(this.scanner.pos, "err.stackmap.expected", "\"%s\"".formatted(JasmTokens.Token.FRAMETYPE.parseKey()));
                        break;
                    }
                    JasmTokens.Token expectedToken = stackMapData.checkIntegrity();
                    if (expectedToken != JasmTokens.Token.OFFSETDELTA) {
                        this.environment.throwErrorException(this.scanner.pos, "err.stackmap.expected", "\"%s\"".formatted(expectedToken.parseKey()));
                    }
                    this.scanner.scan();
                    this.scanner.expect(JasmTokens.Token.ASSIGN);
                    if (this.scanner.token != JasmTokens.Token.INTVAL) {
                        this.environment.throwErrorException(this.scanner.pos, "err.stackmap.expected", "The offset_delta value");
                    }
                    stackMapData.setOffset(this.scanner.intValue);
                    if (stackMapData.checkIntegrity() != null) break;
                    list.add(stackMapData);
                    stackMapData = null;
                    break;
                }
                case LOCALSMAP: {
                    if (stackMapData == null || stackMapData.getFrameType() == StackMap.EntryType.SAME_FRAME) {
                        if (wrapLevel > 0) {
                            this.environment.throwErrorException(this.scanner.pos, "err.token.expected", JasmTokens.Token.RBRACE.parseKey());
                            break;
                        }
                        this.environment.throwErrorException(this.scanner.pos, "err.stackmap.expected", "\"%s\"".formatted(JasmTokens.Token.FRAMETYPE.parseKey()));
                        break;
                    }
                    JasmTokens.Token expectedToken = stackMapData.checkIntegrity();
                    if (expectedToken != JasmTokens.Token.LOCALSMAP) {
                        this.environment.throwErrorException(this.scanner.pos, "err.stackmap.expected", "\"%s\"".formatted(expectedToken.parseKey()));
                    }
                    this.scanner.scan();
                    this.scanner.expect(JasmTokens.Token.ASSIGN);
                    stackMapData.localsMap = new DataVector();
                    if (this.scanner.token == JasmTokens.Token.IDENT && this.scanner.stringValue.equals(JasmTokens.Token.LSQBRACKET.parseKey() + JasmTokens.Token.RSQBRACKET.parseKey())) {
                        this.scanner.scan();
                    } else {
                        this.scanner.expectIdentContent(JasmTokens.Token.LSQBRACKET);
                        while (this.scanner.token != JasmTokens.Token.EOF) {
                            if (this.scanner.token == JasmTokens.Token.SEMICOLON) {
                                this.scanner.scan();
                                this.scanner.expectIdentContent(JasmTokens.Token.RSQBRACKET);
                                break;
                            }
                            if (this.scanner.token == JasmTokens.Token.IDENT && this.scanner.stringValue.equals(JasmTokens.Token.RSQBRACKET.parseKey())) break;
                            this.parser.parseMapItem(stackMapData.localsMap);
                            if (this.scanner.token != JasmTokens.Token.COMMA) {
                                if (this.scanner.token == JasmTokens.Token.SEMICOLON) continue;
                                this.environment.throwErrorException(this.scanner.pos, "err.token.expected", "\"" + JasmTokens.Token.SEMICOLON.parseKey() + "\"");
                                continue;
                            }
                            this.scanner.scan();
                        }
                    }
                    if (stackMapData.checkIntegrity() != null) continue block10;
                    list.add(stackMapData);
                    stackMapData = null;
                    continue block10;
                }
                case STACKMAP: {
                    if (stackMapData == null || stackMapData.getFrameType() == StackMap.EntryType.SAME_FRAME) {
                        if (wrapLevel > 0) {
                            this.environment.throwErrorException(this.scanner.pos, "err.token.expected", JasmTokens.Token.RBRACE.parseKey());
                            break;
                        }
                        this.environment.throwErrorException(this.scanner.pos, "err.stackmap.expected", "\"%s\"".formatted(JasmTokens.Token.FRAMETYPE.parseKey()));
                        break;
                    }
                    JasmTokens.Token expectedToken = stackMapData.checkIntegrity();
                    if (expectedToken != JasmTokens.Token.STACKMAP && (expectedToken != JasmTokens.Token.LOCALSMAP || stackMapData.getFrameType() != StackMap.EntryType.FULL_FRAME)) {
                        this.environment.throwErrorException(this.scanner.pos, "err.stackmap.expected", "\"%s\"".formatted(expectedToken.parseKey()));
                    }
                    this.scanner.scan();
                    this.scanner.expect(JasmTokens.Token.ASSIGN);
                    stackMapData.stackMap = new DataVector();
                    if (this.scanner.token == JasmTokens.Token.IDENT && this.scanner.stringValue.equals(JasmTokens.Token.LSQBRACKET.parseKey() + JasmTokens.Token.RSQBRACKET.parseKey())) {
                        this.scanner.scan();
                    } else {
                        this.scanner.expectIdentContent(JasmTokens.Token.LSQBRACKET);
                        while (this.scanner.token != JasmTokens.Token.EOF) {
                            if (this.scanner.token == JasmTokens.Token.SEMICOLON) {
                                this.scanner.scan();
                                this.scanner.expectIdentContent(JasmTokens.Token.RSQBRACKET);
                                break;
                            }
                            if (this.scanner.token == JasmTokens.Token.IDENT && this.scanner.stringValue.equals(JasmTokens.Token.RSQBRACKET.parseKey())) break;
                            this.parser.parseMapItem(stackMapData.stackMap);
                            if (this.scanner.token != JasmTokens.Token.COMMA) {
                                if (this.scanner.token == JasmTokens.Token.SEMICOLON) continue;
                                this.environment.throwErrorException(this.scanner.pos, "err.token.expected", "\"" + JasmTokens.Token.SEMICOLON.parseKey() + "\"");
                                continue;
                            }
                            this.scanner.scan();
                        }
                    }
                    if (stackMapData.checkIntegrity() != null) continue block10;
                    list.add(stackMapData);
                    stackMapData = null;
                    continue block10;
                }
                case UNSETFIELDS: {
                    if (stackMapData == null || stackMapData.getFrameType() == StackMap.EntryType.SAME_FRAME) {
                        if (wrapLevel > 0) {
                            this.environment.throwErrorException(this.scanner.pos, "err.token.expected", JasmTokens.Token.RBRACE.parseKey());
                            break;
                        }
                        this.environment.throwErrorException(this.scanner.pos, "err.stackmap.expected", "\"%s\"".formatted(JasmTokens.Token.FRAMETYPE.parseKey()));
                        break;
                    }
                    JasmTokens.Token expectedToken = stackMapData.checkIntegrity();
                    if (expectedToken != JasmTokens.Token.UNSETFIELDS) {
                        this.environment.throwErrorException(this.scanner.pos, "err.stackmap.expected", "\"%s\"".formatted(expectedToken.parseKey()));
                    }
                    this.scanner.scan();
                    this.scanner.expect(JasmTokens.Token.ASSIGN);
                    stackMapData.unsetFields = new DataVector();
                    if (this.scanner.token == JasmTokens.Token.IDENT && this.scanner.stringValue.equals(JasmTokens.Token.LSQBRACKET.parseKey() + JasmTokens.Token.RSQBRACKET.parseKey())) {
                        this.scanner.scan();
                    } else {
                        this.scanner.expectIdentContent(JasmTokens.Token.LSQBRACKET);
                        while (this.scanner.token != JasmTokens.Token.EOF) {
                            if (this.scanner.token == JasmTokens.Token.SEMICOLON) {
                                this.scanner.scan();
                                this.scanner.expectIdentContent(JasmTokens.Token.RSQBRACKET);
                                break;
                            }
                            if (this.scanner.token == JasmTokens.Token.IDENT && this.scanner.stringValue.equals(JasmTokens.Token.RSQBRACKET.parseKey())) break;
                            this.parser.parseNameAndType(stackMapData.unsetFields);
                            if (this.scanner.token != JasmTokens.Token.COMMA) {
                                if (this.scanner.token == JasmTokens.Token.SEMICOLON) continue;
                                this.environment.throwErrorException(this.scanner.pos, "err.token.expected", JasmTokens.Token.SEMICOLON.parseKey());
                                continue;
                            }
                            this.scanner.scan();
                        }
                    }
                    if (stackMapData.checkIntegrity() != null) continue block10;
                    list.add(stackMapData);
                    stackMapData = null;
                    continue block10;
                }
            }
            this.scanner.scan();
        }
        return list;
    }

    public List<LineNumberData> parseLineTable() {
        ArrayList<LineNumberData> list = new ArrayList<LineNumberData>();
        this.scanner.scan();
        if (this.scanner.token == JasmTokens.Token.COLON) {
            this.scanner.scan();
        }
        int start_pc = -1;
        int line_number = -1;
        boolean newLine = true;
        boolean colonFound = false;
        while (this.scanner.token != JasmTokens.Token.EOF && this.scanner.token != JasmTokens.Token.RBRACE) {
            switch (this.scanner.token) {
                case COLON: {
                    if (newLine) {
                        this.environment.throwErrorException(this.scanner.pos, "err.expected.linetable", "line keyword");
                    }
                    if (line_number == -1) {
                        this.environment.throwErrorException(this.scanner.pos, "err.expected.linetable", "line_number:");
                    } else if (colonFound) {
                        if (start_pc == -1) {
                            this.environment.throwErrorException(this.scanner.pos, "err.expected.linetable", "start_pc");
                        } else {
                            this.environment.throwErrorException(this.scanner.pos, "err.expected.linetable", "line keyword");
                        }
                    }
                    colonFound = true;
                    break;
                }
                case LINE: {
                    if (!newLine) {
                        this.environment.throwErrorException(this.scanner.pos, "err.expected.linetable", "line  line_number:  start_pc");
                    }
                    newLine = false;
                    break;
                }
                case INTVAL: {
                    if (line_number == -1) {
                        line_number = this.scanner.intValue;
                        break;
                    }
                    start_pc = this.scanner.intValue;
                    list.add(new LineNumberData(start_pc, line_number));
                    newLine = true;
                    colonFound = false;
                    line_number = -1;
                    start_pc = -1;
                    break;
                }
                default: {
                    if (line_number != -1 || start_pc != -1 || !newLine) {
                        this.environment.throwErrorException(this.scanner.pos, "err.expected.linetable", "line  line_number:  start_pc");
                    }
                    return list;
                }
            }
            this.scanner.scan();
        }
        return list;
    }
}

