/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jasm;

import java.util.ArrayList;
import java.util.function.BiFunction;
import org.openjdk.asmtools.common.SyntaxError;
import org.openjdk.asmtools.jasm.BootstrapMethodData;
import org.openjdk.asmtools.jasm.CPTagVisitor;
import org.openjdk.asmtools.jasm.ClassFileConst;
import org.openjdk.asmtools.jasm.ConstCell;
import org.openjdk.asmtools.jasm.ConstValue;
import org.openjdk.asmtools.jasm.ConstantPool;
import org.openjdk.asmtools.jasm.JasmTokens;
import org.openjdk.asmtools.jasm.ParseBase;
import org.openjdk.asmtools.jasm.Parser;

public class ParseConstPool
extends ParseBase {
    private final ParserCPVisitor pConstVstr;
    private boolean exitImmediately = false;
    private int lbrace = 0;

    protected ParseConstPool(Parser parentParser) {
        super.init(parentParser);
        this.pConstVstr = new ParserCPVisitor();
    }

    public void setExitImmediately(boolean exitImmediately) {
        this.exitImmediately = exitImmediately;
    }

    protected ConstValue<?> parseConstValue(ClassFileConst.ConstType tag) throws SyntaxError {
        return this.pConstVstr.visitExcept(tag);
    }

    private ClassFileConst.ConstType scanConstByID(boolean ignoreKeywords, boolean isBSMArgTag) throws SyntaxError {
        ClassFileConst.ConstType tag = null;
        if (!ignoreKeywords) {
            tag = isBSMArgTag ? ClassFileConst.getBSMArgumentTypeByParseKey(this.scanner.idValue) : ClassFileConst.getByParseKey(this.scanner.idValue);
        }
        this.traceMethodInfoLn(String.format("\t\tTag: %s ", tag == null ? "<not found>" : tag));
        return tag;
    }

    private ClassFileConst.ConstType scanConstPrimVal() throws SyntaxError {
        return switch (this.scanner.token) {
            case JasmTokens.Token.BYTE -> ClassFileConst.ConstType.CONSTANT_BYTE;
            case JasmTokens.Token.BYTEVAL -> ClassFileConst.ConstType.CONSTANT_C_BYTE;
            case JasmTokens.Token.CHAR -> ClassFileConst.ConstType.CONSTANT_CHAR;
            case JasmTokens.Token.CHARVAL -> ClassFileConst.ConstType.CONSTANT_C_CHAR;
            case JasmTokens.Token.DOUBLE -> ClassFileConst.ConstType.CONSTANT_DOUBLE;
            case JasmTokens.Token.DOUBLEVAL -> ClassFileConst.ConstType.CONSTANT_C_DOUBLE;
            case JasmTokens.Token.FLOAT -> ClassFileConst.ConstType.CONSTANT_FLOAT;
            case JasmTokens.Token.FLOATVAL -> ClassFileConst.ConstType.CONSTANT_C_FLOAT;
            case JasmTokens.Token.LONG -> ClassFileConst.ConstType.CONSTANT_LONG;
            case JasmTokens.Token.LONGVAL -> ClassFileConst.ConstType.CONSTANT_C_LONG;
            case JasmTokens.Token.INT -> ClassFileConst.ConstType.CONSTANT_INT;
            case JasmTokens.Token.INTVAL -> ClassFileConst.ConstType.CONSTANT_INTEGER;
            case JasmTokens.Token.SHORT -> ClassFileConst.ConstType.CONSTANT_SHORT;
            case JasmTokens.Token.SHORTVAL -> ClassFileConst.ConstType.CONSTANT_C_SHORT;
            case JasmTokens.Token.BOOLEAN -> ClassFileConst.ConstType.CONSTANT_BOOLEAN;
            case JasmTokens.Token.BOOLEANVAL -> ClassFileConst.ConstType.CONSTANT_C_BOOLEAN;
            case JasmTokens.Token.STRINGVAL, JasmTokens.Token.BITS, JasmTokens.Token.IDENT -> ClassFileConst.ConstType.CONSTANT_STRING;
            default -> {
                this.environment.error(this.scanner.pos, "err.value.expected", this.scanner.token.printValue());
                throw new SyntaxError();
            }
        };
    }

    private void checkWrongTag(ClassFileConst.ConstType tag, ClassFileConst.ConstType defaultTag, ClassFileConst.ConstType default2Tag) throws SyntaxError {
        if (defaultTag != null && !tag.equals(defaultTag)) {
            if (default2Tag == null) {
                if (this.exitImmediately) {
                    this.environment.error(this.scanner.pos, "err.wrong.tag", defaultTag.parseKey());
                    throw new SyntaxError().setFatal();
                }
                this.environment.warning(this.scanner.pos, "warn.wrong.tag", defaultTag.parseKey());
            } else if (!tag.equals(default2Tag)) {
                if (this.exitImmediately) {
                    this.environment.error(this.scanner.pos, "err.wrong.tag2", defaultTag.parseKey(), default2Tag.parseKey());
                    throw new SyntaxError().setFatal();
                }
                this.environment.warning(this.scanner.pos, "warn.wrong.tag2", defaultTag.parseKey(), default2Tag.parseKey());
            }
        }
    }

    protected ConstValue<?> parseTagConstValue(ClassFileConst.ConstType defaultTag, ClassFileConst.ConstType default2Tag, boolean ignoreKeywords, boolean isBSMArgTag) throws SyntaxError {
        this.traceMethodInfoLn(() -> "\t<< DefaultTag: %s 2nd DefaultTag: %s IgnoreKeyword?: %b".formatted(defaultTag == null ? "<none>" : defaultTag, default2Tag == null ? "<none>" : default2Tag, ignoreKeywords));
        ClassFileConst.ConstType tag = this.scanConstByID(ignoreKeywords, isBSMArgTag);
        this.traceMethodInfoLn("\tResult Tag: %s >>".formatted(new Object[]{tag}));
        if (tag == null) {
            tag = defaultTag == null ? this.scanConstPrimVal() : defaultTag;
        } else {
            this.checkWrongTag(tag, defaultTag, default2Tag);
            this.scanner.scan();
        }
        return this.parseConstValue(tag);
    }

    protected ConstCell<?> parseConstRef(ClassFileConst.ConstType defaultTag) throws SyntaxError {
        return this.parseConstRef(defaultTag, null, false);
    }

    protected ConstCell<?> parseConstPoolRef() throws SyntaxError {
        ClassFileConst.ConstType tag = this.scanConstByID(false, true);
        if (tag == null || tag.getTag() < 1) {
            ConstValue ref = switch (this.scanner.token) {
                case JasmTokens.Token.IDENT -> {
                    String value = this.scanner.stringValue;
                    if (value.equalsIgnoreCase("true")) {
                        yield new ConstantPool.ConstValue_Integer(ClassFileConst.ConstType.CONSTANT_BOOLEAN, 1);
                    }
                    if (value.equalsIgnoreCase("false")) {
                        yield new ConstantPool.ConstValue_Integer(ClassFileConst.ConstType.CONSTANT_BOOLEAN, 0);
                    }
                    this.environment.error(this.scanner.pos, "err.constant.kind.expected", new Object[0]);
                    throw new SyntaxError().setFatal();
                }
                case JasmTokens.Token.STRINGVAL -> new ConstantPool.ConstValue_UTF8(this.scanner.stringValue);
                case JasmTokens.Token.INTVAL -> new ConstantPool.ConstValue_Integer(ClassFileConst.ConstType.CONSTANT_INT, this.scanner.intValue);
                case JasmTokens.Token.BYTEVAL -> new ConstantPool.ConstValue_Integer(ClassFileConst.ConstType.CONSTANT_BYTE, this.scanner.intValue);
                case JasmTokens.Token.SHORTVAL -> new ConstantPool.ConstValue_Integer(ClassFileConst.ConstType.CONSTANT_SHORT, this.scanner.intValue);
                case JasmTokens.Token.CHARVAL -> new ConstantPool.ConstValue_Integer(ClassFileConst.ConstType.CONSTANT_CHAR, this.scanner.intValue);
                case JasmTokens.Token.BOOLEANVAL -> new ConstantPool.ConstValue_Integer(ClassFileConst.ConstType.CONSTANT_BOOLEAN, this.scanner.intValue);
                case JasmTokens.Token.FLOATVAL -> new ConstantPool.ConstValue_Float(Float.floatToIntBits(this.scanner.floatValue));
                case JasmTokens.Token.DOUBLEVAL -> new ConstantPool.ConstValue_Double(Double.doubleToLongBits(this.scanner.doubleValue));
                case JasmTokens.Token.LONGVAL -> new ConstantPool.ConstValue_Long(this.scanner.longValue);
                default -> {
                    this.environment.error(this.scanner.pos, "err.constant.kind.expected", new Object[0]);
                    throw new SyntaxError().setFatal();
                }
            };
            this.scanner.scan();
            return this.parser.pool.findCell(ref);
        }
        this.scanner.scan();
        ConstValue<?> ref = this.parseConstValue(tag);
        return this.parser.pool.findCell(ref);
    }

    protected ConstCell<?> parseConstRef(ClassFileConst.ConstType defaultTag, ClassFileConst.ConstType default2Tag) throws SyntaxError {
        return this.parseConstRef(defaultTag, default2Tag, false);
    }

    protected ConstCell<?> parseConstRef(ClassFileConst.ConstType defaultTag, ClassFileConst.ConstType default2Tag, boolean ignoreKeywords) throws SyntaxError {
        if (this.scanner.token == JasmTokens.Token.CPINDEX) {
            int cpx = this.scanner.intValue;
            this.scanner.scan();
            return this.parser.pool.getCell(cpx);
        }
        ConstValue<?> ref = this.parseTagConstValue(defaultTag, default2Tag, ignoreKeywords, false);
        return this.parser.pool.findCell(ref);
    }

    protected ConstCell<?> parseBSMArgumentConstRef() throws SyntaxError {
        if (this.scanner.token == JasmTokens.Token.CPINDEX) {
            int cpx = this.scanner.intValue;
            this.scanner.scan();
            return this.parser.pool.getCell(cpx);
        }
        ConstValue<?> ref = this.parseTagConstValue(null, null, false, true);
        return this.parser.pool.findCell(ref);
    }

    public ParseConstPool decLBRACE() {
        --this.lbrace;
        return this;
    }

    public ParseConstPool incLBRACE() {
        ++this.lbrace;
        return this;
    }

    class ParserCPVisitor
    extends CPTagVisitor<ConstValue<?>> {
        private SyntaxError syntaxError;

        ParserCPVisitor() {
        }

        public ConstValue<?> visitExcept(ClassFileConst.ConstType tag) throws SyntaxError {
            this.syntaxError = null;
            ParseConstPool.this.traceMethodInfoLn();
            ConstValue ret = (ConstValue)this.visit(tag);
            if (this.syntaxError != null) {
                throw this.syntaxError;
            }
            return ret;
        }

        @Override
        public ConstValue<?> visitUTF8() {
            ParseConstPool.this.traceMethodInfoLn();
            try {
                ParseConstPool.this.scanner.expect(JasmTokens.Token.STRINGVAL);
            }
            catch (SyntaxError se) {
                this.syntaxError = se;
            }
            return new ConstantPool.ConstValue_UTF8(ParseConstPool.this.scanner.stringValue);
        }

        @Override
        public ConstValue<?> visitInteger(ClassFileConst.ConstType tag) {
            ParseConstPool.this.traceMethodInfoLn();
            int v = 0;
            try {
                if (ParseConstPool.this.scanner.token == JasmTokens.Token.BITS) {
                    ParseConstPool.this.scanner.scan();
                    ParseConstPool.this.scanner.inBits = true;
                }
                v = ParseConstPool.this.scanner.intValue * ParseConstPool.this.scanner.sign;
                ParseConstPool.this.scanner.expect(JasmTokens.Token.INTVAL);
            }
            catch (SyntaxError se) {
                this.syntaxError = se;
            }
            return new ConstantPool.ConstValue_Integer(tag, v);
        }

        @Override
        public ConstValue<?> visitLong() {
            ParseConstPool.this.traceMethodInfoLn();
            ConstantPool.ConstValue_Long valueLong = null;
            try {
                if (ParseConstPool.this.scanner.token == JasmTokens.Token.BITS) {
                    ParseConstPool.this.scanner.scan();
                    ParseConstPool.this.scanner.inBits = true;
                }
                valueLong = new ConstantPool.ConstValue_Long((switch (ParseConstPool.this.scanner.token) {
                    case JasmTokens.Token.INTVAL -> ParseConstPool.this.scanner.intValue;
                    case JasmTokens.Token.LONGVAL -> ParseConstPool.this.scanner.longValue;
                    default -> {
                        ParseConstPool.this.environment.error(ParseConstPool.this.scanner.prevPos, "err.token.expected", "Integer");
                        throw new SyntaxError();
                    }
                }) * (long)ParseConstPool.this.scanner.sign);
                ParseConstPool.this.scanner.scan();
            }
            catch (SyntaxError se) {
                this.syntaxError = se;
            }
            return valueLong;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public ConstValue<?> visitFloat() {
            ParseConstPool.this.traceMethodInfoLn();
            ConstantPool.ConstValue_Float valueFloat = null;
            try {
                int v;
                block13: {
                    float f;
                    ParseConstPool.this.scanner.inBits = false;
                    if (ParseConstPool.this.scanner.token == JasmTokens.Token.BITS) {
                        ParseConstPool.this.scanner.scan();
                        ParseConstPool.this.scanner.inBits = true;
                    }
                    switch (ParseConstPool.this.scanner.token) {
                        case INTVAL: {
                            if (ParseConstPool.this.scanner.inBits) {
                                v = ParseConstPool.this.scanner.intValue;
                                break block13;
                            } else {
                                f = ParseConstPool.this.scanner.intValue;
                                break;
                            }
                        }
                        case FLOATVAL: {
                            f = ParseConstPool.this.scanner.floatValue;
                            break;
                        }
                        case DOUBLEVAL: {
                            f = (float)ParseConstPool.this.scanner.doubleValue;
                            break;
                        }
                        case INF: {
                            f = Float.POSITIVE_INFINITY;
                            break;
                        }
                        case NAN: {
                            f = Float.NaN;
                            break;
                        }
                        default: {
                            ParseConstPool.this.environment.traceln(() -> "token=" + ParseConstPool.this.scanner.token);
                            ParseConstPool.this.environment.error(ParseConstPool.this.scanner.pos, "err.token.expected", "<Float>");
                            throw new SyntaxError();
                        }
                    }
                    v = Float.floatToIntBits(f);
                }
                if (ParseConstPool.this.scanner.sign == -1) {
                    v ^= Integer.MIN_VALUE;
                }
                valueFloat = new ConstantPool.ConstValue_Float(v);
                ParseConstPool.this.scanner.scan();
                return valueFloat;
            }
            catch (SyntaxError se) {
                this.syntaxError = se;
            }
            return valueFloat;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public ConstValue<?> visitDouble() {
            ParseConstPool.this.traceMethodInfoLn();
            ConstantPool.ConstValue_Double valueDouble = null;
            try {
                long v;
                block16: {
                    double d;
                    if (ParseConstPool.this.scanner.token == JasmTokens.Token.BITS) {
                        ParseConstPool.this.scanner.scan();
                        ParseConstPool.this.scanner.inBits = true;
                    }
                    switch (ParseConstPool.this.scanner.token) {
                        case INTVAL: {
                            if (ParseConstPool.this.scanner.inBits) {
                                v = ParseConstPool.this.scanner.intValue;
                                break block16;
                            } else {
                                d = ParseConstPool.this.scanner.intValue;
                                break;
                            }
                        }
                        case LONGVAL: {
                            if (ParseConstPool.this.scanner.inBits) {
                                v = ParseConstPool.this.scanner.longValue;
                                break block16;
                            } else {
                                d = ParseConstPool.this.scanner.longValue;
                                break;
                            }
                        }
                        case FLOATVAL: {
                            d = ParseConstPool.this.scanner.floatValue;
                            break;
                        }
                        case DOUBLEVAL: {
                            d = ParseConstPool.this.scanner.doubleValue;
                            break;
                        }
                        case INF: {
                            d = Double.POSITIVE_INFINITY;
                            break;
                        }
                        case NAN: {
                            d = Double.NaN;
                            break;
                        }
                        default: {
                            ParseConstPool.this.environment.error(ParseConstPool.this.scanner.pos, "err.token.expected", "Double");
                            throw new SyntaxError();
                        }
                    }
                    v = Double.doubleToLongBits(d);
                }
                if (ParseConstPool.this.scanner.sign == -1) {
                    v ^= Long.MIN_VALUE;
                }
                valueDouble = new ConstantPool.ConstValue_Double(v);
                ParseConstPool.this.scanner.scan();
                return valueDouble;
            }
            catch (SyntaxError se) {
                this.syntaxError = se;
            }
            return valueDouble;
        }

        public ConstCell<?> visitName() {
            ParseConstPool.this.traceMethodInfoLn();
            ConstCell obj = null;
            try {
                obj = ParseConstPool.this.parser.parseName();
            }
            catch (SyntaxError se) {
                this.syntaxError = se;
            }
            return obj;
        }

        @Override
        public ConstValue<?> visitMethodType() {
            ParseConstPool.this.traceMethodInfoLn();
            ConstantPool.ConstValue_MethodType obj = null;
            ConstCell<ConstantPool.ConstValue_UTF8> cell = this.visitName();
            if (this.syntaxError == null) {
                obj = new ConstantPool.ConstValue_MethodType(cell);
            }
            return obj;
        }

        @Override
        public ConstValue<?> visitString() {
            ParseConstPool.this.traceMethodInfoLn();
            ConstantPool.ConstValue_String obj = null;
            ConstCell<ConstantPool.ConstValue_UTF8> cell = this.visitName();
            if (this.syntaxError == null) {
                obj = new ConstantPool.ConstValue_String(cell);
            }
            return obj;
        }

        @Override
        public ConstValue<?> visitClass() {
            ParseConstPool.this.traceMethodInfoLn();
            ConstantPool.ConstValue_Class obj = null;
            try {
                ConstCell cell = ParseConstPool.this.parser.parseConstantClassInfo(true);
                obj = new ConstantPool.ConstValue_Class(cell);
            }
            catch (SyntaxError se) {
                this.syntaxError = se;
            }
            return obj;
        }

        @Override
        public ConstValue<?> visitPackage() {
            ParseConstPool.this.traceMethodInfoLn();
            ConstantPool.ConstValue_Package obj = null;
            try {
                ConstCell cell = ParseConstPool.this.parser.parseConstantPackageInfo();
                obj = new ConstantPool.ConstValue_Package(cell);
            }
            catch (SyntaxError se) {
                this.syntaxError = se;
            }
            return obj;
        }

        @Override
        public ConstValue<?> visitModule() {
            ParseConstPool.this.traceMethodInfoLn();
            ConstantPool.ConstValue_Module obj = null;
            try {
                ConstCell cell = ParseConstPool.this.parser.parseConstantModuleInfo();
                obj = new ConstantPool.ConstValue_Module(cell);
            }
            catch (SyntaxError se) {
                this.syntaxError = se;
            }
            return obj;
        }

        @Override
        public ConstValue<?> visitMethodHandle() {
            ParseConstPool.this.traceMethodInfoLn();
            ConstantPool.ConstValue_MethodHandle obj = null;
            try {
                ConstCell refCell;
                ClassFileConst.SubTag subTag;
                if (ParseConstPool.this.scanner.token == JasmTokens.Token.INTVAL) {
                    subTag = ClassFileConst.subTag(ParseConstPool.this.scanner.intValue);
                    ParseConstPool.this.scanner.scan();
                    ParseConstPool.this.scanner.expect(JasmTokens.Token.COLON);
                    if (ParseConstPool.this.scanner.token == JasmTokens.Token.CPINDEX) {
                        int cpx = ParseConstPool.this.scanner.intValue;
                        refCell = ParseConstPool.this.parser.pool.getCell(cpx);
                        ParseConstPool.this.scanner.scan();
                    } else {
                        refCell = ParseConstPool.this.parser.parseMethodHandle(subTag);
                    }
                } else {
                    subTag = ParseConstPool.this.parser.parseSubtag();
                    ParseConstPool.this.scanner.expect(JasmTokens.Token.COLON);
                    if (ParseConstPool.this.scanner.token == JasmTokens.Token.CPINDEX) {
                        int cpx = ParseConstPool.this.scanner.intValue;
                        refCell = ParseConstPool.this.parser.pool.getCell(cpx);
                        ParseConstPool.this.scanner.scan();
                    } else {
                        refCell = ParseConstPool.this.parser.parseMethodHandle(subTag);
                    }
                }
                obj = new ConstantPool.ConstValue_MethodHandle(subTag, refCell);
            }
            catch (SyntaxError se) {
                this.syntaxError = se;
            }
            return obj;
        }

        public <T extends ConstantPool.ConstValue_Pair<ConstantPool.ConstValue_Class, ConstantPool.ConstValue_NameAndType>> T visitMember(ClassFileConst.ConstType tag) {
            ParseConstPool.this.traceMethodInfoLn();
            ConstantPool.ConstValue_Pair constValue = null;
            try {
                ConstCell NapeCell;
                ConstCell NameCell;
                ConstCell<Object> ClassCell;
                JasmTokens.Token prevToken = ParseConstPool.this.scanner.token;
                ConstCell firstName = ParseConstPool.this.parser.parseConstantClassInfo(false);
                if (ParseConstPool.this.scanner.token == JasmTokens.Token.FIELD) {
                    ParseConstPool.this.scanner.scan();
                    ClassCell = prevToken == JasmTokens.Token.CPINDEX ? firstName : ParseConstPool.this.parser.pool.findCell(ClassFileConst.ConstType.CONSTANT_CLASS, firstName);
                    NameCell = ParseConstPool.this.parser.parseName();
                } else {
                    ClassCell = ParseConstPool.this.parser.classData.coreClasses.this_class().isSet() || ParseConstPool.this.parser.classData.coreClasses.this_class().ref == null ? ParseConstPool.this.parser.classData.coreClasses.this_class() : ParseConstPool.this.parser.pool.findCell((ConstantPool.ConstValue_Class)ParseConstPool.this.parser.classData.coreClasses.this_class().ref);
                    NameCell = firstName;
                }
                if (ParseConstPool.this.scanner.token == JasmTokens.Token.COLON) {
                    ParseConstPool.this.scanner.scan();
                    NapeCell = ParseConstPool.this.parser.pool.findCell(ClassFileConst.ConstType.CONSTANT_NAMEANDTYPE, NameCell, ParseConstPool.this.parser.parseName());
                } else {
                    NapeCell = NameCell;
                }
                switch (tag) {
                    case CONSTANT_INTERFACEMETHODREF: {
                        constValue = new ConstantPool.ConstValue_InterfaceMethodRef(ClassCell, NapeCell);
                        break;
                    }
                    case CONSTANT_METHODREF: {
                        constValue = new ConstantPool.ConstValue_MethodRef(ClassCell, NapeCell);
                        break;
                    }
                    case CONSTANT_FIELDREF: {
                        constValue = new ConstantPool.ConstValue_FieldRef(ClassCell, NapeCell);
                    }
                }
                if (constValue == null) {
                    ParseConstPool.this.environment.error("err.invalid.type", tag.printVal());
                    throw new SyntaxError().setFatal();
                }
            }
            catch (SyntaxError se) {
                this.syntaxError = se;
            }
            return (T)constValue;
        }

        @Override
        public ConstValue<?> visitField() {
            ParseConstPool.this.traceMethodInfoLn();
            return this.visitMember(ClassFileConst.ConstType.CONSTANT_FIELDREF);
        }

        @Override
        public ConstValue<?> visitMethod() {
            ParseConstPool.this.traceMethodInfoLn();
            return this.visitMember(ClassFileConst.ConstType.CONSTANT_METHODREF);
        }

        @Override
        public ConstValue<?> visitInterfaceMethod() {
            ParseConstPool.this.traceMethodInfoLn();
            return this.visitMember(ClassFileConst.ConstType.CONSTANT_INTERFACEMETHODREF);
        }

        @Override
        public ConstValue<?> visitNameAndType() {
            ParseConstPool.this.traceMethodInfoLn();
            ConstantPool.ConstValue_NameAndType obj = null;
            try {
                ConstCell NameCell = ParseConstPool.this.parser.parseName();
                ParseConstPool.this.scanner.expect(JasmTokens.Token.COLON);
                ConstCell TypeCell = ParseConstPool.this.parser.parseName();
                obj = new ConstantPool.ConstValue_NameAndType(NameCell, TypeCell);
            }
            catch (SyntaxError se) {
                this.syntaxError = se;
            }
            return obj;
        }

        @Override
        public ConstantPool.ConstValue_InvokeDynamic visitInvokeDynamic() {
            ParseConstPool.this.traceMethodInfoLn();
            BiFunction<BootstrapMethodData, ConstCell, ConstantPool.ConstValue_InvokeDynamic> ctor = ConstantPool.ConstValue_InvokeDynamic::new;
            return this.visitBsm(ctor);
        }

        @Override
        public ConstantPool.ConstValue_Dynamic visitDynamic() {
            ParseConstPool.this.traceMethodInfoLn();
            BiFunction<BootstrapMethodData, ConstCell, ConstantPool.ConstValue_Dynamic> ctor = ConstantPool.ConstValue_Dynamic::new;
            return this.visitBsm(ctor);
        }

        private <E extends ConstantPool.ConstValue_BootstrapMethod> E visitBsm(BiFunction<BootstrapMethodData, ConstCell<?>, E> ctor) {
            ConstantPool.ConstValue_BootstrapMethod obj = null;
            try {
                if (ParseConstPool.this.scanner.token == JasmTokens.Token.INTVAL) {
                    int bsmIndex = ParseConstPool.this.scanner.intValue;
                    ParseConstPool.this.scanner.scan();
                    ParseConstPool.this.scanner.expect(JasmTokens.Token.COLON);
                    if (ParseConstPool.this.scanner.token != JasmTokens.Token.CPINDEX) {
                        ParseConstPool.this.environment.traceln(() -> "token=" + ParseConstPool.this.scanner.token);
                        ParseConstPool.this.environment.error(ParseConstPool.this.scanner.pos, "err.token.expected", "<CPINDEX>");
                        throw new SyntaxError();
                    }
                    int cpx = ParseConstPool.this.scanner.intValue;
                    ParseConstPool.this.scanner.scan();
                    BootstrapMethodData bsmData = new BootstrapMethodData(bsmIndex);
                    obj = (ConstantPool.ConstValue_BootstrapMethod)ctor.apply(bsmData, ParseConstPool.this.parser.pool.getCell(cpx));
                } else {
                    ConstCell<ConstValue<?>> MHCell = ParseConstPool.this.parser.pool.findCell(ParseConstPool.this.parseConstValue(ClassFileConst.ConstType.CONSTANT_METHODHANDLE));
                    ParseConstPool.this.scanner.expect(JasmTokens.Token.COLON);
                    ConstCell<ConstValue<?>> NapeCell = ParseConstPool.this.parser.pool.findCell(ParseConstPool.this.parseConstValue(ClassFileConst.ConstType.CONSTANT_NAMEANDTYPE));
                    if (ParseConstPool.this.scanner.token == JasmTokens.Token.LBRACE) {
                        ParseConstPool.this.incLBRACE();
                        ParseConstPool.this.scanner.scan();
                    }
                    ArrayList bsm_args = new ArrayList(256);
                    while (true) {
                        if (ParseConstPool.this.lbrace > 0) {
                            if (ParseConstPool.this.scanner.token == JasmTokens.Token.RBRACE) {
                                ParseConstPool.this.decLBRACE();
                                ParseConstPool.this.scanner.scan();
                                break;
                            }
                            if (ParseConstPool.this.scanner.token == JasmTokens.Token.SEMICOLON) {
                                ParseConstPool.this.scanner.expect(JasmTokens.Token.RBRACE);
                            }
                        } else if (ParseConstPool.this.scanner.token == JasmTokens.Token.SEMICOLON) break;
                        if (ParseConstPool.this.scanner.token == JasmTokens.Token.COMMA) {
                            ParseConstPool.this.scanner.scan();
                        }
                        ConstCell<?> cell = ParseConstPool.this.parseBSMArgumentConstRef();
                        bsm_args.add(cell);
                    }
                    if (ParseConstPool.this.lbrace == 0) {
                        ParseConstPool.this.scanner.check(JasmTokens.Token.SEMICOLON);
                    }
                    BootstrapMethodData bsmData = new BootstrapMethodData(MHCell, bsm_args);
                    ParseConstPool.this.parser.classData.addBootstrapMethod(bsmData);
                    obj = (ConstantPool.ConstValue_BootstrapMethod)ctor.apply(bsmData, NapeCell);
                }
            }
            catch (SyntaxError se) {
                this.syntaxError = se;
            }
            return (E)obj;
        }
    }
}

